// ------------------------------------------------------- //
// STEP
// 1. open form and save
// 2. check validate required
// 3. display message
// on open form form_validate_required() is append * required
// ------------------------------------------------------ //

function form_validate()
{
    let ignor_field = ['password', 'confirm_password'];

    if(typeof validate !=='undefined')
    {
        for(let field in validate)
        {
            let options = validate[field];
            let ele = $('#'+field);
            let val = ele.val();

            if(ele.hasClass('ckeditor') && typeof CKEDITOR !== 'undefined')
            {
                val = CKEDITOR.instances[field].getData();
            }

            if(!val && !ignor_field.includes(field))
            {
                ele.focus();
                let msg = 'กรุณาระบุ ' + ele.closest('.form-group').find('label').text();
                if(typeof options.msg !== undefined && options.msg !== 'undefined' && options.msg !== '' && options.msg !== undefined)
                {
                    msg = options.msg;
                }
                warning(msg);
                return false;
            }

            if(typeof options.length !== 'undefined' && val.length !== options.length)
            {
                ele.focus();
                warning('กรุณากรอก '+options.length+' ตัวอักษร');
                return false;
            }

            if(typeof options.number !== 'undefined' && !numberCheck.test(val))
            {
                ele.focus();
                warning('กรุณากรอกตัวเลขเท่านั้น');
                return false;
            }

            if(typeof options.eng !== 'undefined' && !englishCheck.test(val))
            {
                ele.focus();
                warning('กรุณากรอกเป็นภาษาอังกฤษเท่านั้น และห้ามเว้นว่าง');
                return false;
            }

            if(typeof options.email !== 'undefined' && !validateEmail.test(val))
            {
                ele.focus();
                warning('รูปแบบอีเมลไม่ถูกต้อง');
                return false;
            }

            if(typeof options.min !== 'undefined' && val && val.length < options.min)
            {
                ele.focus();
                error('กรุณากรอกอย่างน้อย '+options.min+' ตัวอักษร');
                return false;
            }

            if(typeof options.max !== 'undefined' && val && val.length > options.max)
            {
                ele.focus();
                error('กรุณากรอกไม่เกิน '+options.max+' ตัวอักษร');
                return false;
            }

            if(typeof options.password !== 'undefined' && val && !strengthPassword.test(val))
            {
                console.log(strengthPassword);
                ele.focus();
                error(options.msg, 4000);
                return false;
            }

            if(typeof options.equalTo !== 'undefined' && $(options.equalTo.to).val())
            {
                if(typeof options.equalTo.to !== 'undefined' && !val || val !== $(options.equalTo.to).val())
                {
                    ele.focus();
                    error(options.equalTo.msg);
                    return false;
                }
            }

            if(typeof options.existing !== 'undefined' && options.existing.require === true)
            {
                if(!EXISTING_PATH)
                {
                    EXISTING_PATH = 'bos/' + $('.main').attr('component') + '/existing';
                }

                let req = $.ajax({
                    url: OFFICE_API_URL + EXISTING_PATH,
                    method: 'POST',
                    data: {field: field, val: val, exclude: $(options.existing.exclude).val()},
                    headers: {'Authorization': 'Bearer ' + get_token()},
                    async: false,
                    success: function(response){}
                });

                //console.log(req.responseJSON);
                if(typeof req !== 'undefined'
                    && typeof req.responseJSON !== 'undefined'
                    && typeof req.responseJSON.success !== 'undefined'
                    && req.responseJSON.success === false)
                {
                    error(req.responseJSON.message);
                    ele.focus();
                    return false;
                }
            }
        }
    }
    return true;
}

function form_validate_required()
{
    if(validate)
    {
        for(let key in validate)
        {
            let ele = $('#'+key);
            $(ele).closest('.form-group').find('label').eq(0).prepend('<span class="text-danger">*</span> ');
        }
    }
}

function form_ckeditor(modal) {
    if(modal.find('.ckeditor').length > 0)
    {
        //config
        let editorHeight = 200;
        $('.ckeditor').each(function(){
            if($(this).attr('ck-height') && $(this).attr('ck-height').length){
                editorHeight = $(this).attr('ck-height');
            }
            let editor = CKEDITOR.replace(this, {
                height: editorHeight
            });
            CKFinder.setupCKEditor(editor, ASSETS_CKFINDER);
        });
    }
}