//region back to top
var offset = 200;
var duration = 500;
var sticky = 0;
$(window).scroll(function() {
    //nav
    if($(this).scrollTop() > 10) {
        $('.navbar').addClass('.navbar-shadow');
    }
    else {
        $('.navbar').removeClass('.navbar-shadow');
    }

    //to top
    if ($(this).scrollTop() > offset) {
        $('.back-to-top').fadeIn(400)
        $('.bg-white').addClass('bg-shadow ');
    } else {
        $('.back-to-top').fadeOut(400);
        $('.bg-white').removeClass('bg-shadow ');
    }
    //fixed header
    let has_transparent = $('header').hasClass('has-transparent');
    let has_shadow = $('header').hasClass('has-shadow');
    let has_topside = $('header').hasClass('has-topside');
    if ($(this).scrollTop() > sticky) {
        $('header.sticky').addClass("fixed");
        $('.to-top').addClass('visible');
        if(has_transparent){
            $('header').removeClass("transparent");
        }
        if(has_shadow){
            $('header').addClass("shadow").removeClass("no-shadow");
        }
        if(has_topside && has_transparent){
            $('header').removeClass("fixed-30");
        }
    } else {
        $('header.sticky').removeClass("fixed");
        if(has_transparent){
            $('header').addClass("transparent");
        }
        if(has_shadow){
            $('header').removeClass("shadow").addClass("no-shadow");
        }
        if(has_topside && has_transparent){
            $('header').addClass("fixed-30");
        }
        $('.to-top').removeClass('visible');
    }
});

$('.back-to-top').on('click',function(event) {
    event.preventDefault();
    $('html, body').animate({
        scrollTop: 0
    }, 600);
    return false;
});
// endregion

/* validator */
var numberCheck = /^[0-9]*$/;
var englishCheck = /^[A-Za-z0-9_\-]*$/;
var validateEmail = /^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-zA-Z0-9-]+(?:\.[a-zA-Z0-9-]+)*$/;
var strengthPassword = /^(?=.*\d)(?=.*[!@#$%^&*])(?=.*[a-z])(?=.*[A-Z])[0-9a-zA-Z!@#$%^&*]{6,}$/;
/* endregion */

/* Get local storage */
function get_token(){
    return localStorage.getItem('CUR_TOKEN');
}
function set_token(token){
    localStorage.setItem('CUR_TOKEN', token)
}

//spinner
var SPINNER_HTML = '<span class="spinner-border spinner-border-sm"></span> ';
function showSpinner(ele, is_disabled) {
    ele.prepend(SPINNER_HTML);
    if(is_disabled)
    {
        ele.prop('disabled', true);
    }
}
function hideSpinner(ele, is_enabled) {
    $('.spinner-border').remove();
    if(is_enabled)
    {
        ele.prop('disabled', false);
    }
}

//toast
function success(msg)
{
    $.toast({text: msg, icon: 'success', position: 'bottom-center', loader: false, hideAfter: 1000});
}

// Toast warning
function warning(msg)
{
    $.toast({text: msg, icon: 'warning', position: 'bottom-center', loader: false, hideAfter: 2000});
}

// Toast danger
function error(msg, hideAfter = 3000)
{
    $.toast({text: msg, icon: 'error', position: 'bottom-center', loader: false, hideAfter: hideAfter});
}