<!DOCTYPE html>
<html lang="th">
<head>
<meta charset="utf-8">
<!--meta http-equiv="X-UA-Compatible" content="IE=edge, chrome=1" /-->
<!--meta name="viewport" content="width=device-width, initial-scale=1.0"-->
<meta name="viewport" content="width=device-width, initial-scale = 1.0,
maximum-scale=1.0, user-scalable=no" />
<meta name="apple-mobile-web-app-capable" content="yes"/>

<title><?php echo $meta_title;?></title>
<meta name="description" content="<?php echo output_str($meta_description);?>">
<meta name="keywords" content="<?php echo $meta_keywords;?>">
<meta property="og:article:published_time" content="<?php echo $meta_published_time;?>" />
<meta property="og:title" content="<?php echo output_str($meta_title);?>" />
<meta property="og:site_name" content="<?php echo base_url();?>" />
<meta property="og:description" content="<?php echo output_str($meta_description);?>" />
<meta property="og:type" content="article" />
<meta property="og:image" content="<?php echo $meta_image_url;?>" />
<meta property="og:image:width" content="<?php echo $meta_image_width;?>" />
<meta property="og:image:height" content="<?php echo $meta_image_height;?>" />
<meta property="og:url" content="<?php echo $current_url;?>" />
<link rel="image_src" href="<?php echo $meta_image_url;?>" />

<?php include('application/views/front/en/inc/head.php');?>
</head>

<body>
   <div class="preload">
      <span class="loader"></span>
   </div>
   <div class="page">
      <?php include('application/views/front/en/inc/header.php');?>

      <div class="section section-banner">
         <div class="swiper-container swiper-banner">
            <div class="swiper-wrapper">
               <?php if(!empty($home_slider_listing)) { foreach($home_slider_listing as $rs) { ?>
                  <div class="swiper-slide">
                     <?php if(!empty($rs->link_url)) { ?>
                        <a href="<?php echo $rs->link_url;?>"<?php if($rs->link_target==1){echo ' target="_blank"';}?>><img class="banner-desktop" src="<?php echo home_slider_desktop_url($rs);?>" alt="<?php echo output_text($rs->text1_en);?>"></a>
                        <a href="<?php echo $rs->link_url;?>"<?php if($rs->link_target==1){echo ' target="_blank"';}?>><img class="banner-tablet" src="<?php echo home_slider_tablet_url($rs);?>" alt="<?php echo output_text($rs->text1_en);?>"></a>
                        <a href="<?php echo $rs->link_url;?>"<?php if($rs->link_target==1){echo ' target="_blank"';}?>><img class="banner-mobile" src="<?php echo home_slider_mobile_url($rs);?>" alt="<?php echo output_text($rs->text1_en);?>"></a>
                     <?php }else{ ?>
                        <img class="banner-desktop" src="<?php echo home_slider_desktop_url($rs);?>" alt="<?php echo output_text($rs->text1_en);?>">
                        <img class="banner-tablet" src="<?php echo home_slider_tablet_url($rs);?>" alt="<?php echo output_text($rs->text1_en);?>">
                        <img class="banner-mobile" src="<?php echo home_slider_mobile_url($rs);?>" alt="<?php echo output_text($rs->text1_en);?>">
                     <?php } ?>

                     <div class="banner-caption">
                        <div class="container-fluid">
                           <h2>
                              <span class="green"<?php if(!empty($rs->button_color1)){echo ' style="color:'.$rs->button_color1.'"';}?>><?php echo output_text($rs->text1_en);?></span> <br>
                              <span<?php if(!empty($rs->button_color2)){echo ' style="color:'.$rs->button_color2.'"';}?>><?php echo output_text($rs->text2_en);?></span></h2>
                           <?php if(!empty($rs->link_url) && !empty($rs->button_th)) { ?>
                              <a href="<?php echo $rs->link_url;?>"<?php if($rs->link_target==1){echo ' target="_blank"';}?> class="btn"><?php echo $rs->button_en;?></a>
                           <?php } ?>
                        </div>
                     </div>
                  </div><!--swiper-slide-->
               <?php } } ?>
            </div><!--swiper-wrapper-->
         </div><!--swiper-container-->

         <div class="swiper-pagination banner"></div>
         <div class="swiper-button swiper-button-prev banner"></div>
         <div class="swiper-button swiper-button-next banner"></div>
      </div><!-- section-banner-->

      <nav class="navbar-search  wow fadeIn">
         <div class="container">
            <h4>
               ค้นหาจากเสปค
            </h4>

            <form method="get" action="<?php echo base_url('en/search-spec');?>">
            <div class="search-inputs">
               <div class="col">
                  <select class="form-select" id="select_product_category_id" name="select_product_category_id">
                     <option value="">ประเภท</option>
                     <?php if(!empty($product_category_listing)) { foreach($product_category_listing as $rs) { ?>
                        <option value="<?php echo output_text($rs->product_category_id);?>"><?php echo output_text($rs->title);?></option>
                     <?php } } ?>
                  </select>
               </div>

               <div class="col">
                  <select class="form-select" name="select_product_id" id="select_product_id" disabled>
                     <option value="">ชื่อสินค้า</option>
                  </select>
               </div>

               <div class="col">
                  <select class="form-select" name="select_product_od" id="select_product_od" disabled>
                     <option value="">ขนาดเกลียว</option>
                  </select>
               </div>

               <div class="col">
                  <select class="form-select" name="select_product_len" id="select_product_len" disabled>
                     <option>ความยาว (mm.)</option>
                  </select>
               </div>

               <div class="button">
                  <button class="btn btn-search" type="submit">
                     <img class="svg-js" src="<?php echo base_url();?>theme/img/icons/icon-search.svg" alt="">
                     <span class="text">ค้นหา</span>
                  </button>
               </div>
            </div>
            </form>
         </div><!--container-->
      </nav><!--navbar-search-->

      <div class="section section-whoweare">
         <div class="section-icons">
            <div class="container">
               <span class="icons wow fadeInDown"></span>
               <span class="icons wow fadeInDown"></span>
               <span class="icons wow fadeInUp" data-wow-offset="0"></span>
               <span class="icons wow fadeInUp" data-wow-offset="0"></span>
            </div>
         </div>
         <div class="container">
            <div class="row">
               <div class="col-xl-5 col-lg-6 my-auto">
                  <div class="section-title">
                     <div class="textrow">
                        <h2 class="wow fadeInUp">WHO WE ARE</h2>
                     </div>
                     <div class="textrow">
                        <h4 class="wow fadeInUp">
                           ฟาสเทนนิคผู้นำด้านสลักจับยึดโครงสร้างและแองเคอร์โบลท์
                        </h4>
                     </div>
                  </div>
                  <article class="article wow fadeIn">
                     <p>ฟาสเทนนิค เป็นผู้นำด้านสลักจับยึดโครงสร้างและแองเคอร์โบล์ท ที่ผลิตในประเทศมาตั้งแต่ ปี 1981 ด้วยความมุ่งมั่นตลอด 40 ปี ที่เราตั้งใจส่งมอบสินค้าคุณภาพและบริการที่ได้มาตราฐานให้แก่ลูกค้า ทำให้เราเติบโตจากโรงหล่อโลหะเล็กๆ สู่แบรนด์ชั้นนำด้านการผลิตแองเคอร์ อันเป็นที่ยอมรับและไว้ใจโดยกลุ่มธุรกิจก่อสร้างและผู้รับเหมาทั้งภายใน และต่างประเทศ</p>

                     <p>เราไม่เคยประนีประนอมหรือลดทอนคุณภาพ เพื่อให้ผลิตภัณฑ์ฟาสเทนนิค ทุกชิ้นมีความปลอดภัยสูงสุดแก่ผู้ใช้เสมอมา </p>
                  </article>
               </div>

               <div class="col-xl-7 col-lg-6 my-auto">
                  <div class="card-photo wow fadeInRight">
                     <a data-fancybox href="img/thumb/photo-685x625--1.jpg">
                        <img class="w-100" src="<?php echo base_url();?>theme/img/thumb/photo-685x625--1.jpg" alt="">
                     </a>
                  </div>

               </div>
            </div><!--row-->
         </div><!--container-->
      </div><!--section-whoweare-->

      <a id="product"></a>
      <div class="section">
         <div class="container">
            <div class="section-title">
               <div class="textrow">
                  <h2 class="text-center wow fadeInUp">PRODUCTS</h2>
               </div>
            </div>

            <div class="box-980 pb-lg-5 pb-3">
               <div class="row g-2 g-lg-5">
                  <div class="col-lg-4 col-6">
                     <div class="card-category wow fadeIn">
                        <a href="<?php echo base_url('en/product/category/concrete');?>" class="card-link"></a>
                        <div class="card-photo">
                           <div class="photo" style="background-image: url(<?php echo base_url();?>theme/img/thumb/category-concrete-anchor.jpg);">
                              <img src="<?php echo base_url();?>theme/img/thumb/frame-100x100.png" alt="">
                           </div>
                        </div>
                        <h3>พุกคอนกรีต</h3>
                     </div>
                  </div><!--col-md-4-->

                  <div class="col-lg-4 col-6">
                     <div class="card-category wow fadeIn">
                        <a href="<?php echo base_url('en/product/category/chemical');?>" class="card-link"></a>
                        <div class="card-photo">
                           <div class="photo" style="background-image: url(<?php echo base_url();?>theme/img/thumb/category-chemical-anchor.jpg);">
                              <img src="<?php echo base_url();?>theme/img/thumb/frame-100x100.png" alt="">
                           </div>
                        </div>
                        <h3>พุกเคมี</h3>
                     </div>
                  </div><!--col-md-4-->

                  <div class="col-lg-4 col-6">
                     <div class="card-category wow fadeIn">
                        <a href="<?php echo base_url('en/product/category/other-cleat');?>" class="card-link"></a>
                        <div class="card-photo">
                           <div class="photo" style="background-image: url(<?php echo base_url();?>theme/img/thumb/category-anchor.jpg);">
                              <img src="<?php echo base_url();?>theme/img/thumb/frame-100x100.png" alt="">
                           </div>
                        </div>
                        <h3>พุกอื่นๆ</h3>
                     </div>
                  </div><!--col-md-4-->

                  <div class="col-lg-4 col-6">
                     <div class="card-category wow fadeIn">
                        <a href="<?php echo base_url('en/product/category/precast');?>" class="card-link"></a>
                        <div class="card-photo">
                           <div class="photo" style="background-image: url(<?php echo base_url();?>theme/img/thumb/category-precast.jpg);">
                              <img src="<?php echo base_url();?>theme/img/thumb/frame-100x100.png" alt="">
                           </div>
                        </div>
                        <h3>พุกและอุปกรณ์งาน Precast</h3>
                     </div>
                  </div><!--col-md-4-->

                  <div class="col-lg-4 col-6">
                     <div class="card-category wow fadeIn">
                        <a href="<?php echo base_url('en/product/category/screw');?>" class="card-link"></a>
                        <div class="card-photo">
                           <div class="photo" style="background-image: url(<?php echo base_url();?>theme/img/thumb/category-screw.jpg);">
                              <img src="<?php echo base_url();?>theme/img/thumb/frame-100x100.png" alt="">
                           </div>
                        </div>
                        <h3>สกรู</h3>
                     </div>
                  </div><!--col-md-4-->

                  <div class="col-lg-4 col-6">
                     <div class="card-category wow fadeIn">
                        <a href="<?php echo base_url('en/product/category/other');?>" class="card-link"></a>
                        <div class="card-photo">
                           <div class="photo" style="background-image: url(<?php echo base_url();?>theme/img/thumb/category-etc.jpg);">
                              <img src="<?php echo base_url();?>theme/img/thumb/frame-100x100.png" alt="">
                           </div>
                        </div>
                        <h3>อื่นๆ</h3>
                     </div>
                  </div><!--col-md-4-->
               </div><!--row-->
            </div><!--box-980-->
         </div><!--container-->
      </div><!--section-->

      <div class="section">
         <div class="background texture-line" style="background-image: url(<?php echo base_url();?>theme/img/thumb/bg-texture-line.png);"></div>
         <div class="container">
            <div class="my-md-4"><!--box-980-->
               <div class="section-title pb-0 pt-4 pt-lg">
                  <div class="textrow">
                     <h2 class="text-center wow fadeInUp">PRODUCT <br class="d-block d-lg-none">CATALOGS</h2>
                  </div>
               </div>

               <div class="row">
                  <div class="col-lg-6">
                     <div class="card-catalogs">
                        <div class="card-body">
                           <h3 class="textrow">
                              <span class="wow fadeInUp">Anchoring System</span>
                           </h3>
                           <p class="textrow">
                              <span class="wow fadeInUp">ระบบจับยึดแบบเจาะฝัง เพียงเจาะรูเพื่อติดตั้ง</span>
                           </p>
                        </div>
                        <div class="card-photo wow fadeIn">
                           <img src="<?php echo base_url();?>theme/img/thumb/photo-anchoring-system.png" alt="">
                        </div>
                        <div class="card-button wow fadeIn">
                           <a class="btn" href="https://fastenic.com/anchoringsystem.php">View Catalog</a>
                        </div>
                     </div><!--card-catalogs-->
                  </div><!--col-lg-6-->

                  <div class="col-lg-6">
                     <div class="card-catalogs">
                        <div class="card-body">
                           <h3 class="textrow">
                              <span class="wow fadeInUp">Precast Anchoring System</span>
                           </h3>
                           <p class="textrow">
                              <span class="wow fadeInUp">พุกจับยึดแบบหล่อฝัง ติดตั้งขณะขึ้นรูปคอนกรีต</span>
                           </p>
                        </div>
                        <div class="card-photo wow fadeIn">
                           <img src="<?php echo base_url();?>theme/img/thumb/photo-precast-anchoring-system.png" alt="">
                        </div>
                        <div class="card-button wow fadeIn">
                           <a class="btn" href="https://fastenic.com/precastanchoringsystem.php">View Catalog</a>
                        </div>
                     </div><!--card-catalogs-->
                  </div><!--col-lg-6-->
               </div><!--row-->
            </div><!--box-980-->
         </div><!--container-->
      </div><!--section-->

      <div class="section">
         <div class="container">
            <div class="box-980 px-4">
               <div class="section-title">
                  <div class="textrow">
                     <h2 class="text-center wow fadeInUp">TRUSTED BY</h2>
                  </div>
               </div>


               <img class="w-100 my-5 d-none d-md-block" src="<?php echo base_url();?>theme/img/thumb/client-logo-desktop.png" alt="">
               <img class="w-100 my-md-5 my-sm-4 my-2 d-block d-md-none" src="<?php echo base_url();?>theme/img/thumb/client-logo-mobile.png" alt="">

               <!-- <ul class="partner-lists">
                   <li><img src="<?php echo base_url();?>theme/img/thumb/partner--1.jpg" alt=""></li>
                   <li><img src="<?php echo base_url();?>theme/img/thumb/partner--2.jpg" alt=""></li>
                   <li><img src="<?php echo base_url();?>theme/img/thumb/partner--3.jpg" alt=""></li>
                   <li><img src="<?php echo base_url();?>theme/img/thumb/partner--4.jpg" alt=""></li>
                   <li><img src="<?php echo base_url();?>theme/img/thumb/partner--5.jpg" alt=""></li>
                   <li><img src="<?php echo base_url();?>theme/img/thumb/partner--6.jpg" alt=""></li>
                   <li><img src="<?php echo base_url();?>theme/img/thumb/partner--7.jpg" alt=""></li>
                   <li><img src="<?php echo base_url();?>theme/img/thumb/partner--8.jpg" alt=""></li>
                   <li><img src="<?php echo base_url();?>theme/img/thumb/partner--9.jpg" alt=""></li>
                   <li><img src="<?php echo base_url();?>theme/img/thumb/partner--10.jpg" alt=""></li>
               </ul>  -->
            </div><!--box-980-->
         </div><!--container-->
      </div><!--section-->

      <div class="section section-slogan">
         <div class="background parallaxie" style="background-image: url(<?php echo base_url();?>theme/img/thumb/bg-1920x1200.jpg);"></div>
         <div class="container">
            <div class="section-title">
               <div class="textrow">
                  <h3 class="text-center wow fadeInUp">" TRUSTED STRENGTH <br class="d-block d-lg-none">FOR STURDY JOB "</h3>
               </div>
            </div>
         </div><!--container-->
      </div><!--section-slogan-->

      <div class="section section-contact">
         <div class="section-icons">
            <div class="container">
               <span class="icons wow fadeInDown"></span>
               <span class="icons wow fadeInDown"></span>
               <span class="icons wow fadeInUp" data-wow-offset="0"></span>
               <span class="icons wow fadeInUp" data-wow-offset="0"></span>
            </div>
         </div>
         <div class="container">
            <div class="section-title">
               <div class="textrow">
                  <h3 class="text-center wow fadeInUp">
                     FOR MORE <br class="d-block d-lg-none">
                     INFORMATION / <br class="d-block d-lg-none">
                     QUOTATION
                  </h3>
               </div>
            </div>

            <article class="article contact mb-5 wow fadeIn">
               <p>Siam Anchor Fastener Industry</p>
               <p>
                  <a href="tel:027136606">Tel: 02-713-6606-7</a> <br class="d-block d-lg-none">
                  <span>Fax: 02-391-4512</span>
               </p>

               <div class="d-flex">
                  <a class="btn btn-green mx-auto" href="https://line.me/R/ti/p/@591ibppc" target="_blank">ADD LINE : @Fastenic</a>
               </div>
            </article>
         </div><!--container-->
      </div><!--section-->

      <div class="section wow fadeIn">
         <div class="container">
            <div class="certificate-box">
               <img src="<?php echo base_url();?>theme/img/thumb/certificate--1.jpg" alt="">
               <img src="<?php echo base_url();?>theme/img/thumb/certificate--2.jpg" alt="">
            </div>
         </div><!--container-->
      </div><!--section-certificate-->

      <?php include('application/views/front/en/inc/footer.php');?>
   </div><!--page-->

    <?php include('application/views/front/en/inc/body.php');?>
    <script>
        // var $myModal = new bootstrap.Modal('#informModal');
        // $myModal.show();
    </script>
</body>
</html>
