<!-- Listing -->
<?php include 'application/views/bos/listing-tools.php';?>

<div class="card-body">
   <div class="table-responsive-sm table-listing popup-gallery">
      <table class="table table-striped table-hover table-bordered">
         <thead>
         <tr>
            <th class="w60">ID</th>
            <th class="w50 text-center d-none d-sm-table-cell">ภาพ</th>
            <th>อีเมล</th>
            <th class="w150 d-none d-sm-table-cell">สิทธิ์</th>
            <th class="text-center d-none d-sm-table-cell w80">สถานะ</th>
            <th class="text-center d-none d-sm-table-cell w80">อัพเดตเมื่อ</th>
            <th class="text-center d-none d-sm-table-cell w80">Last Login</th>
            <th class="text-center w100">เครื่องมือ</th>
         </tr>
         <tr class="row-filter">
            <td></td>
            <td class="d-none d-sm-table-cell"></td>
            <td class="d-none d-sm-table-cell"><input type="text" id="filter_email" placeholder="พิมพ์คำค้นหา" class="form-control"></td>
            <td class="d-none d-sm-table-cell"><select class="form-control" id="filter_role"></select></td>
            <td class="d-none d-sm-table-cell">
               <select class="form-control" id="filter_status">
                  <option value=""></option>
                  <option value="1">ใช้งาน</option>
                  <option value="-1">ระงับ</option>
               </select>
            </td>
            <td class="d-none d-sm-table-cell"></td>
            <td class="d-none d-sm-table-cell"></td>
            <td class="inline-tools">
               <button class="btn btn-light btn-sm shadow toolbar-filter-search" type="button" title="ค้นหา"><i class="las la-search las la-pen align-middle"></i></button>
               <button class="btn btn-light btn-sm shadow toolbar-filter-reset" type="button" title="รีเซ็ต"><i class="las la-times las la-pen align-middle"></i></button>
            </td>
         </tr>
         </thead>
         <tbody id="load_rows">
         <!-- Display rows from js -->
         </tbody>
      </table>
   </div>
</div>

<?php include('application/views/bos/pager.php');?>

<script type="text/javascript">
   let keyId = 'user_id';

   //Setup modal form
   var modalSize = ''; // modal-sm, none, modal-lg, modal-xl

   //Display row
   request_listing(null);

   function display_rows(data, start, limit)
   {
      let html = '';
      let row = data.rows;
       let locked = '';
      for(let i=start;i<(data.rows.length<limit ? data.rows.length:limit);i++)
      {
         locked = row[i].locked === '1' ? '<i class="la la-lock text-warning"></i> ':'';

         html += '<tr class="row_no" rowId="'+row[i].user_id+'">';
         html += '<td>'+row[i].user_id+'</td>';
         html += '<td class="text-center d-none d-sm-table-cell"><a href="'+row[i].cover_url+'" class="popup-item"><img src="'+row[i].cover_url+'" width="50"></a></td>';
         html += '<td>'+locked+'<span class="title">'+row[i].email+'</span> <span class="d-block small text-muted">'+output_text(row[i].firstname+' '+row[i].lastname)+'</span></td>';
         html += '<td class="d-none d-sm-table-cell"><span class="badge badge-light-primary">'+output_text(row[i].role)+'</span></td>';
         html += '<td class="text-center d-none d-sm-table-cell">'+row_status(row[i].status)+'</td>';
         html += '<td class="text-center d-none d-sm-table-cell small text-muted">'+row_updated(row[i])+'</td>';
         html += '<td class="text-center d-none d-sm-table-cell small text-muted">'+row_lastlogin(row[i])+'</td>';;
         html += '<td class="inline-tools"><?php echo $button_inline;?></td>';
         html += '</tr>';
      }
      $("#load_rows").html(html);
   }

   //Toolbar : Filters
   $(document).on('click', '.toolbar-filter-search', function(){
      filters = {
          name: $('#filter_name').val(),
          email: $('#filter_email').val(),
          role_id: $('#filter_role').val(),
          status: $('#filter_status').val()
      };

      request_listing(filters);
   });
   $(document).on('click', '.toolbar-filter-reset', function(){
      $('#filter_name').val('');
      $('#filter_email').val('');
      $('#filter_role').val('');
      $('#filter_status').val('');

      request_listing({name: '', email: '', role_id: '', status: ''});
   });

   //Selectbox
   selectList('bos/user_role/listing', '#filter_role', 'role_id');

   //Form validate
   let validate = {
       role_id: {
           input: 'select',
           msg: 'Please select role'
       },
       firstname: {
           input: 'text',
           msg: 'Please input first name'
       },
       lastname: {
           input: 'text',
           msg: 'Please input last name'
       },
       email: {
           input: 'email',
           msg: 'Please input valid email',
           email: true,
           existing: {
               require: true,
               exclude: '#exclude'
           }
       },
       password: {
           input: 'password',
           msg: 'Please input password<br />- contain at least one digit<br />- at least one lower case<br />- at least one upper case<br />- at least one special char (!@#$%^&*)<br />- at least 6 from the mentioned characters',
           min: 6,
           max: 20,
           password: true
       },
       confirm_password: {
           input: 'password',
           msg: 'Please input confirm password',
           min: 6,
           max: 20,
           equalTo: {
               to: '#password',
               msg: 'Password do not match'
           }
       }
   };
</script>