<!-- Form Main -->
<div id="listing" class="form-main form-setting">

   <form id="formData" method="post">
      <div class="card-header">
         <div class="row">
            <div class="col-5">
               <div class="nav-breadcrumb">
                  <span class="nav-item"><i class="<?php echo $component_icon;?>"></i> <?php echo $menu_group_name;?></span>
                  <span class="nav-item"><?php echo $menu_name;?></span>
               </div>
            </div>
            <div class="col-7 toolbars text-right">
               <button type="button" class="btn btn-primary btn-sm btn-update-setting"><i class="la la-save align-middle"></i> อัพเดต</button>
            </div>
         </div>
      </div>
      <div class="card-body">

         <div class="form-legend show-form-child">Administrator</div>
         <div class="collapse">
            <div class="form-row">
               <label for="admin_name" class="col-sm-12 col-md-2 col-form-label">System Name : </label>
               <div class="col-sm-12 col-md-6">
                  <input type="text" class="form-control" id="admin_name" name="admin_name">
               </div>
            </div>
            <div class="form-row">
               <label for="admin_logo" class="col-sm-12 col-md-2 col-form-label">Logo : </label>
               <div class="col-sm-12 col-md-6">
                  <div class="choose-file-container">
                     <div class="input-group">
                        <input type="text" class="form-control file_name" disabled>
                        <div class="input-group-append">
                           <button type="button" class="btn btn-choose-file shadow input-group-text" onclick="$('#cover').trigger('click');" title="เลือกไฟล์ภาพที่ต้องการ">เลือกภาพ</button>
                        </div>
                        <div class="input-group-append">
                           <button type="button" class="btn btn-clear-file input-group-text" title="นำไฟล์ที่เลือกออก" disabled><i class="la la-times"></i></button>
                        </div>
                     </div>
                     <input type="file" class="form-control d-none" id="cover" name="cover" accept="<?php echo implode(',' , UPLOAD_ACCEPT_IMAGE_TYPE);?>">
                  </div>
                  <div class="preview-image-holder mt-2">
                     <img src="" class="current-logo img-fluid" />
                  </div>
                  <div class="d-none has-logo mt-2">
                     <input type="checkbox" name="delete_logo" id="delete_logo" value="1">
                     <span class="text-muted small align-top">ลบภาพ</span>
                  </div>
               </div>
            </div>
            <div class="form-row">
               <label for="admin_theme_primary" class="col-sm-12 col-md-2 col-form-label">Primary Color : </label>
               <div class="col-sm-12 col-md-10">
                  <div class="row">
                     <div class="col-sm-12 small text-muted">Custom</div>
                     <div class="col-sm-6 col-md-4">
                        <div class="input-group">
                           <div class="input-group-prepend">
                              <div class="input-group-text">Primary</div>
                           </div>
                           <input type="text" class="form-control jscolor" id="admin_theme_primary" name="admin_theme_primary">
                        </div>
                     </div>
                     <div class="col-sm-6 col-md-4">
                        <div class="input-group">
                           <div class="input-group-prepend">
                              <div class="input-group-text">Secondary</div>
                           </div>
                           <input type="text" class="form-control jscolor" id="admin_theme_secondary" name="admin_theme_secondary">
                        </div>
                     </div>
                     <div class="col-sm-6 col-md-4">
                        <div class="input-group">
                           <div class="input-group-prepend">
                              <div class="input-group-text">Text Color</div>
                           </div>
                           <input type="text" class="form-control jscolor" id="admin_theme_textcolor" name="admin_theme_textcolor">
                        </div>
                     </div>
                  </div>

                  <div class="row mt-2">
                     <div class="col-sm-12 small text-muted">Gradient</div>
                     <div class="col-sm-3">
                        <div class="custom-control custom-checkbox">
                           <input type="checkbox" class="custom-control-input" id="admin_theme_gradient" name="admin_theme_gradient" value="1" onclick="set_theme_color();">
                           <label class="custom-control-label" for="admin_theme_gradient">Gradient</label>
                        </div>
                     </div>
                  </div>

                  <div class="row mt-2">
                     <div class="col-sm-12 small text-muted">Theme</div>
                     <div class="col-sm-6 col-md-3">
                        <button type="button" class="btn btn-sm w-100 text-white admin_theme_selected" style="background: linear-gradient(0deg, #52BAF9 0%, #765EFC 100%);" data-primary="765EFC" data-secondary="52BAF9">FLOW CART 1</button>
                     </div>
                     <div class="col-sm-6 col-md-3">
                        <button type="button" class="btn btn-sm w-100 text-white admin_theme_selected" style="background: linear-gradient(0deg, #FF6CAB 0%, #7366FF 100%);" data-primary="7366FF" data-secondary="FF6CAB">FLOW CART 2</button>
                     </div>
                     <div class="col-sm-6 col-md-3">
                        <button type="button" class="btn btn-sm w-100 text-white admin_theme_selected" style="background: linear-gradient(0deg, #FF9482 0%, #7D77FF 100%);" data-primary="7D77FF" data-secondary="FF9482">FLOW CART 3</button>
                     </div>
                     <div class="col-sm-6 col-md-3">
                        <button type="button" class="btn btn-sm w-100 text-white admin_theme_selected" style="background: linear-gradient(0deg, #10c4a7 0%, #7341de 100%);" data-primary="7341de" data-secondary="10c4a7">FLOW CART 4</button>
                     </div>
                     <div class="col-sm-6 col-md-3">
                        <button type="button" class="btn btn-sm w-100 text-white admin_theme_selected" style="background: linear-gradient(0deg, #4391e4 0%, #00deff 100%);" data-primary="4391e4" data-secondary="00deff">Blue Gradient</button>
                     </div>
                     <div class="col-sm-6 col-md-3">
                        <button type="button" class="btn btn-sm w-100 text-white admin_theme_selected" style="background: linear-gradient(0deg, #cd45d7 0%, #6059e7 100%);" data-primary="6059e7" data-secondary="cd45d7">Purple Gradient</button>
                     </div>
                     <div class="col-sm-6 col-md-3">
                        <button type="button" class="btn btn-sm w-100 text-white admin_theme_selected" style="background: linear-gradient(0deg, #9dcf2e 0%, #4fca7a 100%);" data-primary="4fca7a" data-secondary="9dcf2e">Green Gradient</button>
                     </div>
                     <div class="col-sm-6 col-md-3">
                        <button type="button" class="btn btn-sm w-100 text-white admin_theme_selected" style="background: linear-gradient(0deg, #fec750 0%, #fb5c58 100%);" data-primary="fb5c58" data-secondary="fec750">Orange Gradient</button>
                     </div>
                     <div class="col-sm-6 col-md-3">
                        <button type="button" class="btn btn-sm w-100 text-white admin_theme_selected" style="background: linear-gradient(0deg, #1abc9c 0%, #16a085 100%);" data-primary="16a085" data-secondary="1abc9c">GREEN SEA</button>
                     </div>
                     <div class="col-sm-6 col-md-3">
                        <button type="button" class="btn btn-sm w-100 text-white admin_theme_selected" style="background: linear-gradient(0deg, #2ecc71 0%, #27ae60 100%);" data-primary="27ae60" data-secondary="2ecc71">NEPHRITIS</button>
                     </div>
                     <div class="col-sm-6 col-md-3">
                        <button type="button" class="btn btn-sm w-100 text-white admin_theme_selected" style="background: linear-gradient(0deg, #3498db 0%, #2980b9 100%);" data-primary="2980b9" data-secondary="3498db">BELIZE HOLE</button>
                     </div>
                     <div class="col-sm-6 col-md-3">
                        <button type="button" class="btn btn-sm w-100 text-white admin_theme_selected" style="background: linear-gradient(0deg, #8e44ad 0%, #9b59b6 100%);" data-primary="8e44ad" data-secondary="9b59b6">WISTERIA</button>
                     </div>
                     <div class="col-sm-6 col-md-3">
                        <button type="button" class="btn btn-sm w-100 text-white admin_theme_selected" style="background: linear-gradient(0deg, #34495e 0%, #2c3e50 100%);" data-primary="2c3e50" data-secondary="34495e">MIDNIGHT BLUE</button>
                     </div>
                     <div class="col-sm-6 col-md-3">
                        <button type="button" class="btn btn-sm w-100 text-white admin_theme_selected" style="background: linear-gradient(0deg, #f1c40f 0%, #f39c12 100%);" data-primary="f39c12" data-secondary="f1c40f">SUN FLOWER</button>
                     </div>
                     <div class="col-sm-6 col-md-3">
                        <button type="button" class="btn btn-sm w-100 text-white admin_theme_selected" style="background: linear-gradient(0deg, #e67e22 0%, #d35400 100%);" data-primary="d35400" data-secondary="e67e22">PUMPKIN</button>
                     </div>
                     <div class="col-sm-6 col-md-3">
                        <button type="button" class="btn btn-sm w-100 text-white admin_theme_selected" style="background: linear-gradient(0deg, #e74c3c 0%, #c0392b 100%);" data-primary="c0392b" data-secondary="e74c3c">PROMEGRANATE</button>
                     </div>
                     <div class="col-sm-6 col-md-3">
                        <button type="button" class="btn btn-sm w-100 text-white admin_theme_selected" style="background: linear-gradient(0deg, #95a5a6 0%, #7f8c8d 100%);" data-primary="7f8c8d" data-secondary="95a5a6">ASBETROS</button>
                     </div>
                     <div class="col-sm-6 col-md-3">
                        <button type="button" class="btn btn-sm w-100 text-white admin_theme_selected" style="background: linear-gradient(0deg, #a29bfe 0%, #6c5ce7 100%);" data-primary="6c5ce7" data-secondary="a29bfe">EXODUS FRUIT</button>
                     </div>
                     <div class="col-sm-6 col-md-3">
                        <button type="button" class="btn btn-sm w-100 text-white admin_theme_selected" style="background: linear-gradient(0deg, #fd79a8 0%, #e84393 100%);" data-primary="e84393" data-secondary="fd79a8">PRUNUS AVIUM</button>
                     </div>
                     <div class="col-sm-6 col-md-3">
                        <button type="button" class="btn btn-sm w-100 text-white admin_theme_selected" style="background: linear-gradient(0deg, #636e72 0%, #2d3436 100%);" data-primary="2d3436" data-secondary="636e72">DRACULA ORCHID</button>
                     </div>


                     <div class="col-12">
                        <div class="small text-muted mt-2">UI Colors</div>
                        <a href="https://flatuicolors.com/" target="_blank" title="ดูชุดสีสวยๆ ได้ที่นี่">https://flatuicolors.com/</a>
                     </div>
                  </div>

                  <script type="text/javascript">
                      $('.admin_theme_selected').on('click', function(){
                          $('#admin_theme_primary').val($(this).data('primary'));
                          $('#admin_theme_secondary').val($(this).data('secondary'));
                          set_theme_color();
                      });
                      function set_theme_color() {
                          let primary = $('#admin_theme_primary').val();
                          let secondary = $('#admin_theme_secondary').val();
                          let textcolor = $('#admin_theme_textcolor').val();

                          $('#admin_theme_primary').val(primary);
                          $('#admin_theme_primary').css({'background': '#'+primary});
                          $('#admin_theme_secondary').val(secondary);
                          $('#admin_theme_secondary').css({'background': '#'+secondary});
                          $('.sidebar.hide .nav-item.active a').attr('style', 'background-color:#'+secondary + ' !important');
                          $('.btn-primary').attr('style', 'border-color:#'+primary + ' !important;background-color:#'+primary + ' !important;');
                          $('.sidebar.show .nav-second-level li a').attr('style', 'border-left: 3px solid #'+secondary + ' !important;color: #'+textcolor+' !important;');
                          $('.sidebar .nav-link').attr('style', 'color: #'+textcolor+' !important;');
                          $('.sidebar .nav-item.active a').attr('style', 'border-left: 3px solid #'+secondary + ' !important;background-color:#'+secondary + ' !important;color: #'+textcolor+' !important;');

                          if($('#admin_theme_gradient').prop('checked'))
                          {
                              $('.sidebar, .sidebar.hide .nav > .nav-item:hover > .nav-submenu-container').attr('style', 'background:linear-gradient(0deg, #'+secondary+' 0%, #'+primary+' 100%);');
                          }
                          else {
                              $('.sidebar, .sidebar.hide .nav > .nav-item:hover > .nav-submenu-container').attr('style', 'background:none !important;background-color:#'+primary + ' !important');
                          }
                      }
                  </script>
               </div>
            </div>
            <div class="form-row">
               <label for="admin_listing_perpage" class="col-sm-12 col-md-2 col-form-label">Listing Perpage : </label>
               <div class="col-sm-12 col-md-6">
                  <select class="form-control" id="admin_listing_perpage" name="admin_listing_perpage">
                     <option value="5">5</option>
                     <option value="10">10</option>
                     <option value="20">20</option>
                     <option value="30">30</option>
                     <option value="40">40</option>
                     <option value="50">50</option>
                     <option value="100">100</option>
                  </select>
               </div>
            </div>
            <div class="form-row d-none">
               <label for="website_clear_cachex" class="col-sm-12 col-md-2 col-form-label">Logs : </label>
               <div class="col-sm-12 col-md-6">
                  <div class="input-group">
                     <div class="input-group-prepend">
                        <div class="input-group-text">แอดมินลอกอิน</div>
                     </div>
                     <input type="number" class="form-control" id="website_limit_user_log" name="website_limit_user_log">
                  </div>
               </div>
            </div>
            <div class="form-row">
               <label for="admin_cache" class="col-sm-12 col-md-2 col-form-label">Cache : </label>
               <div class="col-sm-12 col-md-6">
                  <div class="input-group">
                     <input type="number" class="form-control" id="admin_cache" name="admin_cache">
                     <div class="input-group-prepend">
                        <div class="input-group-text">Minute</div>
                     </div>
                  </div>
               </div>
            </div>
         </div>

         <div class="form-legend show-form-child d-none">Contact</div>
         <div class="collapse d-none">
            <div class="form-row">
               <label for="contact_title" class="col-sm-3 col-md-2 col-form-label">Title : </label>
               <div class="col-sm-12 col-md-6">
                  <input type="text" class="form-control" id="contact_title" name="contact_title">
               </div>
            </div>
            <div class="form-row">
               <label for="contact_detail" class="col-sm-3 col-md-2 col-form-label">Detail : </label>
               <div class="col-sm-12 col-md-6">
                  <textarea class="form-control" id="contact_detail" name="contact_detail" rows="4"></textarea>
               </div>
            </div>
            <div class="form-row">
               <label for="contact_email" class="col-sm-3 col-md-2 col-form-label">Email : </label>
               <div class="col-sm-12 col-md-6">
                  <input type="text" class="form-control" id="contact_email" name="contact_email">
               </div>
            </div>
            <div class="form-row">
               <label for="contact_phone" class="col-sm-3 col-md-2 col-form-label">Phone : </label>
               <div class="col-sm-12 col-md-6">
                  <input type="text" class="form-control" id="contact_phone" name="contact_phone">
               </div>
            </div>
            <div class="form-row">
               <label for="contact_open" class="col-sm-3 col-md-2 col-form-label">Open : </label>
               <div class="col-sm-12 col-md-6">
                  <input type="text" class="form-control" id="contact_open" name="contact_open">
               </div>
            </div>
            <div class="form-row">
               <label for="contact_map" class="col-sm-3 col-md-2 col-form-label">Map : </label>
               <div class="col-sm-12 col-md-6">
                  <textarea class="form-control" id="contact_map" name="contact_map" rows="4"></textarea>
               </div>
            </div>
         </div>

         <div class="form-legend show-form-child d-none">Social</div>
         <div class="collapse d-none">
            <div class="form-row">
               <label for="social_facebook" class="col-sm-3 col-md-2 col-form-label">Facebook : </label>
               <div class="col-sm-12 col-md-6">
                  <input type="text" class="form-control" id="social_facebook" name="social_facebook">
               </div>
            </div>
            <div class="form-row">
               <label for="social_twitter" class="col-sm-3 col-md-2 col-form-label">Twitter : </label>
               <div class="col-sm-12 col-md-6">
                  <input type="text" class="form-control" id="social_twitter" name="social_twitter">
               </div>
            </div>
            <div class="form-row">
               <label for="social_instagram" class="col-sm-3 col-md-2 col-form-label">Instagram : </label>
               <div class="col-sm-12 col-md-6">
                  <input type="text" class="form-control" id="social_instagram" name="social_instagram">
               </div>
            </div>
            <div class="form-row">
               <label for="social_youtube" class="col-sm-3 col-md-2 col-form-label">Youtube : </label>
               <div class="col-sm-12 col-md-6">
                  <input type="text" class="form-control" id="social_youtube" name="social_youtube">
               </div>
            </div>
            <div class="form-row">
               <label for="social_tiktok" class="col-sm-3 col-md-2 col-form-label">TikTok : </label>
               <div class="col-sm-12 col-md-6">
                  <input type="text" class="form-control" id="social_tiktok" name="social_tiktok">
               </div>
            </div>
            <div class="form-row">
               <label for="social_line" class="col-sm-3 col-md-2 col-form-label">LINE : </label>
               <div class="col-sm-12 col-md-6">
                  <input type="text" class="form-control" id="social_line" name="social_line">
               </div>
            </div>
         </div>

         <div class="form-legend show-form-child">SEO Meta Tag</div>
         <div class="collapse">
            <div class="form-row">
               <label for="seo_meta_title" class="col-sm-12 col-md-2 col-form-label">Meta Title : </label>
               <div class="col-sm-12 col-md-6">
                  <input type="text" class="form-control" id="seo_meta_title" name="seo_meta_title">
               </div>
            </div>
            <div class="form-row">
               <label for="seo_meta_keywords" class="col-sm-12 col-md-2 col-form-label">Meta Keywords : </label>
               <div class="col-sm-12 col-md-6">
                  <textarea class="form-control" rows="3" id="seo_meta_keywords" name="seo_meta_keywords"></textarea>
               </div>
            </div>
            <div class="form-row">
               <label for="seo_meta_description" class="col-sm-12 col-md-2 col-form-label">Meta Description : </label>
               <div class="col-sm-12 col-md-6">
                  <textarea class="form-control" rows="3" id="seo_meta_description" name="seo_meta_description"></textarea>
               </div>
            </div>
            <div class="form-row">
               <label for="seo_meta_image" class="col-sm-12 col-md-2 col-form-label">Image (600 x 315) : </label>
               <div class="col-sm-12 col-md-6">
                  <div class="choose-file-container">
                     <div class="input-group">
                        <input type="text" class="form-control file_name" disabled>
                        <div class="input-group-append">
                           <button type="button" class="btn btn-choose-file shadow input-group-text" onclick="$('#seo_meta_image').trigger('click');">เลือกภาพ</button>
                        </div>
                        <div class="input-group-append">
                           <button type="button" class="btn btn-clear-file input-group-text" title="นำไฟล์ที่เลือกออก" disabled><i class="la la-times"></i></button>
                        </div>
                     </div>
                     <input type="file" class="form-control d-none" id="seo_meta_image" name="seo_meta_image" accept="<?php echo implode(',' , UPLOAD_ACCEPT_IMAGE_TYPE);?>">
                  </div>
                  <div class="preview-image-holder preview-image-holder-100p mt-2">
                     <img src="" class="current-meta-image" style="max-width: 100%;" />
                  </div>
                  <div class="d-none has-meta-image mt-2">
                     <input type="checkbox" name="delete_meta_image" id="delete_meta_image" value="1">
                     <span class="text-muted small align-top">ลบภาพ</span>
                  </div>
               </div>
            </div>
         </div>

         <div class="form-legend show-form-child">Custom Script</div>
         <div class="collapse">
            <div class="form-row">
               <label for="custom_script_head" class="col-sm-12 col-md-2 col-form-label">/head : </label>
               <div class="col-sm-12 col-md-6">
                  <textarea class="form-control" rows="5" id="custom_script_head" name="custom_script_head"></textarea>
               </div>
            </div>
            <div class="form-row">
               <label for="custom_script_body" class="col-sm-12 col-md-2 col-form-label">/body : </label>
               <div class="col-sm-12 col-md-6">
                  <textarea class="form-control" rows="5" id="custom_script_body" name="custom_script_body"></textarea>
               </div>
            </div>
         </div>

         <div class="form-legend show-form-child">Email SMTP</div>
         <div class="collapse">
            <div class="form-row">
               <label for="smtp_username" class="col-sm-3 col-md-2 col-form-label">Host : </label>
               <div class="col-sm-9 col-md-10">
                  <div class="row">
                     <div class="col-sm-6">
                        <div class="input-group">
                           <div class="input-group-prepend">
                              <div class="input-group-text">Host name</div>
                           </div>
                           <input type="text" class="form-control" id="smtp_hostname" name="smtp_hostname">
                        </div>
                     </div>
                     <div class="col-sm-6">
                        <div class="input-group">
                           <div class="input-group-prepend">
                              <div class="input-group-text">Port</div>
                           </div>
                           <input type="text" class="form-control" id="smtp_port" name="smtp_port">
                        </div>
                     </div>
                  </div>
               </div>
            </div>
            <div class="form-row">
               <label for="smtp_username" class="col-sm-3 col-md-2 col-form-label">Account : </label>
               <div class="col-sm-9 col-md-10">
                  <div class="row">
                     <div class="col-sm-6">
                        <div class="input-group">
                           <div class="input-group-prepend">
                              <div class="input-group-text">User name</div>
                           </div>
                           <input type="text" class="form-control" id="smtp_username" name="smtp_username">
                        </div>
                     </div>
                     <div class="col-sm-6">
                        <div class="input-group">
                           <div class="input-group-prepend">
                              <div class="input-group-text">Password</div>
                           </div>
                           <input type="password" class="form-control" id="smtp_password" name="smtp_password">
                        </div>
                     </div>
                  </div>
               </div>
            </div>
            <div class="form-row">
               <label for="smtp_secure" class="col-sm-3 col-md-2 col-form-label">Secure type : </label>
               <div class="col-sm-9 col-md-10">
                  <div class="row">
                     <div class="col-sm-6">
                        <input type="text" class="form-control" id="smtp_secure" name="smtp_secure">
                     </div>
                  </div>
               </div>
            </div>
            <div class="form-row">
               <label for="smtp_username" class="col-sm-3 col-md-2 col-form-label">Sender : </label>
               <div class="col-sm-9 col-md-10">
                  <div class="row">
                     <div class="col-sm-6">
                        <div class="input-group">
                           <div class="input-group-prepend">
                              <div class="input-group-text">Name</div>
                           </div>
                           <input type="text" class="form-control" id="smtp_sender_name" name="smtp_sender_name">
                        </div>
                     </div>
                     <div class="col-sm-6">
                        <div class="input-group">
                           <div class="input-group-prepend">
                              <div class="input-group-text">Email</div>
                           </div>
                           <input type="text" class="form-control" id="smtp_sender_email" name="smtp_sender_email">
                        </div>
                     </div>
                  </div>
               </div>
            </div>
            <div class="form-row">
               <label for="smtp_username" class="col-sm-3 col-md-2 col-form-label">Reply to : </label>
               <div class="col-sm-9 col-md-10">
                  <div class="row">
                     <div class="col-sm-6">
                        <div class="input-group">
                           <div class="input-group-prepend">
                              <div class="input-group-text">Name</div>
                           </div>
                           <input type="text" class="form-control" id="smtp_reply_name" name="smtp_reply_name">
                        </div>
                     </div>
                     <div class="col-sm-6">
                        <div class="input-group">
                           <div class="input-group-prepend">
                              <div class="input-group-text">Email</div>
                           </div>
                           <input type="text" class="form-control" id="smtp_reply_email" name="smtp_reply_email">
                        </div>
                     </div>
                  </div>
               </div>
            </div>
            <div class="form-row d-none">
               <label for="smtp_enable" class="col-sm-3 col-md-2 col-form-label">เปิดใช้งาน : </label>
               <div class="col-sm-9 col-md-10">
                  <div class="row">
                     <div class="col-sm-6">
                        <div class="custom-control custom-checkbox">
                           <input type="checkbox" class="custom-control-input" id="smtp_enable" name="smtp_enable" value="1">
                           <label class="custom-control-label" for="smtp_enable"></label>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>

         <div class="form-legend show-form-child">Recipient Email</div>
         <div class="collapse">
            <div class="form-row">
               <label for="recipient_order" class="col-sm-3 col-md-2 col-form-label">Order Form : </label>
               <div class="col-sm-9 col-md-5">
                  <input type="text" class="form-control" id="recipient_order" name="recipient_order">
                  <p class="small mt-2 text-muted">คั่นด้วย ,</p>
               </div>
            </div>
            <div class="form-row">
               <label for="recipient_contact" class="col-sm-3 col-md-2 col-form-label">Contact Form : </label>
               <div class="col-sm-9 col-md-5">
                  <input type="text" class="form-control" id="recipient_contact" name="recipient_contact">
                  <p class="small mt-2 text-muted">คั่นด้วย ,</p>
               </div>
            </div>
         </div>

         <div class="form-legend show-form-child d-none">Splash Page</div>
         <div class="collapse d-none">
            <div class="form-row">
               <label for="splash_enable" class="col-sm-12 col-md-2 col-form-label">ใช้งาน : </label>
               <div class="col-sm-12 col-md-6">
                  <div class="custom-control custom-checkbox">
                     <input type="checkbox" class="custom-control-input" id="splash_enable" name="splash_enable" value="1">
                     <label class="custom-control-label" for="splash_enable"></label>
                  </div>
               </div>
            </div>
            <div class="form-row">
               <label for="splash_startdatex" class="col-sm-12 col-md-2 col-form-label">วันที่ : </label>
               <div class="col-sm-12 col-md-6">
                  <div class="input-group">
                     <div class="input-group-prepend">
                        <div class="input-group-text">เริ่มต้น</div>
                     </div>
                     <input type="text" class="form-control" id="splash_startdate" name="splash_startdate">
                     <div class="input-group-prepend">
                        <div class="input-group-text">สิ้นสุด</div>
                     </div>
                     <input type="text" class="form-control" id="splash_enddate" name="splash_enddate">
                  </div>
               </div>
            </div>
            <div class="form-row">
               <label for="splash_image" class="col-sm-12 col-md-2 col-form-label">Image (<?php echo UPLOAD_SPLASH[0][1];?>x<?php echo UPLOAD_SPLASH[0][2];?>) : </label>
               <div class="col-sm-12 col-md-6">
                  <div class="choose-file-container">
                     <div class="input-group">
                        <input type="text" class="form-control file_name" disabled>
                        <div class="input-group-append">
                           <button type="button" class="btn btn-choose-file shadow input-group-text" onclick="$('#splash_image').trigger('click');">เลือกภาพ</button>
                        </div>
                        <div class="input-group-append">
                           <button type="button" class="btn btn-clear-file input-group-text" title="นำไฟล์ที่เลือกออก" disabled><i class="la la-times"></i></button>
                        </div>
                     </div>
                     <input type="file" class="form-control d-none" id="splash_image" name="splash_image" accept="<?php echo implode(',' , UPLOAD_ACCEPT_IMAGE_TYPE);?>">
                  </div>
                  <div class="preview-image-holder preview-image-holder-100p mt-2">
                     <img src="" class="current-splash-image" style="max-width: 100%;" />
                  </div>
                  <div class="d-none has-splash-image mt-2">
                     <input type="checkbox" name="delete_splash_image" id="delete_splash_image" value="1">
                     <span class="text-muted small align-top">ลบภาพ</span>
                  </div>
               </div>
            </div>
            <div class="form-row">
               <label for="splash_link" class="col-sm-3 col-md-2 col-form-label">Link : </label>
               <div class="col-sm-12 col-md-6">
                  <input type="text" class="form-control" id="splash_link" name="splash_link">
               </div>
            </div>
         </div>

         <div class="form-legend show-form-child d-none">Home Popup</div>
         <div class="collapse d-none">
            <div class="form-row">
               <label for="popup_enable" class="col-sm-12 col-md-2 col-form-label">ใช้งาน : </label>
               <div class="col-sm-12 col-md-6">
                  <div class="custom-control custom-checkbox">
                     <input type="checkbox" class="custom-control-input" id="popup_enable" name="popup_enable" value="1">
                     <label class="custom-control-label" for="popup_enable"></label>
                  </div>
               </div>
            </div>
            <div class="form-row">
               <label for="popup_startdatex" class="col-sm-12 col-md-2 col-form-label">วันที่ : </label>
               <div class="col-sm-12 col-md-6">
                  <div class="input-group">
                     <div class="input-group-prepend">
                        <div class="input-group-text">เริ่มต้น</div>
                     </div>
                     <input type="text" class="form-control" id="popup_startdate" name="popup_startdate">
                     <div class="input-group-prepend">
                        <div class="input-group-text">สิ้นสุด</div>
                     </div>
                     <input type="text" class="form-control" id="popup_enddate" name="popup_enddate">
                  </div>
               </div>
            </div>
            <div class="form-row">
               <label for="popup_image" class="col-sm-12 col-md-2 col-form-label">Image (<?php echo UPLOAD_POPUP[0][1];?>x<?php echo UPLOAD_POPUP[0][2];?>) : </label>
               <div class="col-sm-12 col-md-6">
                  <div class="choose-file-container">
                     <div class="input-group">
                        <input type="text" class="form-control file_name" disabled>
                        <div class="input-group-append">
                           <button type="button" class="btn btn-choose-file shadow input-group-text" onclick="$('#popup_image').trigger('click');">เลือกภาพ</button>
                        </div>
                        <div class="input-group-append">
                           <button type="button" class="btn btn-clear-file input-group-text" title="นำไฟล์ที่เลือกออก" disabled><i class="la la-times"></i></button>
                        </div>
                     </div>
                     <input type="file" class="form-control d-none" id="popup_image" name="popup_image" accept="<?php echo implode(',' , UPLOAD_ACCEPT_IMAGE_TYPE);?>">
                  </div>
                  <div class="preview-image-holder preview-image-holder-100p mt-2">
                     <img src="" class="current-popup-image" style="max-width: 100%;" />
                  </div>
                  <div class="d-none has-popup-image mt-2">
                     <input type="checkbox" name="delete_popup_image" id="delete_popup_image" value="1">
                     <span class="text-muted small align-top">ลบภาพ</span>
                  </div>
               </div>
            </div>
            <div class="form-row">
               <label for="popup_link" class="col-sm-3 col-md-2 col-form-label">Link : </label>
               <div class="col-sm-12 col-md-6">
                  <input type="text" class="form-control" id="popup_link" name="popup_link">
               </div>
            </div>
         </div>

         <div class="form-legend show-form-child d-none">News</div>
         <div class="collapse d-none">
            <div class="form-row">
               <label for="news_tags_home" class="col-sm-12 col-md-2 col-form-label">Home Tags : </label>
               <div class="col-sm-12 col-md-6">
                  <textarea class="form-control" rows="5" id="news_tags_home" name="news_tags_home"></textarea>
                  <p class="text-muted small">ex. tag1, tag2</p>
               </div>
            </div>
         </div>
      </div>
   </form>

</div>

<script src="<?php echo base_url();?>assets/libs/jscolor/jscolor.js"></script>
<script type="text/javascript">
    $(document).ready(function () {

        $('#smtp_password').on('blur', function() {
            $(this).prop('type', 'password');
        });
        $('#smtp_password').on('click', function() {
            if($(this).prop('type') == 'password') {
                $(this).prop('type', 'text');
            }
            else {
                $(this).prop('type', 'password');
            }
        });

        $('#splash_startdate, #splash_enddate, #popup_startdate, #popup_enddate').datetimepicker({
            format:'Y-m-d H:i',
            timepicker: true,
            step: 10,
            scrollInput: false
        });

        form_read();

        // Update row
        $(document).on('click', '.btn-update-setting', function()
        {
            let btn = $('.btn-update');
            btn.prop('disabled', true);
            btn.prepend('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>');
            btn.find('i').hide();
            btn.find('.text').text('กำลังอัพเดต');

            //update CKEditor
            if(typeof CKEDITOR !== 'undefined')
            {
                for(let i in CKEDITOR.instances)
                {
                    CKEDITOR.instances[i].updateElement();
                }
            }

            if(!UPDATE_PATH)
            {
                UPDATE_PATH = 'bos/setting/update';
            }

            let req = request_post(UPDATE_PATH, $('#formData').serialize());
            req.done(function (response, statusText, xhr)
            {
                if(response && !response.success)
                {
                    error(response.message);
                }
                else{
                    //console..log('อัพเดตเรียบร้อย..');
                    updateId = null;

                    success('อัพเดตเรียบร้อย..');

                    btn.find('i').show();
                    btn.find('.spinner-border').remove();
                    btn.find('.text').text('อัพเดตเรียบร้อย !');

                    $('#delete_meta_image').prop('checked', false);
                    $('#delete_logo').prop('checked', false);

                    form_read();
                }
            });
        });
    });

    function form_read() {
        let READ_PATH = 'bos/setting/listing';
        let req = request_post(READ_PATH);
        req.done(function(response, statusText, xhr)
        {
            if(response && !response.success)
            {
                error(response.message);
            }
            else{
                //console.log(response);
                if(response.data)
                {
                    $('#admin_name').val(response.data.admin_name);
                    $('#admin_listing_perpage').val(response.data.admin_listing_perpage);
                    if(response.data.logo_url)
                    {
                        $('.has-logo').removeClass('d-none').addClass('d-block');
                        $('.current-logo').attr('src', response.data.logo_url+'?x='+ Math.random());
                    }
                    else {
                        $('.has-logo').addClass('d-none').removeClass('d-block');
                        $('.current-logo').attr('src', '');
                    }
                    $('#admin_theme_primary').val(response.data.admin_theme_primary);
                    $('#admin_theme_secondary').val(response.data.admin_theme_secondary);
                    $('#admin_theme_textcolor').val(response.data.admin_theme_textcolor);
                    if(response.data.admin_theme_primary)
                    {
                        $('#admin_theme_primary').css('background-color', '#'+response.data.admin_theme_primary);
                    }
                    if(response.data.admin_theme_secondary)
                    {
                        $('#admin_theme_secondary').css('background-color', '#'+response.data.admin_theme_secondary);
                    }
                    if(response.data.admin_theme_textcolor)
                    {
                        $('#admin_theme_textcolor').css('background-color', '#'+response.data.admin_theme_textcolor);
                    }
                    if(response.data.admin_theme_gradient === '1')
                    {
                        $('#admin_theme_gradient').prop('checked', true);
                    }
                    else {
                        $('#admin_theme_gradient').prop('checked', false);
                    }

                    $('#website_limit_user_log').val(response.data.website_limit_user_log);
                    $('#admin_cache').val(response.data.admin_cache);

                    $('#contact_title').val(response.data.contact_title);
                    $('#contact_detail').val(response.data.contact_detail);
                    $('#contact_email').val(response.data.contact_email);
                    $('#contact_phone').val(response.data.contact_phone);
                    $('#contact_open').val(response.data.contact_open);
                    $('#contact_map').val(response.data.contact_map);

                    $('#social_facebook').val(response.data.social_facebook);
                    $('#social_twitter').val(response.data.social_twitter);
                    $('#social_instagram').val(response.data.social_instagram);
                    $('#social_youtube').val(response.data.social_youtube);
                    $('#social_tiktok').val(response.data.social_tiktok);
                    $('#social_line').val(response.data.social_line);

                    $('#custom_script_head').val(response.data.custom_script_head);
                    $('#custom_script_body').val(response.data.custom_script_body);

                    $('#seo_meta_title').val(response.data.seo_meta_title);
                    $('#seo_meta_keywords').val(response.data.seo_meta_keywords);
                    $('#seo_meta_description').val(response.data.seo_meta_description);
                    if(response.data.seo_meta_image_url)
                    {
                        $('.has-meta-image').removeClass('d-none').addClass('d-block');
                        $('.current-meta-image').attr('src', response.data.seo_meta_image_url+'?x='+ Math.random());
                    }
                    else {
                        $('.has-meta-image').addClass('d-none').removeClass('d-block');
                        $('.current-meta-image').attr('src', '');
                    }

                    if(response.data.splash_enable === '1')
                    {
                        $('#splash_enable').prop('checked', true);
                    }
                    else {
                        $('#splash_enable').prop('checked', false);
                    }
                    $('#splash_startdate').val(response.data.splash_startdate);
                    $('#splash_enddate').val(response.data.splash_enddate);
                    $('#splash_link').val(response.data.splash_link);
                    if(response.data.splash_image_url)
                    {
                        $('.has-splash-image').removeClass('d-none').addClass('d-block');
                        $('.current-splash-image').attr('src', response.data.splash_image_url+'?x='+ Math.random());
                    }
                    else {
                        $('.has-splash-image').addClass('d-none').removeClass('d-block');
                        $('.current-splash-image').attr('src', '');
                    }

                    if(response.data.popup_enable === '1')
                    {
                        $('#popup_enable').prop('checked', true);
                    }
                    else {
                        $('#popup_enable').prop('checked', false);
                    }
                    $('#popup_startdate').val(response.data.popup_startdate);
                    $('#popup_enddate').val(response.data.popup_enddate);
                    $('#popup_link').val(response.data.popup_link);
                    if(response.data.popup_image_url)
                    {
                        $('.has-popup-image').removeClass('d-none').addClass('d-block');
                        $('.current-popup-image').attr('src', response.data.popup_image_url+'?x='+ Math.random());
                    }
                    else {
                        $('.has-popup-image').addClass('d-none').removeClass('d-block');
                        $('.current-popup-image').attr('src', '');
                    }

                    $('#news_tags_home').val(response.data.news_tags_home);

                    //SMTP
                    $('#smtp_hostname').val(response.data.smtp_hostname);
                    $('#smtp_username').val(response.data.smtp_username);
                    $('#smtp_password').val(response.data.smtp_password);
                    $('#smtp_port').val(response.data.smtp_port);
                    $('#smtp_secure').val(response.data.smtp_secure);
                    $('#smtp_sender_name').val(response.data.smtp_sender_name);
                    $('#smtp_sender_email').val(response.data.smtp_sender_email);
                    $('#smtp_reply_name').val(response.data.smtp_reply_name);
                    $('#smtp_reply_email').val(response.data.smtp_reply_email);
                    if(response.data.smtp_enable === '1')
                    {
                        $('#smtp_enable').val(1);
                        $('#smtp_enable').prop('checked', true);
                    }
                    else {
                        $('#smtp_enable').val('');
                        $('#smtp_enable').prop('checked', false);
                    }

                    $('#recipient_order').val(response.data.recipient_order);
                    $('#recipient_contact').val(response.data.recipient_contact);

                    $('#text1_th').val(response.data.text1_th);
                    $('#text2_th').val(response.data.text2_th);
                    $('#text1_en').val(response.data.text1_en);
                    $('#text2_en').val(response.data.text2_en);
                }
            }
        });
    }
</script>