<!-- Listing -->
<?php include 'application/views/bos/listing-tools.php';?>

<div class="card-body">
   <div class="table-responsive-sm table-listing popup-gallery">
      <form id="formListing">
         <table class="table table-striped table-hover table-bordered">
         <thead>
         <tr>
            <th class="text-center w80">#</th>
            <th>ชื่อ (TH)</th>
            <th>ชื่อ (EN)</th>
            <th class="text-center d-none d-sm-table-cell w80">สถานะ</th>
            <th class="text-center d-none d-sm-table-cell w80">อัพเดตเมื่อ</th>
            <th class="text-center w100">เครื่องมือ</th>
         </tr>
         <tr class="row-filter">
            <?php if(!empty($this->is_highlight)){ ?>
               <td class="inline-tools">
                  <button class="btn btn-light btn-sm shadow toolbar-save-order d-none" type="button" title="บันทึก"><i class="las la-save align-middle"></i></button>
               </td>
            <?php }else{ ?>
               <td></td>
            <?php } ?>
            <td><input type="text" id="filter_title" placeholder="พิมพ์คำค้นหา" class="form-control"></td>
            <td><input type="text" id="filter_title_en" placeholder="พิมพ์คำค้นหา" class="form-control"></td>
            <td class="d-none d-sm-table-cell">
               <select class="form-control" id="filter_status">
                  <option value=""></option>
                  <option value="1">ใช้งาน</option>
                  <option value="-1">ระงับ</option>
               </select>
            </td>
            <td class="d-none d-sm-table-cell"></td>
            <td class="inline-tools">
               <button class="btn btn-light btn-sm shadow toolbar-filter-search" type="button" title="ค้นหา"><i class="las la-search las la-pen align-middle"></i></button>
               <button class="btn btn-light btn-sm shadow toolbar-filter-reset" type="button" title="รีเซ็ต"><i class="las la-times las la-pen align-middle"></i></button>
            </td>
         </tr>
         </thead>
         <tbody id="load_rows">
         <!-- Display rows from js -->
         </tbody>
      </table>
      </form>
   </div>
</div>

<?php include('application/views/bos/pager.php');?>

<script type="text/javascript">
   let keyId = 'product_category_id';

   //Setup modal form
   var modalSize = ''; // modal-sm, none, modal-lg, modal-xl

   //Display row
   request_listing_order(null);

   function display_rows(data, start, limit)
   {
      let html = '';
      let row = data.rows;
      for(let i=start;i<(data.rows.length<limit ? data.rows.length:limit);i++)
      {

          html += '<tr class="row_no" rowId="'+row[i].product_category_id+'">';
          html += '<th><input type="text" min="0" class="form-control form-control-sm text-center form-reorder" name="orderids['+row[i].product_category_id+']" data-id="'+row[i].product_category_id+'" value="'+output_text(row[i].orderid)+'" autocomplete="off"></th>';
          html += '<td><span class="title"><a href="'+BASE_URL+'product/category/'+output_text(row[i].rewrite_url)+'" target="_blank">'+output_text(row[i].title)+'</a></span></td>';
          html += '<td>'+output_text(row[i].title_en)+'</td>';
          html += '<td class="text-center d-none d-sm-table-cell">'+row_status(row[i].status)+'</td>';
          html += '<td class="text-center d-none d-sm-table-cell small text-muted">'+row_updated(row[i])+'</td>';
          html += '<td class="inline-tools"><?php echo $button_inline;?></td>';
          html += '</tr>';
      }
      $("#load_rows").html(html);
   }

   //Toolbar : Filters
   $(document).on('click', '.toolbar-filter-search', function(){
       filters = {
           title: $('#filter_title').val(),
           title_en: $('#filter_title_en').val(),
           status: $('#filter_status').val(),
       };

       request_listing(filters);
   });
   $(document).on('click', '.toolbar-filter-reset', function(){
       $('#filter_title').val('');
       $('#filter_title_en').val('');
       $('#filter_status').val('');

       request_listing({title: '', title_en: '', status: ''});
   });

   //Form validate
   let validate = {
       title: {
           input: 'text',
       },
       title_en: {
           input: 'text',
       },
       rewrite_url: {
           input: 'text',
           eng: true,
           existing: {
               require: true,
               exclude: '#exclude'
           }
       }
   };
</script>
