<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Product_model extends Frontend_Model
{
   public function __construct()
   {
      parent::__construct();

      $this->table_name = 'cms_product';
      $this->primary_key = 'product_id';
      $this->set_ref = TRUE;
   }

   public function listing($filters = NULL, $per_page = NULL, $offset = NULL)
   {
      if(!empty($filters))
      {
         if(!empty($filters['title']))
         {
            $this->db->like('n.title', input_to_sql($filters['title']));
         }
         if(!empty($filters['title_th']))
         {
            $this->db->like('n.title_th', input_to_sql($filters['title_th']));
         }
         if(!empty($filters['title_en']))
         {
            $this->db->like('n.title_en', input_to_sql($filters['title_en']));
         }
         if(!empty($filters['product_id']))
         {
            $this->db->where('n.product_id', input_to_sql($filters['product_id']));
         }
         if(!empty($filters['product_category_id']))
         {
            $this->db->where('n.product_category_id', input_to_sql($filters['product_category_id']));
         }
         if(!empty($filters['rewrite_url']))
         {
            $this->db->where('n.rewrite_url', input_to_sql($filters['rewrite_url']));
         }
         if(!empty($filters['q']))
         {
            $q = input_to_sql($filters['q']);
            $this->db->where(" (n.title LIKE '%$q%' || n.title_en LIKE '%$q%' || n.intro LIKE '%$q%' || n.intro_en LIKE '%$q%' || n.detail LIKE '%$q%' || n.detail_en LIKE '%$q%' || n.keyword LIKE '%$q%' || n.keyword_en LIKE '%$q%' || i.code LIKE '%$q%' || i.od LIKE '%$q%' || i.length LIKE '%$q%' || i.hole LIKE '%$q%' || i.strength LIKE '%$q%' || i.shear LIKE '%$q%' || i.depth LIKE '%$q%')");
         }
      }

      $this->db->distinct();
      $this->db->select('n.*');
      $this->db->order_by('n.orderid', 'ASC');
      $this->db->order_by('n.product_id', 'DESC');
      $this->db->where('n.status', GLOBAL_STATUS_ENABLED);


      $this->db->join('cms_product_item i', 'i.product_id=n.product_id', 'RIGHT');
      if(!empty($filters['product_od']) || !empty($filters['product_length']))
      {
         if(!empty($filters['product_od']))
         {
            $this->db->where('i.od', input_to_sql($filters['product_od']));
         }
         if(!empty($filters['product_length']))
         {
            $this->db->where('i.length', input_to_sql($filters['product_length']));
         }
      }

      $result = $this->db->get($this->table_name.' n')->result();
      return $result;
   }
}