<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Product_item_model extends Frontend_Model
{
   public function __construct()
   {
      parent::__construct();

      $this->table_name = 'cms_product_item';
      $this->primary_key = 'product_item_id';
      $this->set_ref = TRUE;
   }

   public function listing($filters = NULL, $per_page = NULL, $offset = NULL)
   {
      if(!empty($filters))
      {
         if(!empty($filters['product_id']))
         {
            $this->db->where('n.product_id', input_to_sql($filters['product_id']));
         }
         if(!empty($filters['od']))
         {
            $this->db->where('n.od', input_to_sql($filters['od']));
         }
         if(!empty($filters['length']))
         {
            $this->db->where('n.length', input_to_sql($filters['length']));
         }
         if(!empty($filters['code']))
         {
            $this->db->where('n.code', input_to_sql($filters['code']));
         }
      }

      $this->db->distinct();
      $this->db->select('n.*');
      $this->db->order_by('n.orderid', 'ASC');
      $this->db->where('n.status', GLOBAL_STATUS_ENABLED);
      $result = $this->db->get($this->table_name.' n')->result();
      return $result;
   }
}