<?php defined('BASEPATH') OR exit('No direct script access allowed');

class User_model extends MY_Model
{
   public function __construct()
   {
      parent::__construct();

      $this->table_name = 'cms_users';
      $this->primary_key = 'user_id';
      $this->set_ref = TRUE;
   }

   /**
    *
    * Get user profile
    *
    * @param $id
    * @return mixed
    */
   public function profile($user_id)
   {
      $this->db->select('p.user_id, p.firstname, p.lastname, p.nickname, p.gender, p.phone, p.email, p.cover_ext, p.created_at, p.updated_at, p.role_id, r.title as role_name');
      $this->db->where('p.'.$this->primary_key, $user_id);
      $this->db->where('p.status', GLOBAL_STATUS_ENABLED);
      $this->db->join('cms_user_role r', 'r.role_id=p.role_id', 'LEFT');
      $row = $this->db->get($this->table_name. ' p')->row();

      return $row;
   }

   /**
    *
    * Enabled user
    *
    * @param $user_id
    */
   public function enabled($user_id)
   {
      $data = new stdClass();
      $data->status = GLOBAL_STATUS_ENABLED;
      $data->user_id = $user_id;
      $this->update($data, TRUE);
   }

   /**
    *
    * Disabled user
    *
    * @param $user_id
    */
   public function disabled($user_id)
   {
      $data = new stdClass();
      $data->status = GLOBAL_STATUS_DISABLED;
      $data->user_id = $user_id;
      $this->update($data, TRUE);
   }

   /**
    *
    * Locked user if exceed login
    *
    * @param $email
    */
   public function locked($email)
   {
      $this->primary_key = 'email';

      $data = new stdClass();
      $data->locked = USER_ACCOUNT_LOCKED;
      $data->email = $email;
      $data->locked_at = datetime_now();
      $this->update($data, FALSE);

      $this->primary_key = 'user_id';
   }

   /**
    *
    * Unlock user if ..
    *
    * @param $user_id
    */
   public function unlock($user_id)
   {
      $data = new stdClass();
      $data->locked = USER_ACCOUNT_UNLOCK;
      $data->user_id = $user_id;
      $this->update($data, TRUE);
   }

   /**
    *
    * Check existing email
    *
    * @param $email
    * @param null $exclude_user_id
    * @return bool
    */
   public function exist_email($email, $exclude_user_id = NULL)
   {
      $this->db->where('email', $email);
      if($exclude_user_id){
         $this->db->where('user_id !=', $exclude_user_id);
      }
      $total = $this->db->count_all_results($this->table_name);

      return ($total>0);
   }

   /**
    *
    * Check existing phone
    *
    * @param $phone
    * @param null $exclude_user_id
    * @return bool
    */
   public function exist_phone($phone, $exclude_user_id = NULL)
   {
      $this->db->where('phone', $phone);
      $this->db->where('phone !=', '');
      if($exclude_user_id){
         $this->db->where('user_id !=', $exclude_user_id);
      }
      $total = $this->db->count_all_results($this->table_name);

      return ($total>0);
   }

   /**
    *
    * Listing to cms
    *
    * @param int $limit
    * @param null $filters
    * @return mixed
    */
   public function listing($filters = NULL)
   {
      $this->db->select('p.user_id, p.firstname, p.lastname, p.email, p.locked, p.status, p.updated_at, p.updated_by, u.firstname as admin, g.title as role, CONCAT_WS(" ", p.firstname, p.lastname) as fullname, p.cover_ext, p.gender, p.lastlogin_at');
      $this->db->order_by('p.user_id', 'DESC');

      if(!empty($filters))
      {
         if(!empty($filters['name']))
         {
            $this->db->like('p.firstname', input_to_sql($filters['name']));
         }
         if(!empty($filters['email']))
         {
            $this->db->like('p.email', input_to_sql($filters['email']));
         }
         if(!empty($filters['role_id']))
         {
            $this->db->where('p.role_id', input_to_sql($filters['role_id']));
         }
         if(!empty($filters['status']))
         {
            $this->db->where('p.status', $filters['status'] == 1 ? 1:0);
         }
         if(!empty($filters['login_user_role_id']) && $filters['login_user_role_id'] != 1)
         {
            $this->db->where('p.role_id !=', 1);
         }
      }

      $this->db->join('cms_user_role g', 'g.role_id=p.role_id', 'LEFT');
      $this->db->join('cms_users u', 'u.user_id=p.created_by', 'LEFT');

      $result = $this->db->get($this->table_name.' p')->result();
      return $result;
   }

   public function listing_name()
   {
      $this->db->select('p.user_id, CONCAT_WS(" ", p.firstname, p.lastname) as fullname');
      $this->db->order_by('fullname', 'DESC');
      $this->db->where('p.role_id !=', 1);

      $result = $this->db->get($this->table_name.' p')->result();
      return $result;
   }

   /**
    *
    * View
    *
    * @return mixed
    */
   public function read($id, $filters = NULL)
   {
      $this->db->select('p.*, u.firstname as admin, g.title as role');
      $this->db->where('p.'.$this->primary_key, (int)$id);

      $this->db->join('cms_user_role g', 'g.role_id=p.role_id', 'LEFT');
      $this->db->join('cms_users u', 'u.user_id=p.created_by', 'LEFT');
      $row = $this->db->get($this->table_name.' p')->row();
      unset($row->password);

      return  $row;
   }

   public function create_user(&$data)
   {
      $row = new stdClass();
      $row->role_id = $data->role_id;

      $row->created_at = datetime_now();
      $row->created_by = $data->created_by;
      $row->created_ip = $this->input->ip_address();

      $this->db->insert($this->table_name, $row);
      $last_id = $this->db->insert_id();

      return $last_id;
   }

   /**
    *
    * Update user row
    *
    * @param $data
    * @param bool $set_ref
    * @return mixed
    */
   public function update_user(&$data)
   {
      $primary_id = $data->user_id;

      $data->updated_at = datetime_now();
      $data->updated_by = $data->created_by;
      $data->updated_ip = $this->input->ip_address();

      unset($data->user_id);
      unset($data->exclude);
      unset($data->confirm_password);
      unset($data->created_by);

      $this->db->where($this->primary_key, $primary_id);
      $this->db->update($this->table_name, $data);

      return $primary_id;
   }
}