<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Setting_model extends MY_Model
{
   public function __construct()
   {
      parent::__construct();

      $this->table_name = 'cms_setting';
      $this->primary_key = 'setting_id';
   }

   public function listing($filters = NULL)
   {
      $this->listing_filters($filters);

      $this->db->distinct();
      $this->db->select('n.*, u.firstname as admin');
      $this->db->order_by('n.setting_type', 'ASC');
      $this->db->order_by('n.setting_var', 'ASC');
      $this->db->order_by('n.'.$this->primary_key, 'DESC');
      $this->db->join('cms_users u', 'u.user_id=n.created_by', 'LEFT');
      $result = $this->db->get($this->table_name.' n')->result();

      return  $result;
   }

   public function update(&$data, $set_ref = FALSE)
   {
      foreach($data as $key=>$val)
      {
         $row = new stdClass();
         $row->setting_data = $val;
         $row->created_at = date('Y-m-d H:i:s');
         $row->created_by = $data->created_by;
         $row->created_ip = $this->input->ip_address();

         $this->db->where('setting_var', $key);
         $this->db->update($this->table_name, $row);
      }

      return 1;
   }
}