<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Product_item_model extends MY_Model
{
   public function __construct()
   {
      parent::__construct();

      $this->table_name = 'cms_product_item';
      $this->primary_key = 'product_item_id';
      $this->set_ref = TRUE;
   }

   public function listing($filters = NULL, $per_page = NULL, $offset = NULL)
   {
      $this->listing_filters($filters);

      $this->db->distinct();
      $this->db->select('n.*, u.firstname as admin');
      $this->db->order_by('n.orderid', 'ASC');
      $this->db->order_by('n.'.$this->primary_key, 'ASC');
      $this->db->join('cms_users u', 'u.user_id=n.created_by', 'LEFT');
      if(!empty($per_page) ) {
         $this->db->limit($per_page, !empty($offset) ? $offset : 0);
      }
      $result = $this->db->get($this->table_name.' n')->result();
      return $result;
   }
}