<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Login_model extends MY_Model
{
   public function __construct()
   {
      parent::__construct();

      $this->table_name = 'cms_users';
      $this->primary_key = 'user_id';
      $this->set_ref = TRUE;
   }

   /**
    *
    * Find account / check login
    *
    * @param $email
    * @return mixed
    */
   public function find($email)
   {
      $this->db->select('user_id, status, lastlogin_at, locked, password, locked_at, login_attempts');
      $this->db->where('email', $email);
      $row = $this->db->get($this->table_name)->row();

      return $row;
   }

   /**
    *
    * Logged in status
    *
    * @param $user_id
    */
   public function login_status($datas, $status_code, $attempts = 0)
   {
      $this->primary_key = 'email';

      $data = new stdClass();
      $data->email = $datas->email;
      $data->created_by = !empty($datas->user_id) ? $datas->user_id:0;
      $data->lastlogin_at = datetime_now();
      $data->lastlogin_ip = $this->input->ip_address();
      $data->lastlogin_status = $status_code;
      $data->lastlogin_answer = $datas->answer;
      $data->login_attempts = $attempts;

      $this->update($data, TRUE);

      $this->primary_key = 'user_id';
   }

}