<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Geo
{
   private $CI = NULL;

   function __construct()
   {
      $this->CI =& get_instance();

      $this->CI->load->model('shared/province_model');
      $this->CI->load->model('shared/amphur_model');
      $this->CI->load->model('shared/district_model');
   }

   public function province_name()
   {
      $listing = $this->CI->province_model->listing();
      $result = [];
      if(!empty($listing))
      {
         foreach($listing as $row)
         {
            $result[$row->province_id] = $row->name;
         }
      }
      return $result;
   }

   public function amphur_name()
   {
      $listing = $this->CI->amphur_model->listing();
      $result = [];
      if(!empty($listing))
      {
         foreach($listing as $row)
         {
            $result[$row->amphur_id] = $row->name;
         }
      }
      return $result;
   }

   public function district_name()
   {
      $listing = $this->CI->district_model->listing();
      $result = [];
      if(!empty($listing))
      {
         foreach($listing as $row)
         {
            $result[$row->district_id] = $row->name;
         }
      }
      return $result;
   }
}