<?php
/**
 * @return object
 */
function json_input()
{
   return json_decode(file_get_contents("php://input"), FALSE);
}

/**
 * @param $value
 * @return string
 */
function input_to_sql($value='', $allow_html = FALSE, $return_null = FALSE)
{
   if(!empty($value))
   {
      $value = trim($value);
      //$value = replace_editor_write($value);
      if(!$allow_html)
      {
         $value = addslashes($value);
         $value = strip_tags($value);
      }
      return $value;
   }
   else {
      return $return_null ? NULL:'';
   }
}

function input_template($value, $allow_html = FALSE)
{
   return input_to_sql($value, $allow_html, FALSE);
}

/**
 * @return false|string
 */
function date_now()
{
   return date('Y-m-d');
}

/**
 * @return false|string
 */
function datetime_now()
{
   return date('Y-m-d H:i:s');
}

function thai_datetime()
{
   $y = date('Y') + 543;
   $dm = date('d/m');
   return $dm . '/' . $y. ' '.date('H:i:s');
}

function thai_date()
{
   $y = date('Y') + 543;
   $dm = date('d/m');
   return $dm . '/' . $y;
}

/**
 * @param $arr
 */
function print_array($arr)
{
   echo '<pre>';
   print_r($arr);
   echo '</pre>';
}

function form_output($str, $allow_html = false)
{
   $str = trim($str);
   $str = htmlspecialchars($str, ENT_QUOTES);
   $str = stripslashes($str);
   //$str = replace_editor_form($str);
   if(!$allow_html)
   {
      $str = strip_tags($str);
   }

   return $str;
}

function input_str($str)
{
   $str = trim($str);
   $str = htmlspecialchars($str, ENT_QUOTES);
   return $str;
}

function output_str($str)
{
   $str = trim($str);
   $str = htmlspecialchars_decode($str, ENT_QUOTES);
   $str = stripslashes($str);
   return $str;
}

function output_html($html)
{
   $html = trim($html);
   $html = stripslashes($html);
   //$html = replace_editor_read($html);
   $html = replace_youtube_wrapper($html);
   $html = str_replace('style="text-align: center;"', 'class="text-center"', $html);

   return $html;
}

function output_text($str)
{
   $str = trim($str);
   $str = strip_tags($str);
   $str = stripslashes($str);

   return $str;
}

function output_text_detail($str)
{
   $str = trim($str);
   $str = nl2br($str);
   $str = stripslashes($str);

   return $str;
}

function replace_youtube_wrapper($html)
{
   if(strpos($html, 'youtube-embed-wrapper') !== FALSE)
   {
      $html = str_replace('youtube-embed-wrapper', 'video_wrapper_outer', $html);
      $html = remove_style($html);
      $html = str_replace('<iframe', '<div class="video_wrapper_inner"><iframe', $html);
      $html = str_replace('</iframe>', '</iframe></div>', $html);
   }
   return $html;
}

function remove_style($html)
{
   return preg_replace('/(<[^>]*) style=("[^"]+"|\'[^\']+\')([^>]*>)/i', '$1$3', $html);
}

function replaceImgRes($value)
{
   if(!strpos($value, 'img-fluid'))
   {
      $value = preg_replace('/(\<img[^>]+)(style\=\"[^\"]+\")([^>]+)(>)/', '${1}${3}${4}', $value);
      $value = str_replace('<img ', '<img class="img-fluid" ', $value);
   }
   return $value;
}

function replace_editor_write($html)
{
   $html = str_replace('src="'.base_url(), 'src="', $html);
   return $html;
}

function replace_editor_form($html)
{
   $html = str_replace(UPLOAD, base_url().UPLOAD, $html);
   return $html;
}

function replace_editor_read($html)
{
   $html = str_replace('src="'.UPLOAD, 'src="'.base_url().UPLOAD, $html);
   return $html;
}

function DateDiff($strDate1,$strDate2)
{
   return (strtotime($strDate2) - strtotime($strDate1))/  ( 60 * 60 * 24 );  // 1 day = 60*60*24
}

function TimeDiff($strTime1,$strTime2)
{
   return (strtotime($strTime2) - strtotime($strTime1))/  ( 60 * 60 ); // 1 Hour =  60*60
}

function DateTimeDiff($strDateTime1,$strDateTime2)
{
   return (strtotime($strDateTime2) - strtotime($strDateTime1))/  ( 60 * 60 ); // 1 Hour =  60*60
}

function gallery_name($post_id, $gallery_id)
{
   return $post_id . '_' . $gallery_id;
}

function file_ext($file_name)
{
   $exp = explode('.', $file_name);
   $ext = strtolower($exp[count($exp)-1]);
   return $ext;
}

function status_name($status)
{
   $msg = '<span class="badge badge-danger font-italic">ระงับ</span>';
   if($status==1){
      $msg = '<span class="badge badge-success">ใช้งาน</span>';
   }
   return $msg;
}

function highlight_name($status)
{
   $msg = '<span class="text-highlight"><span class="font-italic"><i class="lar la-star"></i></span></span>';
   if($status==1){
      $msg = '<span class="text-highlight"><span class="text-warning"><i class="las la-star"></i></span></span>';
   }
   return $msg;
}

function user_locked_name($status)
{
   $msg = '<span class="badge badge-light-success">Un-Locked</span>';
   if($status==1){
      $msg = '<span class="badge badge-light-danger font-italic">Locked</span>';
   }
   return $msg;
}

function row_yes_no($id)
{
   $text = '';
   switch($id) {
      case 1:
         $text = '<span class="text-success">ใช่</span>';
         break;
      default:
         $text = '<span class="text-danger">ไม่ใช่</span>';
   }
   return $text;
}

function show_cover_size($cover_size)
{
   $max = count($cover_size) - 1;
   if(!empty($cover_size[$max][1]) && !empty($cover_size[$max][2])){
      return $cover_size[$max][1].'x'.$cover_size[$max][2].' px';
   }
}

function member_code($member_id = '1')
{
   return 'M'.sprintf('%06d', $member_id);
}

function bangkok_district($province_id, $district_name, $abbr = FALSE)
{
   return ($province_id==1 ? 'แขวง':($abbr ? 'ต.':'ตำบล')).$district_name;
}

function bangkok_amphur($province_id, $amphur_name, $abbr = FALSE)
{
   return ($province_id==1 ? 'เขต':($abbr ? 'อ.':'อำเภอ')).$amphur_name;
}

function bangkok_province($province_id, $province_name, $abbr = FALSE)
{
   return ($province_id==1 ? '':($abbr ? 'จ.':'จังหวัด')).$province_name;
}


## START
const BAHT_TEXT_NUMBERS = array('ศูนย์', 'หนึ่ง', 'สอง', 'สาม', 'สี่', 'ห้า', 'หก', 'เจ็ด', 'แปด', 'เก้า');
const BAHT_TEXT_UNITS = array('', 'สิบ', 'ร้อย', 'พัน', 'หมื่น', 'แสน', 'ล้าน');
const BAHT_TEXT_ONE_IN_TENTH = 'เอ็ด';
const BAHT_TEXT_TWENTY = 'ยี่';
const BAHT_TEXT_INTEGER = 'ถ้วน';
const BAHT_TEXT_BAHT = 'บาท';
const BAHT_TEXT_SATANG = 'สตางค์';
const BAHT_TEXT_POINT = 'จุด';
/**
 * Convert baht number to Thai text
 * @param double|int $number
 * @param bool $include_unit
 * @param bool $display_zero
 * @return string|null
 */
function baht_text ($number, $include_unit = true, $display_zero = true)
{
   if (!is_numeric($number)) {
      return null;
   }
   $log = floor(log($number, 10));
   if ($log > 5) {
      $millions = floor($log / 6);
      $million_value = pow(1000000, $millions);
      $normalised_million = floor($number / $million_value);
      $rest = $number - ($normalised_million * $million_value);
      $millions_text = '';
      for ($i = 0; $i < $millions; $i++) {
         $millions_text .= BAHT_TEXT_UNITS[6];
      }
      return baht_text($normalised_million, false) . $millions_text . baht_text($rest, true, false);
   }
   $number_str = (string)floor($number);
   $text = '';
   $unit = 0;
   if ($display_zero && $number_str == '0') {
      $text = BAHT_TEXT_NUMBERS[0];
   } else for ($i = strlen($number_str) - 1; $i > -1; $i--) {
      $current_number = (int)$number_str[$i];
      $unit_text = '';
      if ($unit == 0 && $i > 0) {
         $previous_number = isset($number_str[$i - 1]) ? (int)$number_str[$i - 1] : 0;
         if ($current_number == 1 && $previous_number > 0) {
            $unit_text .= BAHT_TEXT_ONE_IN_TENTH;
         } else if ($current_number > 0) {
            $unit_text .= BAHT_TEXT_NUMBERS[$current_number];
         }
      } else if ($unit == 1 && $current_number == 2) {
         $unit_text .= BAHT_TEXT_TWENTY;
      } else if ($current_number > 0 && ($unit != 1 || $current_number != 1)) {
         $unit_text .= BAHT_TEXT_NUMBERS[$current_number];
      }
      if ($current_number > 0) {
         $unit_text .= BAHT_TEXT_UNITS[$unit];
      }
      $text = $unit_text . $text;
      $unit++;
   }
   if ($include_unit) {
      $text .= BAHT_TEXT_BAHT;
      $satang = explode('.', number_format($number, 2, '.', ''))[1];
      $text .= $satang == 0
         ? BAHT_TEXT_INTEGER
         : baht_text($satang, false) . BAHT_TEXT_SATANG;
   } else {
      $exploded = explode('.', $number);
      if (isset($exploded[1])) {
         $text .= BAHT_TEXT_POINT;
         $decimal = (string)$exploded[1];
         for ($i = 0; $i < strlen($decimal); $i++) {
            $text .= BAHT_TEXT_NUMBERS[$decimal[$i]];
         }
      }
   }
   return $text;
}
## END


function delete_all_cover($path)
{

   @unlink($path.'.gif');
   @unlink($path.'.jpg');
   @unlink($path.'.jpeg');
   @unlink($path.'.png');
}

function hexToRgb($hex, $alpha = false) {
   $hex      = str_replace('#', '', $hex);
   $length   = strlen($hex);
   $rgb = [];
   $rgb[] = hexdec($length == 6 ? substr($hex, 0, 2) : ($length == 3 ? str_repeat(substr($hex, 0, 1), 2) : 0));
   $rgb[] = hexdec($length == 6 ? substr($hex, 2, 2) : ($length == 3 ? str_repeat(substr($hex, 1, 1), 2) : 0));
   $rgb[] = hexdec($length == 6 ? substr($hex, 4, 2) : ($length == 3 ? str_repeat(substr($hex, 2, 1), 2) : 0));
   if ( $alpha ) {
      $rgb[] = $alpha;
   }
   return implode(',', $rgb);
}

function get_query_string_pagination()
{
   $param = [];
   if(!empty($_GET))
   {
      foreach($_GET as $q=>$v)
      {
         if(is_array($v))
         {
            foreach($v as $k)
            {
               $param[] = "$q".urlencode('[]')."=$k";
            }
         }
         else {
            if($q != 'page')
            {
               $param[] = "$q=$v";
            }
         }
      }
   }
   return implode('&', $param);
}

function pagination($total_row, $row_per_page, $startrow, $page_path, $params=''){

   $page_show = "";

   $per_page = $row_per_page;
   $num_of_pages = intval((($total_row - 1) / $row_per_page) + 1);

   $curr_page = $startrow;
   $start = ($curr_page - 1) * $per_page;

   if(($curr_page - 2) == 0)
   {
      $range_min = $curr_page - 1;
      $range_max = $curr_page + 3;
   }
   else if(($curr_page - 1) == 0)
   {
      $range_min = $curr_page;
      $range_max = $curr_page + 4;
   }
   else if(($curr_page + 1) == $num_of_pages)
   {
      $range_min = $curr_page - 3;
      $range_max = $curr_page + 1;
   }
   else if($curr_page == $num_of_pages)
   {
      $range_min = $curr_page - 4;
      $range_max = $curr_page;
   }
   else{
      $range_min = $curr_page - 2;
      $range_max = $curr_page + 2;
   }

   $range_min = $range_min < 0 ? 1 : $range_min;
   $range_max = $num_of_pages > $range_max ? $range_max : $num_of_pages;
   //echo "$num_of_pages $range_min $range_max";

   if($num_of_pages > 1 && $curr_page <= $num_of_pages)
   {
      $page_show .= "<li class=\"prev\"><a href=\"" . $page_path . "?page=1".$params."\" title=\"First\">First</a></li>";

      if($curr_page > 1 && $curr_page < $num_of_pages)
      {
         $page_show .= "<li class=\"prev\"><a href=\"" . $page_path . "?page=" . ($curr_page - 1) . $params . "\" title=\"Prev\">Prev</a></li> ";
         for($x = $range_min; $x <= $range_max; $x++)
         {
            //to make the current page link bold
            if($x > 0)
            {
               $page_show .= ($x == $curr_page) ? "<li class=\"active\"><a href=\"" . $page_path . "?page=" . $x . $params . "\">" . $x . "</a></li> " : "<li><a href=\"" . $page_path . "?page=" . $x . $params . "\">" . $x . "</a></li>";
            }
         }
         $page_show .= "<li class=\"next\"><a href=\"" . $page_path . "?page=" . ($curr_page + 1) . $params . "\" title=\"Next\">Next</a></li> ";
      }
      else if($curr_page == 1)
      {
         for($x = $range_min; $x <= $range_max; $x++)
         {
            //to make the current page link bold
            if($x > 0)
            {
               $page_show .= ($x == $curr_page) ? "<li class=\"active\"><a href=\"" . $page_path . "?page=" . $x . $params . "\">" . $x . "</a></li> " : "<li><a href=\"" . $page_path . "?page=" . $x . $params . "\" title=\"".$x."\">" . $x . "</a></li> ";
            }
         }
         $page_show .= "<li><a class=\"next\" href=\"" . $page_path . "?page=" . ($curr_page + 1) . $params . "\" title=\"Next\">Next</a></li> ";
      }
      else if($curr_page == $num_of_pages)
      {
         $page_show .= "<li class=\"prev\"><a href=\"" . $page_path . "?page=" . ($curr_page - 1) . $params . "\" title=\"Prev\">Prev</a></li> ";

         for($x = $range_min; $x <= $range_max; $x++)
         {
            //to make the current page link bold
            if($x > 0)
            {
               $page_show .= ($x == $curr_page) ? "<li class=\"active\"><a href=\"" . $page_path . "?page=" . $x . $params . "\">" . $x . "</a></li> " : "<li><a href=\"" . $page_path . "?page=" . $x . $params . "\">" . $x . "</a></li> ";
            }
         }
      }

      $page_show .= "<li class=\"next\"><a href=\"" . $page_path . "?page=".$num_of_pages.$params."\" title=\"Last\">Last</a></li>";
   }

   return $page_show;
}

function css_rgba($color_hex, $alpha = 1)
{
   $rgb = hexToRgb('#'.$color_hex);
   return 'rgba('.$rgb.', '.$alpha.')';
}

function button_style()
{
   $button_style = '';
   if(SETTING_THEME_ROUNDED_STYLE == BUTTON_STYLE_NONE) {
      $button_style = 'rounded-0';
   }
   else if(SETTING_THEME_ROUNDED_STYLE == BUTTON_STYLE_ROUNDED) {
      $button_style = 'rounded-lg';
   }
   else if(SETTING_THEME_ROUNDED_STYLE == BUTTON_STYLE_ROUNDED_XL) {
      $button_style = 'rounded-xl';
   }
   else if(SETTING_THEME_ROUNDED_STYLE == BUTTON_STYLE_PILL) {
      $button_style = 'rounded-pill';
   }
   return $button_style;
}

function rounded_style()
{
   $button_style = '';
   if(SETTING_THEME_ROUNDED_STYLE == BUTTON_STYLE_ROUNDED) {
      $button_style = 'rounded-lg';
   }
   else if(SETTING_THEME_ROUNDED_STYLE == BUTTON_STYLE_ROUNDED_XL) {
      $button_style = 'rounded-xl';
   }
   return $button_style;
}

function rounded_bottom_style()
{
   $button_style = '';
   if(SETTING_THEME_ROUNDED_STYLE == BUTTON_STYLE_ROUNDED) {
      $button_style = 'rounded-bottom';
   }
   return $button_style;
}

function gen_order_code($max_order_no = 0)
{
   if($max_order_no > 0)
   {
      $code = $max_order_no + 1;
   }
   else {
      $year = date('Y');
      $year = substr($year, 2, 2);
      $month = date('m');
      $new_count = sprintf('%05d', 1);
      $code = $year.$month.$new_count;
   }
   return $code;
}

function vat_amount($amount)
{
   $result = ($amount * VAT) / 100;
   return round($result);
}

function inc_vat($amount)
{
   $result = ($amount * VAT) / 100;
   return $amount + round($result);
}

function exc_vat_amount($amount)
{
   $vat = exc_vat($amount);
   $result = $amount - $vat;
   return round($result);
}

function exc_vat($amount)
{
   $result = $amount / 1.07;
   return round($result);
}

function quotation_encode($id, $no)
{
   $datetime = datetime_now();
   return base64_encode("$id:$no:$datetime");
}

function quotation_decode($code)
{
   $decode = base64_decode($code, TRUE);
   if($decode) {
      list($id, $no, $datetime) = explode(':', $decode);
      return $id;
   }
   else {
      exit('Invalid format');
   }
}

function order_encode($id, $no)
{
   $datetime = datetime_now();
   return base64_encode("$id:$no:$datetime");
}

function order_decode($code)
{
   $decode = base64_decode($code, TRUE);
   if($decode) {
      list($id, $no, $datetime) = explode(':', $decode);
      return $id;
   }
   else {
      exit('Invalid format');
   }
}

function billing_encode($id, $no)
{
   $datetime = datetime_now();
   return base64_encode("$id:$no:$datetime");
}

function billing_decode($code)
{
   $decode = base64_decode($code, TRUE);
   if($decode) {
      list($id, $no, $datetime) = explode(':', $decode);
      return $id;
   }
   else {
      exit('Invalid format');
   }
}

function invoice_encode($id, $no)
{
   $datetime = datetime_now();
   return base64_encode("$id:$no:$datetime");
}

function invoice_decode($code)
{
   $decode = base64_decode($code, TRUE);
   if($decode) {
      list($id, $no, $datetime) = explode(':', $decode);
      return $id;
   }
   else {
      exit('Invalid format');
   }
}

function logo_path()
{
   //$type = pathinfo(SETTING_LOGO_URL, PATHINFO_EXTENSION);
   //$data = file_get_contents(SETTING_LOGO_URL);
   //$base64 = 'data:image/' . $type . ';base64,' . base64_encode($data);
   return SETTING_LOGO_URL;
}

function features_text($str)
{
   $str = output_text($str);
   $str = str_replace('ฟรี', '<span class="badge badge-danger font-italic font-weight-light">ฟรี</span>', $str);
   return $str;
}

function clear_main_cache() {
   //home page
   @unlink('application/cache/'.md5(base_url('home')));
   @unlink('application/cache/'.md5(base_url('contact')));
   @unlink('application/cache/'.md5(base_url()));

//   $CI =& get_instance();
//   $CI->load->model('bos/news_model');
//   $CI->load->model('bos/news_category_model');
//   $CI->load->model('bos/news_subcategory_model');
//
//   $news_id = $CI->input->post('news_id');
//   $ids = $CI->input->post('ids');
//   if(!empty($ids)) {
//      $news_id=  $ids[0];
//   }
//   if(!empty($news_id)) {
//      $news_row = $CI->news_model->read($news_id);
//      $news_category_row = $CI->news_category_model->read($news_row->news_category_id);
//      //news detail
//      @unlink('application/cache/'.md5(base_url('news/'.$news_category_row->rewrite_url.'/'.$news_row->news_id)));
//   }
//
//   $news_category = $CI->news_category_model->listing();
//   $news_subcategory = $CI->news_subcategory_model->listing();
//   if(!empty($news_category)) {
//      foreach($news_category as $rs) {
//         //news category
//         @unlink('application/cache/'.md5(base_url('news/category/'.$rs->rewrite_url)));
//         if(!empty($news_subcategory)) {
//            foreach($news_subcategory as $rw) {
//               //news subcategory
//               @unlink('application/cache/'.md5(base_url('news/category/'.$rs->rewrite_url.'/'.$rw->rewrite_url)));
//            }
//         }
//      }
//   }
}