<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Product_item extends Frontend_Rest
{
   public $base_model = 'front/product_item_model';
   public $menu_ctl = 'product_item';
   protected $primary_key = 'product_item_id';

   function __construct()
   {
      parent::__construct();
   }

   public function get_od() {
      $this->load->model('front/product_item_model');
      $product_id = $this->input->get('product_id');

      $data = [];
      if(!empty($product_id)) {
         $filter_item['product_id'] = $product_id;
         $listing = $this->product_item_model->listing_order($filter_item);
         if(!empty($listing)) {
            $arr = [];
            foreach ($listing as $rs) {
               if(!empty($rs->od)) {
                  $arr[] = $rs->od;
               }
            }
            foreach ($arr as $a) {
               if(!in_array($a, $data)) {
                  $data[] = $a;
               }
            }
         }
      }

      return $this->success($data);
   }

   public function get_length() {
      $this->load->model('front/product_item_model');
      $product_id = $this->input->get('product_id');
      $od = $this->input->get('od');

      $data = [];
      if(!empty($product_id) && !empty($od)) {
         $filter_item['product_id'] = $product_id;
         $listing = $this->product_item_model->listing_order($filter_item);
         if(!empty($listing)) {
            foreach ($listing as $rs) {
               if($od == $rs->od) {
                  $data[] = $rs->length;
               }
            }
         }
      }

      return $this->success(array_unique($data));
   }

   public function get_item() {
      $this->load->model('front/product_item_model');
      $product_id = $this->input->get('product_id');
      $od = $this->input->get('od');
      $length = $this->input->get('length');

      $data = [];
      if(!empty($product_id) && !empty($od)) {
         $filter_item['product_id'] = $product_id;
         $filter_item['od'] = $od;
         $filter_item['length'] = $length;
         $data = $this->product_item_model->listing_order($filter_item);
      }
      else if(!empty($product_id)) {
         $filter_item['product_id'] = $product_id;
         $data = $this->product_item_model->listing_order($filter_item);
      }

      return $this->success($data);
   }

   public function get_item_mobile() {
      $this->load->model('front/product_item_model');
      $product_id = $this->input->get('product_id');
      $code = $this->input->get('code');

      $data = [];
      if(!empty($product_id) && !empty($code)) {
         $filter_item['product_id'] = $product_id;
         $filter_item['code'] = $code;
         $data = $this->product_item_model->listing_order($filter_item);
      }

      return $this->success($data[0]);
   }
}