<?php defined('BASEPATH') OR exit('No direct script access allowed');

class User_role extends Restful_Controller
{
   public $base_model = 'bos/user_role_model';
   public $menu_ctl = 'user_role';

   private $permission_fields = ['action_listing', 'action_view', 'action_add', 'action_edit', 'action_delete', 'action_publish', 'action_highlight'];

   function __construct()
   {
      parent::__construct();
      $this->load->model('bos/user_permission_model');
      $this->load->model('bos/menu_group_model');
      $this->load->model('bos/menu_model');
   }

   public function listing()
   {
      if(!empty($this->input->get('filters')))
      {
         foreach($this->input->get('filters') as $key=>$val)
         {
            $this->filters_listing[$key] = input_to_sql($val);
         }
      }

      $this->filters_listing['login_user_role_id'] = $this->login_user_role_id;

      $listing = $this->model->listing($this->filters_listing);
      if(!empty($listing))
      {
         $menu_group = [];
         $menu_item = [];

         $menu_group_listing = $this->menu_group_model->listing();
         if(!empty($menu_group_listing))
         {
            foreach($menu_group_listing as $row)
            {
               $menu_group[$row->menu_group_id] = $row->title;
            }
         }

         $menu_listing = $this->menu_model->listing();
         if(!empty($menu_listing))
         {
            foreach($menu_listing as $row)
            {
               $menu_item[$row->menu_id] = $row->label;
            }
         }

         $role_group = [];
         $role_menu = [];
         $list_by_menu = $this->user_permission_model->list_by_menu();
         if(!empty($list_by_menu))
         {
            foreach($list_by_menu as $row)
            {
               $role_group[$row->role_id][] = $row->menu_group_id;
               $role_menu[$row->role_id][$row->menu_group_id][] = $row->menu_id;
            }
         }

         foreach($listing as $row)
         {
            $row->permissions = NULL;

            $menu_perms = $role_menu[$row->role_id];

            if(!empty($menu_perms))
            {
               $permission = [];
               foreach($menu_perms as $group_id=>$menu_ids)
               {
                  $data = new stdClass();
                  $data->group = $menu_group[$group_id];

                  $menus = [];
                  if(!empty($menu_ids))
                  {
                     foreach($menu_ids as $id)
                     {
                        $menus[] = $menu_item[$id];
                     }
                  }
                  $data->menu = $menus;
                  $permission[] = $data;
               }
               $row->permissions = $permission;
            }
         }
      }

      $res = new stdClass();
      $res->rows = $listing;
      $res->total_row = count($listing);
      $res->all_row = count($listing);

      return $this->success($res);
   }

   /**
    * Base : read row
    */
   public function read()
   {
      $id = $this->input->post('id');
      if(!empty($id) && is_numeric($id))
      {
         $row = $this->model->read($id);

         //read permission
         $row->permissions = $this->user_permission_model->list_by_role($id);

         //read menu group
         $row->menu_group = $this->menu_group_model->listing();

         //read menu
         $menu = $this->menu_model->list_for_role();
         $mList = [];
         foreach($menu as $m){
            $mList[$m->menu_group_id][] = $m;
         }
         $row->menu = $mList;

         return $this->success($row);
      }
      else{
         return $this->failedN('Not found id.');
      }
   }

   /**
    * Base : update row
    */
   public function update($is_return_data = FALSE)
   {
      $data = new stdClass();
      if(isset($_POST) && !empty($_POST))
      {
         foreach($_POST as $key => $val)
         {
            if($key !== 'perms')
            {
               $data->$key = input_to_sql($val);
            }
         }
      }

      if(!empty($data))
      {
         $data->created_by = $this->login_user_id;
         $result = $this->model->update($data);
         if($result)
         {
            $this->user_permission_model->set_permission($_POST, $this->permission_fields);
            $this->success($result);
         }
         else{
            $this->failedN('Cannot update row.');
         }
      }
      else{
         $this->failedN('Parameter not found.');
      }
   }
}