<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Profile extends Restful_Controller
{
   public $base_model = 'bos/user_model';
   public $menu_ctl = 'user';

   function __construct()
   {
      parent::__construct();

      $this->cover_config = UPLOAD_ADMIN_AVATAR;
   }

   public function read()
   {
      if(!empty($this->login_user_id))
      {
         $row = $this->model->read($this->login_user_id, $this->filters_read);
         $row->cover_url = ASSETS.'img/admin-avatar-'.$row->gender.'.jpg';
         if(!empty($row->cover_ext))
         {
            $row->cover_url = $this->_avatar_url($row);
         }

         return $this->success($row);
      }
      else{
         return $this->failedN('Not found id.');
      }
   }

   private function _avatar_url($row)
   {
      return base_url(UPLOAD_ADMIN_AVATAR[0][0].$row->user_id.'.'.$row->cover_ext);
   }

   /**
    * Base : update row
    */
   public function update()
   {
      if(!empty($this->login_user_id))
      {
         $data = new stdClass();
         if(isset($_POST) && !empty($_POST))
         {
            foreach($_POST as $key => $val)
            {
               $data->$key = input_to_sql($val);
            }
         }

         $data->user_id = $this->login_user_id;

         $password = $data->password;
         $confirm_password = $data->confirm_password;
         if($password && $confirm_password)
         {
            if($password != $confirm_password)
            {
               $this->failedN('Password not match.');
               exit();
            }
            else {
               $this->load->library('bcrypt');
               $data->password = $this->bcrypt->hash_password($data->password);
            }
         }
         else{
            unset($data->password);
            unset($data->confirm_password);
         }

         if(!empty($_FILES['cover']['name']))
         {
            $data->cover_ext = file_ext($_FILES['cover']['name']);
         }

         $delete_cover = NULL;
         if(!empty($data->delete_cover)){
            $delete_cover = $data->delete_cover;
            $data->cover_ext = NULL;
            unset($data->delete_cover);
         }

         if(!empty($data))
         {
            $data->created_by = $this->login_user_id;
            $result = $this->model->update_user($data);
            if($result)
            {
               $this->_upload_cover($result); // $result = $id
               $this->_delete_cover_byid($result, $delete_cover);
               return $this->success($result);
            }
            else{
               return $this->failedN('Cannot update row.');
            }
         }
         else{
            return $this->failedN('Parameter not found.');
         }
      }
   }
}