<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Product extends Frontend_View
{
   function __construct()
   {
      parent::__construct();
   }

   public function category($rewrite_url)
   {
      $data = [];
      $data['page_menu'] = 'product';

      $this->load->model('front/product_model');
      $this->load->model('front/product_category_model');
      $product_category_row = $this->product_category_model->read_url($rewrite_url);
      $data['product_category_row'] = $product_category_row;

      $filters['product_category_id'] = $product_category_row->product_category_id;
      $data['product_listing'] = $this->product_model->listing($filters);

      $this->view('product', $data);
   }

   public function detail($rewrite_url)
   {
      $data = [];
      $data['page_menu'] = 'product';

      $this->load->model('front/product_model');
      $this->load->model('front/product_category_model');
      $this->load->model('front/product_gallery_model');
      $this->load->model('front/product_item_model');

      $product_row = $this->product_model->read_url($rewrite_url);
      $data['product_row'] = $product_row;

      $product_category_row = $this->product_category_model->read($product_row->product_category_id);
      $data['product_category_row'] = $product_category_row;

      $filters['product_id'] = $product_row->product_id;
      $data['product_gallery_listing'] = $this->product_gallery_model->listing_order($filters);
      $this->meta_title = $product_row->title;
      $this->meta_keywords = $product_row->keyword;
      $this->meta_description = str_replace("\r\n",' ', iconv_substr($product_row->detail, 0, 200));
      $this->thumb_url = product_thumb_url($product_row);

      $filter_item['product_id'] = $product_row->product_id;
      $data['product_item_listing'] = $this->product_item_model->listing_order($filter_item);

      $this->view('product-detail', $data);
   }
}