// ## vehicleHome.js
// 	Contains the dynamic functionality, HTML, and default instructional copy associated with the "Design Your Nissan" model types on the right-hand side of the page.

// FUNCTION LIST:
// 	buildLayer();
// 	trimOn();
// 	trimOff();

// TEMPLATE(S) USED:
// 	vehicles_home.html

var trimTimeout

// Builds the information layer to the right of the menu.
function buildLayer(trim, text) {
	//var test = trimArray[trimArrayIndex].trim;
	var layerText = '';
	layerText = '<table border="0" cellpadding="0" cellspacing="0" height="58" width="203">';
	layerText += '<tr><td width="203" class="emphasis-text" height="9"><b>' + trim + '</b></td>';
	layerText += '<td width="5" nowrap></td></tr>';
	layerText += '<tr><td colspan="2" height="6" nowrap></td></tr>';
	layerText += '<tr><td width="203" class="emphasis-text" height="38">' + text + '</td>';
	layerText += '<td width="5" nowrap></td></tr>';
	layerText += '</table>&nbsp;';
	trimInfo.write(layerText);
	trimInfo.show();
}

// Resets the layer to the default instructional copy.
function resetLayer() {
	
	var layerText = '';
	layerText = '<table border="0" cellpadding="0" cellspacing="0" width="203">';
	layerText += '<tr><td width="203" class="emphasis-text">'
	layerText += 'Mouse over the model names on the left for brief descriptions. Click on the model names to design your very own.</td></tr>'
	layerText += '</table>&nbsp;'
	trimInfo.write(layerText);
	trimInfo.show();
}

// Activates the trim information layer.
function trimOn(trim, text) {
	if (trimTimeout) {clearTimeout(trimTimeout)}
	buildLayer(trim, text);
}

// Deactivates the trim information layer after a period of time.
function trimOff() {
	if (is.mac) trimTimeout = setTimeout("trimInfo.hide();resetLayer();",4000)
	else trimTimeout = setTimeout("trimInfo.hide();resetLayer();",400)

}


