// ## global.js
// 	Contains code that fixes the resize bug in Netscape, control core functionality for all dynamic layer elements, and sets the appropriate .css file depending on the user's browser. This file is used on all templates.

// FUNCTION LIST:
// 	resizeFix();
// 	popWindow();
// 	popGlossary();
//	BrowserCheck();
// 	DynLayer();
// 	DynLayerMoveTo();
// 	DynLayerMoveBy();
//	DynLayerInit();
// 	DynLayerClipInit();
// 	DynLayerClipTo();
// 	DynLayerClipBy();
//	DynLayerClipValues();
// 	DynLayerWrite();


// TEMPLATE(S) USED:
// 	brochure_request.html
// 	coming_veh.html
// 	contact.html
// 	corporate.html
// 	dealer_results.html
// 	gallery.html
// 	galleryPopup.html
// 	line_up.html
// 	main.html
// 	performance.html
// 	specs.html
// 	vehicles_home.html


//This script checks to see if visitor is using Netscape or MSIE browser. 
//If Netscape or MSIE, make sure it is version 4.x or higher
//If not 4.x or above, send to error page.

var browserVer=parseInt(navigator.appVersion); 
 
if(navigator.appName == "Netscape")
	{
	if (browserVer < 4)
	 	{
			document.location="errorpage.html"
		}
	}

if(navigator.appName == "Microsoft Internet Explorer")
	{
	if (browserVer < 4)
	 	{
			document.location="errorpage.html"
		}
	}

// BEGIN RESIZE CODE
// Copyright (C) 1999 Dan Steinman
// Distributed under the terms of the GNU Library General Public License
// Available at http://www.dansteinman.com/dynapi/

if (navigator.appName=="Netscape" && parseInt(navigator.appVersion)==4) {
	widthCheck = window.innerWidth
	heightCheck = window.innerHeight
	window.onResize = resizeFix
}
function resizeFix() {
	if (widthCheck != window.innerWidth || heightCheck != window.innerHeight)
	document.location.href = document.location.href
}


// Function that pops up a window of a specific size on all target browsers
//    Pass the window URL, the width and the height
function popWindow(urlVal,windowName,widthVal,heightVal,scrollBars,menuBar,reSizeable) {
	var paraString
	var wt
	var ht
	
	if ((is.ie) && (is.mac)) {
			wt = widthVal - 16;
			ht = heightVal - 16;
		} else if (is.ns){
			wt = widthVal;
			ht = heightVal + 2;
		} else {
			wt = widthVal;
			ht = heightVal;
		}
	paraString = "width=" + wt + ",height=" + ht;
	if (scrollBars == 1) {
		paraString = paraString + ",scrollbars=yes";
		} else {
		paraString = paraString + ",scrollbars=no";
		}
	if (menuBar == 1) {
		paraString = paraString + ",menubar=yes";
		}
		
	paraString = paraString + ",resizable=yes";
	paraString = paraString + ",screenX=0,top=0";
	poppedWindow = window.open(urlVal,windowName,paraString);
	poppedWindow.focus();
	}


// Function that passes the appropriate glossary URL, name and size to the popWindow function
function popGlossary(urlVal) {
	popWindow(urlVal,"glossaryWindow",230,310); 
}

// END RESIZE CODE

// BEGIN DYNAMIC LAYERING CODE
// Dynamic Layer Object
// sophisticated layer/element targeting and animation object which provides the core functionality needed in most DHTML applications
// 19990604

// Copyright (C) 1999 Dan Steinman
// Distributed under the terms of the GNU Library General Public License
// Available at http://www.dansteinman.com/dynapi/

// Added by D.Owen during warranty -- sets a variable to track when init is complete
var doneLoading = false;

// BrowserCheck Object
function BrowserCheck() {
	// note: this basic function was altered by d.owen to overcome ns4 bug on config page;
	// notes below were added along with changes on 52201.

	var b = navigator.appName
	if (b=="Netscape") this.b = "ns"
	else if (b=="Microsoft Internet Explorer") this.b = "ie"
	else this.b = b
	this.version = navigator.appVersion
	this.v = parseInt(this.version)
	this.ns = (this.b=="ns" && this.v>=4)
	this.ns4 = (this.b=="ns" && this.v==4)
	this.ns5 = (this.b=="ns" && this.v==5)
	this.ie = (this.b=="ie" && this.v>=4)
	this.ie4 = (this.version.indexOf('MSIE 4')>0)
	this.ie5 = (this.version.indexOf('MSIE 5')>0)
	this.min = (this.ns||this.ie)
	this.pc = (this.version.indexOf('Win')>0)
	this.mac = (this.version.indexOf('PPC')>0)

	// next line added by d.owen on 52201
	this.ns408=(parseFloat(this.version)==4.08);
}
var is = new BrowserCheck()

if (!is.min) location.href = '/global/error/browsercheck.html';

function DynLayer(id,nestref,frame) {
	if (!is.ns5 && !DynLayer.set && !frame) DynLayerInit()
	this.frame = frame || self
	if (is.ns) {
		if (is.ns4) {
			if (!frame) {
				if (!nestref) var nestref = DynLayer.nestRefArray[id]
				if (!DynLayerTest(id,nestref)) return
				this.css = (nestref)? eval("document."+nestref+".document."+id) : document.layers[id]
			}
			else this.css = (nestref)? eval("frame.document."+nestref+".document."+id) : frame.document.layers[id]
			this.elm = this.event = this.css
			this.doc = this.css.document
			this.w = this.css.clip.width
			this.h = this.css.clip.height
			this.x = this.css.left
			this.y = this.css.top
		}
		else if (is.ns5) {
			this.elm = document.getElementById(id)
			this.css = this.elm.style
			this.doc = document
			this.x = this.elm.offsetLeft
			this.y = this.elm.offsetTop
			this.w = this.elm.offsetWidth
			this.h = this.elm.offsetHeight
		}
	}
	else if (is.ie) {
		this.elm = this.event = this.frame.document.all[id]
		this.css = this.frame.document.all[id].style
		this.doc = document
		this.x = this.elm.offsetLeft
		this.y = this.elm.offsetTop
		this.w = this.elm.offsetWidth
		this.h = this.elm.offsetHeight
	}
	this.id = id
	this.nestref = nestref
	this.obj = id + "DynLayer"
	eval(this.obj + "=this")
}
function DynLayerMoveTo(x,y) {
	if (x!=null) {
		this.x = x
		this.css.left = x;
	}
	if (y!=null) {
		this.y = y
		this.css.top = y;
	}
}
function DynLayerMoveBy(x,y) {
	this.moveTo(this.x+x,this.y+y)
}
function DynLayerShow() {
	this.css.visibility = (is.ns4)? "show" : "visible"
}
function DynLayerHide() {
	this.css.visibility = (is.ns4)? "hide" : "hidden"
}
DynLayer.prototype.moveTo = DynLayerMoveTo
DynLayer.prototype.moveBy = DynLayerMoveBy
DynLayer.prototype.show = DynLayerShow
DynLayer.prototype.hide = DynLayerHide
DynLayerTest = new Function('return true')

// DynLayerInit Function
function DynLayerInit(nestref) {
	if (!DynLayer.set) DynLayer.set = true
	if (is.ns) {
		if (is.ns4) {
			if (nestref) ref = eval('document.'+nestref+'.document')
			else {nestref = ''; ref = document;}
			for (var i=0; i<ref.layers.length; i++) {
				var divname = ref.layers[i].name
				DynLayer.nestRefArray[divname] = nestref
				var index = divname.indexOf("Div")
				if (index > 0) {
					eval(divname.substr(0,index)+' = new DynLayer("'+divname+'","'+nestref+'")')
				}
				if (ref.layers[i].document.layers.length > 0) {
					DynLayer.refArray[DynLayer.refArray.length] = (nestref=='')? ref.layers[i].name : nestref+'.document.'+ref.layers[i].name
				}
			}
			if (DynLayer.refArray.i < DynLayer.refArray.length) {
				DynLayerInit(DynLayer.refArray[DynLayer.refArray.i++])
			}
		}
		else if (is.ns5) {
			for (var i=0; i<document.getElementsByTagName("DIV").length; i++) {
				var divname = document.getElementsByTagName("DIV")[i].id
				var index = divname.indexOf("Div")
				if (index > 0) {
					eval(divname.substr(0,index)+' = new DynLayer("'+divname+'")')
				}
			}
		}
	}
	else if (is.ie) {
		for (var i=0; i<document.all.tags("DIV").length; i++) {
			var divname = document.all.tags("DIV")[i].id
			var index = divname.indexOf("Div")
			if (index > 0) {
				eval(divname.substr(0,index)+' = new DynLayer("'+divname+'")')
			}
		}
	}
	doneLoading = true;
	return true
}
DynLayer.nestRefArray = new Array()
DynLayer.refArray = new Array()
DynLayer.refArray.i = 0
DynLayer.set = false

// Clip Methods
function DynLayerClipInit(clipTop,clipRight,clipBottom,clipLeft) {
	if (is.ie) {
		if (arguments.length==4) this.clipTo(clipTop,clipRight,clipBottom,clipLeft)
		else if (is.ie4) this.clipTo(0,this.css.pixelWidth,this.css.pixelHeight,0)
	}
}
function DynLayerClipTo(t,r,b,l) {
	if (t==null) t = this.clipValues('t')
	if (r==null) r = this.clipValues('r')
	if (b==null) b = this.clipValues('b')
	if (l==null) l = this.clipValues('l')
	if (is.ns) {
		this.css.clip.top = t
		this.css.clip.right = r
		this.css.clip.bottom = b
		this.css.clip.left = l
	}
	else if (is.ie) this.css.clip = "rect("+t+"px "+r+"px "+b+"px "+l+"px)"
}
function DynLayerClipBy(t,r,b,l) {
	this.clipTo(this.clipValues('t')+t,this.clipValues('r')+r,this.clipValues('b')+b,this.clipValues('l')+l)
}
function DynLayerClipValues(which) {
	if (is.ie) var clipv = this.css.clip.split("rect(")[1].split(")")[0].split("px")
	if (which=="t") return (is.ns)? this.css.clip.top : Number(clipv[0])
	if (which=="r") return (is.ns)? this.css.clip.right : Number(clipv[1])
	if (which=="b") return (is.ns)? this.css.clip.bottom : Number(clipv[2])
	if (which=="l") return (is.ns)? this.css.clip.left : Number(clipv[3])
}
DynLayer.prototype.clipInit = DynLayerClipInit
DynLayer.prototype.clipTo = DynLayerClipTo
DynLayer.prototype.clipBy = DynLayerClipBy
DynLayer.prototype.clipValues = DynLayerClipValues

// Write Method
function DynLayerWrite(html) {
	if (is.ns) {
		if (is.ns4) {
			this.doc.open()
			this.doc.write(html)
			this.doc.close()
		} else if (is.ns5) {
			this.elm.innerHTML = html;
		}
	}
	else if (is.ie) {
		this.event.innerHTML = html
	}
}
DynLayer.prototype.write = DynLayerWrite


// END DYNAMIC LAYER CODE

// BEGIN CSS STYLE DEFINITION CODE
//## Writes the appropriate CSS link depending on the user's browser.

//styleString = '<link rel="stylesheet" href="css/master' + ((is.ie || is.ns5) ? 'IE': 'NN') + '.css" type="text/css">'

var startString = '<link rel="stylesheet" href="http://www.nissan-th.com/css/master';
var endString = '.css" type="text/css">';

if ((is.ie || is.ns5)) styleString = startString + 'IE';
	else styleString = startString + 'NN';
if (is.mac && is.ns) styleString = styleString + 'mac';

styleString = styleString + endString;

document.write(styleString)

// END CSS STYLE DEFINITION CODE