function select_product(product_category_id) {
    let PATH = 'restful/front/product/get_product';
    let req = request_get(PATH, {product_category_id: product_category_id});
    req.done(function (response, statusText, xhr)
    {
        if(response && !response.success)
        {
            toast_error(response.message);
        }
        else{
            let html = '<option value="">ชื่อสินค้า</option>';
            if(response.data) {
                for(let rs of response.data) {
                    html += '<option value="' + rs.product_id + '"';

                    if($('#current_product_id').val() && $('#current_product_id').val() === rs.product_id) {
                        html += ' selected';
                    }

                    html += '>' + rs.title + '</option>';
                }
            }
            $('#select_product_id').html(html);
        }
    });
}

function select_product_od(product_id) {
    let PATH = 'restful/front/product_item/get_od';
    let req = request_get(PATH, {product_id: product_id});
    req.done(function (response, statusText, xhr)
    {
        if(response && !response.success)
        {
            toast_error(response.message);
        }
        else{
            let html = '<option value="">OD เกลียว</option>';
            if(response.data) {
                for(let rs of response.data) {
                    html += '<option value="' + rs + '"';

                    if($('#current_product_od').val() && $('#current_product_od').val() === rs) {
                        html += ' selected';
                    }

                    html += '>' + rs + '</option>';
                }
            }
            $('#select_product_od').html(html);
        }
    });
}

function select_product_len(product_id, product_od) {

    let PATH = 'restful/front/product_item/get_length';
    let req = request_get(PATH, {product_id: product_id, od: product_od});
    req.done(function (response, statusText, xhr)
    {
        if(response && !response.success)
        {
            toast_error(response.message);
        }
        else{
            let html = '<option value="">ความยาว (mm.)</option>';
            if(response.data) {
                for(let rs of response.data) {
                    html += '<option value="' + rs + '"';

                    if($('#current_product_len').val() && $('#current_product_len').val() === rs) {
                        html += ' selected';
                    }

                    html += '>' + rs + '</option>';
                }
            }
            $('#select_product_len').html(html);
        }
    });
}

$(function () {

    //search
    if($('#select_product_category_id').val()) {
        $('#select_product_id').prop('disabled', false);
        select_product($('#select_product_category_id').val());
    }

    if($('#current_product_id').val()) {
        $('#select_product_id').prop('disabled', false);
        $('#select_product_od').prop('disabled', false);
        select_product_od($('#current_product_id').val());
    }

    if($('#current_product_od').val()) {
        $('#select_product_id').prop('disabled', false);
        $('#select_product_od').prop('disabled', false);
        $('#select_product_len').prop('disabled', false);
        select_product_len($('#current_product_id').val(), $('#current_product_od').val());
    }


    $('#select_product_category_id').on('change', function () {
        $('#select_product_id').html('');

        $('#select_product_id').prop('disabled', true);
        $('#select_product_od').prop('disabled', true);
        $('#select_product_len').prop('disabled', true);
        if($(this).val()) {
            $('#select_product_id').prop('disabled', false);
        }

        $('#select_product_od').html('<option value="">OD เกลียว</option>');
        $('#select_product_len').html('<option value="">ความยาว (mm.)</option>');
        select_product($(this).val());
    });

    $('#select_product_id').on('change', function () {
        $('#select_product_od').html('');

        $('#select_product_od').prop('disabled', true);
        $('#select_product_len').prop('disabled', true);
        if($(this).val()) {
            $('#select_product_od').prop('disabled', false);
        }
        $('#select_product_len').html('<option value="">ความยาว (mm.)</option>');
        select_product_od($(this).val());
    });

    $('#select_product_od').on('change', function () {
        $('#select_product_len').prop('disabled', true);
        if($(this).val()) {
            $('#select_product_len').prop('disabled', false);
        }
        select_product_len($('#select_product_id').val(), $(this).val());
    });

    //cart
    $('#add-to-cart').on('click', function () {
        if($('#item-id').val() === '') {
            toast_warning('กรุณาเลือกรุ่นสินค้า');
            $('#item-id').focus();
        } else if($('#cart-item').val() === '' || isNaN($('#cart-item').val())) {
            toast_warning('กรุณาใส่จำนวนสินค้า (เป็นตัวเลข)');
            $('#cart-item').focus();
        } else {
            let PATH = 'restful/front/product/add_to_cart';
            let req = request_post(PATH, {product_item_id: $('#item-id').val(), product_id: $('#product-id').val(), qty: $('#cart-item').val()});
            req.done(function (response, statusText, xhr)
            {
                if(response && !response.success)
                {
                    toast_error(response.message);
                }
                else{
                    $('#show-cart-item').text(response.message);

                    $('#addProductModal').modal('show');
                }
            });
        }
    });
    $('.item-select').on('click', function () {
        let item_id = $(this).data('id');
        let product_id = $(this).data('product-id');
        $('#item-id').val(item_id);
        $('#product-id').val(product_id);
    });
    $('.card-delete').on('click', function () {
        let item_code = $(this).data('code');
        let item_id = $(this).data('id');
        $('#deleteModal').modal('show');
        $('#show-item-code').text(item_code);
        $('#show-item-id').val(item_id);
    });
    $('#btn-confirm-delete-cart').on('click', function () {
        let id = $('#show-item-id').val();
        let PATH = 'restful/front/product/remove_cart';
        let req = request_post(PATH, {product_item_id: id});
        req.done(function (response, statusText, xhr)
        {
            if(response && !response.success)
            {
                toast_error(response.message);
            }
            else{
                $('#deleteModal').modal('hide');
                $('.cart-' + id).remove();
            }
        });
    });

    //order
    $('#btn-order').on('click', function () {
        if($('#fullname').val() === '') {
            toast_warning('กรุณาระบุ ชื่อ-นามสกุล');
            $('#fullname').focus();
        } else if($('#phone').val() === '' || isNaN($('#phone').val()) || $('#phone').val().length < 9) {
            toast_warning('กรุณาระบุ เบอร์โทร (ตัวเลข 9 หลักขึ้นไป)');
            $('#phone').focus();
        } else if($('#email').val() === '' || !validateEmail.test($('#email').val())) {
            toast_warning('กรุณาระบุ อีเมลให้ถูกต้อง');
            $('#email').focus();
        } else if($('#company').val() === '' || $('#company').val() === '-' || $('#company').val().length < 5) {
            toast_warning('กรุณาระบุ บริษัท (จำนวน 5 ตัวอักษรขึ้นไป และห้ามใส่ -)');
            $('#company').focus();
        } else if($('#address').val() === '' || $('#address').val() === '-' || $('#address').val().length < 5) {
            toast_warning('กรุณาระบุ ที่อยู่บริษัท (จำนวน 5 ตัวอักษรขึ้นไป และห้ามใส่ -');
            $('#address').focus();
        } else if($('input[name=buyfor]:checked').length <= 0) {
            toast_warning('กรุณาเลือกเหตุผลการสั่งสินค้า')
        } else {
            $('#btn-order').prop('disabled', true);
            $('#btn-order').find('.spinner-border').removeClass('d-none');
            let PATH = 'restful/front/product/confirm';
            let req = request_post(PATH, $('#form-order, #form-cart').serialize());
            req.done(function (response, statusText, xhr)
            {
                $('#btn-order').prop('disabled', false);
                $('#btn-order').find('.spinner-border').addClass('d-none');
                if(response && !response.success)
                {
                    toast_error(response.message);
                }
                else{
                    window.location = 'https://dev.fastenic.com/request-quotation/thankyou';
                }
            });
        }
    });

    //btn-contact
    $('#btn-contact').on('click', function () {
        if($('#fullname').val() === '') {
            toast_warning('กรุณาระบุ ชื่อ-นามสกุล');
            $('#fullname').focus();
        } else if($('#phone').val() === '' || isNaN($('#phone').val()) || $('#phone').val().length < 9) {
            toast_warning('กรุณาระบุ เบอร์โทร (ตัวเลข 9 หลักขึ้นไป)');
            $('#phone').focus();
        } else if($('#email').val() === '' || !validateEmail.test($('#email').val())) {
            toast_warning('กรุณาระบุ อีเมลให้ถูกต้อง');
            $('#email').focus();
        } else {
            $('#btn-contact').prop('disabled', true);
            $('#btn-contact').find('.spinner-border').removeClass('d-none');
            let PATH = 'restful/front/contact/confirm';
            let req = request_post(PATH, $('#form-contact').serialize());
            req.done(function (response, statusText, xhr)
            {
                $('#btn-contact').prop('disabled', false);
                $('#btn-contact').find('.spinner-border').addClass('d-none');
                if(response && !response.success)
                {
                    toast_error(response.message);
                }
                else{
                    window.location = SITE_URL + 'contact/thankyou';
                }
            });
        }
    });


    $('.btn-view-catalog').on('click', function () {
        let id = $(this).data('id');
        $('#product_catalog_id').val(id);
        $('#productCatalogModal').modal('show');
        $('#form-catalog').removeClass('d-none');
        $('#show-result').addClass('d-none');
        $('#fullname, #phone, #email, #company').val('');
    });
    $('#btn-close-catalog').on('click', function () {
        $('#productCatalogModal').modal('hide');
    });
    $('#btn-send-catalog').on('click', function () {
        if($('#fullname').val() === '') {
            toast_warning('กรุณาระบุ ชื่อ-นามสกุล');
            $('#fullname').focus();
        } else if($('#phone').val() === '' || isNaN($('#phone').val()) || $('#phone').val().length < 9) {
            toast_warning('กรุณาระบุ เบอร์โทร (ตัวเลข 9 หลักขึ้นไป)');
            $('#phone').focus();
        } else if($('#email').val() === '' || !validateEmail.test($('#email').val())) {
            toast_warning('กรุณาระบุ อีเมลให้ถูกต้อง');
            $('#email').focus();
        } else if($('#company').val() === '' || $('#company').val() === '-' || $('#company').val().length < 5) {
            toast_warning('กรุณาระบุ บริษัท (จำนวน 5 ตัวอักษรขึ้นไป และห้ามใส่ -)');
            $('#company').focus();
        } else {
            $('#btn-send-catalog').prop('disabled', true);
            $('#btn-send-catalog').find('.spinner-border').removeClass('d-none');
            let PATH = 'restful/front/product/catalog_download';
            let req = request_post(PATH, $('#form-catalog').serialize());
            req.done(function (response, statusText, xhr)
            {
                $('#btn-send-catalog').prop('disabled', false);
                $('#btn-send-catalog').find('.spinner-border').addClass('d-none');

                $('#form-catalog').addClass('d-none');
                $('#show-result').removeClass('d-none');

                if(response && !response.success)
                {
                    $('#btn-send-catalog h5').text(response.message);
                }
            });
        }
    });

});
