// --------------- Request http --------------- //
function request_http(method, url, data, forceData = false, mergeData = false)
{
    let passData = null;
    let processData = true;
    let defaultContentType = 'application/x-www-form-urlencoded; charset=UTF-8';
    let contentType = false;

    let fileUpload = $('#form-data').find('input[type=file]');

    if(method === 'POST' && fileUpload.length > 0 && (fileUpload.eq(0).val() || fileUpload.eq(1).val())){
        processData = false;
        passData = new FormData($('#form-data')[0]);
    }
    else if(typeof data !== 'undefined')
    {
        passData = data;
        contentType = defaultContentType;
    }

    if(forceData)
    {
        processData = true;
        contentType = defaultContentType;
        passData = data;
    }

    if(mergeData)
    {
        passData = data + new FormData($('#form-data')[0]);
    }

    let req = $.ajax({
        url: url,
        method: method,
        data: passData,
        headers: {'Authorization': 'Bearer ' + localStorage.getItem('CUR_TOKEN')},
        contentType: contentType,
        cache: false,
        processData: processData
    });

    req.fail(function(xhr, statusText){
        //console.log('Failed.. ' + xhr.status);
        //console.log(xhr);
        //console.log('statusCode:'+xhr.status);
        //console.log('statusText:'+statusText);

        let code = xhr.status;
        let msg = '';
        switch(xhr.status){
            case 404:
                msg = 'ไม่พบหน้านี้ (404)';
                //console.log(msg);
                break;
            case 401:
                msg = 'ไม่ได้รับสิทธิ์ (401)';
                break;
            case 500:
                msg = 'Internal Server Error (500)';
                break;
            default:
        }

        //console.log(code + ' : ' + msg);
        $.toast({text: code + ' : ' + msg, icon: 'error', position: 'top-right', loader: false, hideAfter: 3000});

    });

    req.done(function(data, statusText, xhr){
        //console.log('Done.. ' + xhr.status);
        //console.log(data);
        //console.log('statusText:'+statusText);
        //console.log('statusCode:'+xhr.status);
    });

    return req;
}

function request_post(url, data, forceData = false)
{
    return request_http('POST', SITE_URL + url, data, forceData);
}

function request_get(url, data, forceData = false)
{
    return request_http('GET', SITE_URL + url, data, forceData);
}

function request_view(url, data, forceData = false)
{
    return request_http('POST',  SITE_URL + url, data, forceData);
}
// --------------- Request http --------------- //

// --------------- Status Message --------------- //
function status_success(msg, force_ele = null, fadeOut)
{
    let ele = $('.msg-status');
    if(force_ele){
        ele = force_ele;
    }
    ele.removeClass('alert alert-danger alert-warning').addClass('alert alert-success').hide().html('<i class="la la-check-circle lf64 wow fadeInUp" data-wow-delay="0.3s"></i> ' + '<span class="wow fadeIn d-block">' + msg + '</span>').fadeIn(1500);
    if(fadeOut > 0)
    {
        setTimeout(function () {
            force_ele.fadeOut(1500);
        }, fadeOut);
    }
}
function status_warning(msg, fadeOut)
{
    $('.msg-status').removeClass('alert alert-danger alert-warning').addClass('alert alert-warning').hide().html('<i class="la la-info-circle lf64 wow fadeInUp" data-wow-delay="0.3s"></i> ' + '<span class="wow fadeIn d-block">' + msg + '</span>').fadeIn(1500);
    if(fadeOut > 0)
    {
        setTimeout(function () {
            $('.msg-status').fadeOut(1500);
        }, fadeOut);
    }
}
function status_error(msg, force_ele, fadeOut)
{
    let ele = $('.msg-status');
    if(force_ele){
        ele = force_ele;
    }
    console.log(ele);
    ele.removeClass('alert alert-success alert-warning').addClass('alert alert-danger').hide().html('<i class="la la-times-circle lf64 wow fadeInUp" data-wow-delay="0.3s"></i> ' + '<span class="wow fadeIn d-block">' + msg + '</span>').fadeIn(1500);
    if(fadeOut > 0)
    {
        setTimeout(function () {
            $('.msg-status').fadeOut(1500);
        }, fadeOut);
    }
}

// --------------- Status Message --------------- //

// --------------- Toast Message --------------- //
function toast_success(msg)
{
    $.toast({text: msg, icon: 'success', position: 'bottom-center', loader: false, hideAfter: 1000});
}

function toast_warning(msg)
{
    $.toast({text: msg, icon: 'warning', position: 'bottom-center', loader: false, hideAfter: 2000});
}

function toast_error(msg)
{
    $.toast({text: msg, icon: 'error', position: 'bottom-center', loader: false, hideAfter: 3000});
}
// --------------- Toast Message --------------- //

// --------------- Form Validator --------------- //
var numberCheck = /^[0-9]*$/;
var englishCheck = /^[A-Za-z0-9_]*$/;
var validateEmail = /^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-zA-Z0-9-]+(?:\.[a-zA-Z0-9-]+)*$/;
var strengthPassword1 = /^(?=.*[a-z])(?=.*[A-Z])[0-9a-zA-Z]{6,}$/;
var strengthPassword2 = /^(?=.*[0-9])(?=.*[a-z])(?=.*[A-Z])([a-zA-Z0-9]{6,})$/;

//spinner
var SPINNER_HTML = '<span class="spinner-border spinner-border-sm"></span> ';
function show_spinner(ele, is_disabled) {
    ele.prepend(SPINNER_HTML);
    if(is_disabled)
    {
        ele.prop('disabled', true);
    }
}

function hide_spinner(ele, is_enabled) {
    $('.spinner-border').remove();
    if(is_enabled)
    {
        ele.prop('disabled', false);
    }
}

function get_label(ele)
{
    let closest = ele.closest('.form-group');
    let text = closest.find('label').eq(0).text();
    if(empty(text))
    {
        text = ele.data('msg');
    }
    return text;
}

function get_placeholder(ele)
{
    return ele.attr('placeholder');
}

function empty(value)
{
    if(typeof value === 'undefined')
    {
        return true;
    }
    else if (Number.isNaN(value))
    {
        return true;
    }
    else if(value === null || value === false || value === 0 || value === '0' || value === '')
    {
        return true;
    }
    else if(typeof value === 'object' && value instanceof Array )
    {
        return value.length < 1;
    }
    else{
        return false;
    }
}

function nValue(value)
{
    return !empty(value) ? value:'';
}

function nEmpty(value)
{
    return !empty(value);
}

function isDefined(value)
{
    return typeof value !== 'undefined';
}

function isUndefined(value)
{
    return typeof value === 'undefined';
}
// --------------- Form Validator --------------- //

// --------------- Refresh Captcha --------------- //
function refresh_captcha()
{
    let url = $('.display-captcha, #display-captcha').attr('src');
    $('.display-captcha, #display-captcha').attr('src', url);
}
$(document).ready(function () {
    $(document).on('click', '.refresh-captcha, #refresh-captcha', function () {
        refresh_captcha();
    });
});
// --------------- Refresh Captcha --------------- //

// --------------- Check File Size --------------- //


// Check file input size
function check_image_size(size)
{
    let max_size = 4000000; // Byte
    if(Math.round(size) > max_size){
        alert('Maximum file size 4 MB');
        return false;
    }
    return true;
}
function check_file_size(size)
{
    let max_size = 8000000; // Byte
    if(Math.round(size) > max_size){
        alert('Maximum file size 8 MB');
        return false;
    }
    return true;
}
function file_extension(filename) {
    return filename.split('.').pop();
}
// --------------- Check File Size --------------- //