/**
 * @license Copyright (c) 2003-2017, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or http://ckeditor.com/license
 */


CKEDITOR.stylesSet.add( 'text_style', [

    { name: 'Paragraph',		element: 'p' },
    { name: 'Heading 1',		element: 'h1' },
    { name: 'Heading 2',		element: 'h2' },
    { name: 'Heading 3',		element: 'h3' },
    { name: 'Heading 4',		element: 'h4' },
    { name: 'Heading 5',		element: 'h5' },
    { name: 'Heading 6',		element: 'h6' },
    { name: 'Code',element: 'pre' },
    {
        name: 'Highlight',
        element: 'span',
        attributes: { 'class': 'text-hl' }
    },

    { name: 'Italic Title',		element: 'h2', styles: { 'font-style': 'italic' } },
    { name: 'Subtitle',			element: 'h3', styles: { 'color': '#aaa', 'font-style': 'italic' } },
    {
        name: 'Special Container',
        element: 'div',
        styles: {
            padding: '5px 10px',
            background: '#eee',
            border: '1px solid #ccc'
        }
    }

]);

CKEDITOR.editorConfig = function( config ) {
	// Define changes to default configuration here. For example:
	// config.language = 'fr';
	// config.uiColor = '#AADC6E';
    config.language = 'en';
    config.height = '200px';
    config.extraPlugins = 'youtube';
    config.extraPlugins = 'simplebutton';
    config.youtube_responsive = true;
    config.allowedContent = true;
    CKEDITOR.dtd.$removeEmpty.span = false;
    CKEDITOR.dtd.$removeEmpty.i = false;
    config.pasteFromWordPromptCleanup = true;
    config.pasteFromWordRemoveFontStyles = true;
    config.pasteFromWordRemoveStyles = true;
    config.format_tags = 'p;h1;h2;h3;h4;h5;h6';

    config.toolbarGroups = [
        //{ name: 'clipboard', groups: [ 'clipboard', 'undo' ] },
        { name: 'editing', groups: [ 'templates', 'find', 'selection', /*'spellchecker', 'editing'*/ ] },
        { name: 'insert', groups: [ 'insert','list', 'indent', /*'blocks'*/ ] },
        //{ name: 'tools', groups: [ 'tools' ] },
        { name: 'links', groups: [ 'links' ] },
        { name: 'document', groups: [ 'mode', 'document', 'doctools' ] },
        { name: 'others', groups: [ 'others' ] },
        { name: 'paragraph', groups: [  'align', 'paragraph' ] },
        { name: 'basicstyles', groups: [ 'basicstyles', 'cleanup' ] },
        { name: 'styles', groups: [ 'styles' ] },
        //{ name: 'colors', groups: [ 'colors' ] }
    ];

    config.removeButtons = 'SelectAll,Table,SpecialChar,Iframe,Flash,Form,Radio,TextField,Textarea,Select,Button,ImageButton,HiddenField,ShowBlocks,Save,NewPage,Preview,Print,Templates,Cut,Copy,Find,Replace,Smiley,PageBreak,About,Subscript,Superscript,CopyFormatting,Maximize,Font,Styles,Undo,Redo,Spell Checker';

};

CKEDITOR.on( 'instanceReady', function( evt ) {
    evt.editor.dataProcessor.htmlFilter.addRules( {
        elements: {
            img: function(el) {
                el.addClass('img-fluid');
                el.addClass('lazy');
                delete el.attributes.style;
            }
        }
    });
});
