// Toast success
function success(msg)
{
    $.toast({text: msg, icon: 'success', position: 'bottom-center', loader: false, hideAfter: 1500});
}

// Toast warning
function warning(msg)
{
    $.toast({text: msg, icon: 'warning', position: 'bottom-center', loader: false, hideAfter: 2000});
}

// Toast danger
function error(msg, hideAfter = 3000)
{
    $.toast({text: msg, icon: 'error', position: 'bottom-center', loader: false, hideAfter: hideAfter});
}


// Check file input size
function check_image_size(size)
{
    let max_size = 4000000; // Byte
    if(Math.round(size) > max_size){
        alert('Maximum file size 4 MB');
        return false;
    }
    return true;
}

function check_pdf_size(size)
{
    let max_size = 32000000; // Byte
    if(Math.round(size) > max_size){
        alert('Maximum file size 32 MB');
        return false;
    }
    return true;
}

function file_extension(filename) {
    return filename.split('.').pop();
}

function addslashes(str) {
    if(str) {
        str = str.replace(/\\/g, '\\\\');
        str = str.replace(/\'/g, '\\\'');
        str = str.replace(/\"/g, '\\"');
        str = str.replace(/\0/g, '\\0');
        return str;
    }
    return '';
}

function stripslashes(str) {
    if(str) {
        str = str.replace(/\\'/g, '\'');
        str = str.replace(/\\"/g, '"');
        str = str.replace(/\\0/g, '\0');
        str = str.replace(/\\\\/g, '\\');
        return str;
    }
    return '';
}

function output_text(str, show_dash)
{
    if(str && str !== 'null') {
        str = stripslashes(str);
        return str;
    }
    return show_dash ? '-':'';
}

function discount_type(value, id)
{
    let text = '';
    switch (parseInt(id)) {
        case 1:
            text = value + ' %';
            break;
        case 2:
            text = value + ' บาท';
    }
    return text;
}

function numberWithCommas(x) {
    if(x) {
        return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    }
    else {
        return '';
    }
}

function rewrite_url(text)
{
    //text = text.trim();
    text = text.toLowerCase();
    text = text.replace(/ /g,'-');
    text = text.replace(/[^a-zA-Z0-9ก-๙-]+/g,'-');
    if(text.substr(text.length - 1) === '-') {
        //text = text.slice(0, -1);
    }
    $('#rewrite_url').val(text);
}

function show_star(star)
{
    switch(parseInt(star)) {
        case 1: return '<i class="la la-star text-warning"></i>';
        case 2: return '<i class="la la-star text-warning"></i> <i class="la la-star text-warning"></i>';
        case 3: return '<i class="la la-star text-warning"></i> <i class="la la-star text-warning"></i> <i class="la la-star text-warning"></i>';
        case 4: return '<i class="la la-star text-warning"></i> <i class="la la-star text-warning"></i> <i class="la la-star text-warning"></i> <i class="la la-star text-warning"></i>';
        case 5: return '<i class="la la-star text-warning"></i> <i class="la la-star text-warning"></i> <i class="la la-star text-warning"></i> <i class="la la-star text-warning"></i> <i class="la la-star text-warning"></i>';
    }
    return '';
}

// Utils action
$(function () {

    //Logout
    $('#btn-logout').on('click', function(){
        $.ajax({
            type: 'POST',
            url: OFFICE_API_URL + 'bos/login/logout',
            dataType: 'json',
            contentType: 'application/json; charset=utf-8',
            headers: { 'Authorization': 'Bearer ' + get_token()},
            success: function(response){
                //console.log('OK');
                window.location.href = BASE_URL + 'bos/login';
            }
        });
    });

    // Friendly URL
    $(document).on('keyup', '.friendly-url', function()
    {
        let val = $(this).val();
        let str = val.replace(/[^a-z0-9ก-๙]+/g, '-');
        //let str = val.replace(/[_\W]+/g, "-");
        $(this).val(str);
    });

    // Show password as text
    $(document).on('click', '.show-text', function()
    {
        if($('#password, #member_password').attr('type') === 'text')
        {
            $(this).addClass('fa-eye').removeClass('fa-eye-slash');
            $('#password, #member_password').attr('type', 'password');
        }
        else{
            $(this).removeClass('fa-eye').addClass('fa-eye-slash');
            $('#password, #member_password').attr('type', 'text');
        }
    });

    $(document).on('click', '.toolbar-filter', function()
    {
        $(this).removeClass('show').addClass('hide');
        $('.toolbar-filter-search, .toolbar-filter-reset, .row-filter').removeClass('hide').addClass('show');
    });
    $(document).on('click', '.toolbar-filter-reset', function()
    {
        //$(this).removeClass('show').addClass('hide');
        //$('.toolbar-filter-search, .row-filter').removeClass('show').addClass('hide');
        //$('.toolbar-filter').removeClass('hide').addClass('show');
    });

    if($('.input-idcard').length > 0)
    {
        $('.input-idcard').mask('0000000000000');
    }
    if($('.input-zipcode').length > 0)
    {
        $('.input-zipcode').mask('00000');
    }
    if($('.input-phone').length > 0)
    {
        $('.input-phone').mask('0000000000');
    }
    if($('.input-id').length > 0)
    {
        $('.input-id').mask('0000000');
    }

});

// convert rows to csv file
function convert_to_csv(json)
{
    let array = typeof json != 'object' ? JSON.parse(json) : json;
    let str = '';

    for(let i = 0; i < array.length; i++)
    {
        let line = '';
        for(let index in array[i])
        {
            if (line !== '') line += ','
            line += '"'+array[i][index]+'"';
        }
        str += line + "\r\n";
    }

    return str;
}

// download csv
function download_csv(data, file_name) {
    let csvContent = 'data:text/csv;charset=utf-8,' + data;
    let encodedUri = encodeURI(csvContent);
    let link = document.createElement("a");
    link.setAttribute("href", encodedUri);
    link.setAttribute("download", file_name + ".csv");
    document.body.appendChild(link);
    link.click();
}