let textEnable = '<span class="badge badge-success '+(parseInt(is_publish) === 1 ? 'cur-p toolbar-row-disable':'')+'" title="คลิกเพื่อระงับ">ใช้งาน</span>';
let textDisable = '<span class="badge badge-danger font-italic '+(parseInt(is_publish) === 1 ? ' cur-p toolbar-row-enable':'')+'" title="คลิกเพื่อใช้งาน">ระงับ</span>';
let textSuccess = '<span class="badge badge-success">สำเร็จ</span>';
let textError = '<span class="badge badge-danger font-italic">ไม่สำเร็จ</span>';
let textMakeHighlight = '<span class="text-warning cur-p '+(parseInt(is_highlight) === 1 ? 'toolbar-row-unhighlight':'')+'"><i class="las la-star"></i></span>';
let textUnHighlight = '<span class="cur-p '+(parseInt(is_highlight) === 1 ? 'toolbar-row-highlight':'')+'"><i class="lar la-star"></i></span>';
let rowsTmp = null;
let max_visible = 10;

// ------------------------------------------------------- //
// STEP
// 1. request_listing -> request_get
// 2. load_rows
// 3. display_rows
// ------------------------------------------------------ //
function request_listing_order(filters, loading = true, all_row = false)
{
    if(!LISTING_PATH)
    {
        LISTING_PATH = 'bos/' + $('.main').attr('component') + '/listing_order';
    }
    request_listing(filters, loading, all_row);
}
function request_listing(filters, loading = true, all_row = false)
{
    let tdCount = $('.row-filter').find('td').length;
    if(!tdCount)
    {
        tdCount = $('.table').find('tr').eq(1).find('td').length;
    }
    if(loading)
    {
        $('#load_rows').html('<td class="text-center text-muted font-italic p-4" colspan="'+tdCount+'"><div class="spinner-border spinner-border-sm text-success" role="status"></div> <span class="text-muted small font-italic">กำลังโหลดข้อมูล..</span></td>');
    }

    let data = {};

    if(filters)
    {
        data.filters = filters;
    }

    if(!LISTING_PATH)
    {
        LISTING_PATH = 'bos/' + $('.main').attr('component') + '/listing';
    }

    let req = request_get(LISTING_PATH, data);
    req.done(function (response, statusText, xhr)
    {
        if(response && !response.success)
        {
            error(response.message);
        }
        else{
            //console.log('Read เรียบร้อย..');
            //success('Read เรียบร้อย..');
            let max_row = response.data.total_row;
            if(!all_row)
            {
                max_row = $('.max-row').val() ? $('.max-row').val():10;
            }
            let page_no = 1;
            if($('.bootpag').find('.active').find('a').text())
            {
                page_no = $('.bootpag').find('.active').find('a').text();
            }
            load_rows(response, page_no, max_row);
            //$('.max-row').val(data.max_row);
        }
    });

    return req;
}

function load_rows(response, page_no, max_row)
{
    let cur_page = 0;
    let total_row = response.data.total_row;
    let all_row = response.data.all_row;

    //first load
    rowsTmp = response.data.rows;

    $('.max-row-chooser').hide();
    if(total_row > 0)
    {
        max_row_select_box(response);

        let max_visible = 10;
        let cur_page = page_no > 0 ? page_no:1;

        let total_page = total_row > max_row ? Math.ceil(total_row/max_row):1;
        let all_page = Math.ceil(all_row/max_visible);

        if(all_page <= 1)
        {
            $('.max-row-chooser').hide();
        }
        else{
            $('.max-row-chooser').show();
        }
        let first_start = 0;
        let first_limit = max_row;

        if(cur_page > 0)
        {
            first_start = (cur_page-1) * max_row;
            first_limit = max_row * cur_page;
        }

        display_rows(response.data, first_start, first_limit);

        $('.show-paginator').hide();
        if(total_page > 1) {
            $('.show-paginator').show();
            $('.show-paginator').bootpag({
                total: total_page,
                page: cur_page > 0 ? cur_page : 1,
                maxVisible: max_visible,
                leaps: true,
                firstLastUse: true,
                first: '←',
                last: '→',
                activeClass: 'active',
                disabledClass: 'disabled',
                wrapClass: 'pagination pagination-sm justify-content-center',
            }).on('page', function (event, page) {
                //console.log(total_page+':'+total_page);
                cur_page = page;
                let html = '';
                let id = 1;
                let start = (page - 1) * max_row;
                let limit = max_row * page;

                if (total_page === page) {
                    limit = total_row;
                }
                //console.log(start+":limit:"+limit);
                //after click page
                display_rows(response.data, start, limit);
            });
        }
        $('.btn-export-csv').show();
    }
    else{
        $('.btn-export-csv').hide();
        $('.show-paginator').hide();
        let tdCount = $('.row-filter').find('td').length;
        if(!tdCount)
        {
            tdCount = $('.table').find('tr').eq(1).find('td').length;
        }
        $('#load_rows').html('<td class="text-center text-muted font-italic p-4" colspan="'+tdCount+'">Data not found.</td>');
    }
}

function max_row_select_box(response)
{
    let data = response.data;
    let all_row = data.all_row;
    let total_row = data.total_row;
    //$('.show-display-item').text('พบข้อมูล : '+total_row+' จาก '+all_row+' รายการ | '+response.time+' วินาที');
    $('.show-display-item').text('พบข้อมูล : '+all_row+' รายการ | '+response.time+' วินาที');
    if(all_row > 0)
    {
        $('.max-row').show();
    }
    else{
        $('.max-row').hide();
    }
}

//Listing utils
function row_order_payment_status(status)
{
    let text = 'Unkown';
    switch(parseInt(status)) {
        case 1:
            text = '<span class="badge badge-success">ชำระเงินแล้ว</span>';
            break;
        case 2:
            text = '<span class="badge badge-danger">ยังไม่ชำระ</span>';
            break;
        case 3:
            text = '<span class="badge badge-secondary font-italic">ยกเลิกรายการ</span>';
            break;
    }
    return '<span class="text-payment-status">' + text + '</span>';
}

function row_status(status)
{
    return '<span class="text-status">'+(status === 1 || status === '1' ? textEnable:textDisable)+'</span>';
}
function row_success(status)
{
    return '<span class="text-status">'+(status === 1 || status === '1' ? textSuccess:textError)+'</span>';
}
function activate_status(status)
{
    if(status === 1 || status === '1'){
        return '<span class="badge badge-light-success text-success">ยืนยันแล้ว</span>';
    }
    else {
        return '<span class="badge badge-light-danger font-italic">ยังไม่ยืนยัน</span>';
    }
}

function row_highlight(status)
{
    return '<span class="text-highlight">'+(status === 1 || status === '1' ? textMakeHighlight:textUnHighlight)+'</span>';
}

function order_status(status)
{
    let text = '-';
    switch(parseInt(status)) {
        case 10:
            text = '<span class="badge badge-primary">รายการใหม่</span>';
            break;
        case 11:
            text = '<span class="badge badge-warning">กำลังตรวจสอบ</span>';
            break;
        case 12:
            text = '<span class="badge badge-danger">ยืนยันคำสั่งซื้อ</span>';
            break;
        case 13:
            text = '<span class="badge badge-success">ดำเนินการเสร็จสิ้น</span>';
            break;
        case 99:
            text = '<span class="badge badge-secondary">ยกเลิกรายการ</span>';
            break;
        default:
            text = '<span class="badge badge-secondary font-italic">---</span>';
    }
    return '<span class="text-status">' + text + '</span>';
}

function billing_status(status)
{
    let text = '-';
    switch(parseInt(status)) {
        case 10:
            text = '<span class="badge badge-primary">รายการใหม่</span>';
            break;
        case 11:
            text = '<span class="badge badge-warning">กำลังตรวจสอบ</span>';
            break;
        case 12:
            text = '<span class="badge badge-danger">แจ้งส่งใบแจ้งหนี้</span>';
            break;
        case 13:
            text = '<span class="badge badge-success">ดำเนินการเสร็จสิ้น</span>';
            break;
        case 99:
            text = '<span class="badge badge-secondary">ยกเลิกรายการ</span>';
            break;
        default:
            text = '<span class="badge badge-secondary font-italic">---</span>';
    }
    return '<span class="text-status">' + text + '</span>';
}

function quotation_status(status)
{
    let text = '-';
    switch(parseInt(status)) {
        case 10:
            text = '<span class="badge badge-primary">รายการใหม่</span>';
            break;
        case 11:
            text = '<span class="badge badge-warning">กำลังตรวจสอบ</span>';
            break;
        case 12:
            text = '<span class="badge badge-danger">ส่งใบเสนอราคา</span>';
            break;
        case 13:
            text = '<span class="badge badge-success">อนุมัติราคาแล้ว</span>';
            break;
        case 14:
            text = '<span class="badge badge-info">ดำเนินการเสร็จสิ้น</span>';
            break;
        case 99:
            text = '<span class="badge badge-secondary">ยกเลิกรายการ</span>';
            break;
        default:
            text = '<span class="badge badge-secondary font-italic">---</span>';
    }
    return '<span class="text-payment-status">' + text + '</span>';
}

function row_payment_status(status)
{
    let text = '';
    switch(parseInt(status)) {
        case 10:
            text = '<span class="badge badge-warning">กำลังตรวจสอบ</span>';
            break;
        case 11:
            text = '<span class="badge badge-success">ชำระเงินแล้ว</span>';
            break;
        case 99:
            text = '<span class="badge badge-secondary font-italic">ยกเลิกรายการ</span>';
            break;
    }
    return '<span class="text-status">' + text + '</span>';
}

function row_payment_method(title, id)
{
    switch(parseInt(id)) {
        case 1:
            text = '<span class="badge badge-light-accent">'+title+'</span>';
            break;
        case 2:
            text = '<span class="badge badge-light-info">'+title+'</span>';
            break;
    }
    return text;
}

function row_datediff(days)
{
    let text = '';
    days = parseInt(days);
    if(days <= 0) {
        text = '<span class="badge badge-secondary">'+days+'</span>';
    }
    else if(days <= 15) {
        text = '<span class="badge badge-danger font080">'+days+'</span>';
    }
    else if(days <= 30) {
        text = '<span class="badge badge-warning">'+days+'</span>';
    }
    else if(days <= 45) {
        text = '<span class="badge badge-success">'+days+'</span>';
    }
    else {
        text = days.toString();
    }
    return text;
}

function row_yes_no(flag)
{
    if(flag === 1 || flag === '1'){
        return '<span class="text-success small">ใช่</span>';
    }
    else{
        return '<span class="text-danger small">ไม่ใช่</span>';
    }
}

function row_checked(flag)
{
    if(flag === 1 || flag === '1'){
        return '<i class="las la-check-circle text-success"></i>';
    }
    else{
        return '<i class="las la-minus-circle text-danger"></i>';
    }
}

function vat_type(type)
{
    if(type === 1 || type === '1'){
        return '<span class="text-primary small">Inc</span>';
    }
    else if(type === 2 || type === '2'){
        return '<span class="text-danger small">Exc</span>';
    }
    else if(type === 3 || type === '3'){
        return '<span class="text-muted small">No</span>';
    }
}

function row_vat(type)
{
    if(type === 1 || type === '1'){
        return '<i class="las la-check-circle text-success"></i>';
    }
    else if(type === 2 || type === '2'){
        return '<i class="las la-minus-circle text-muted"></i>';
    }
    else if(type === 3 || type === '3'){
        return '-';
    }
}

function row_created(row)
{
    let created_at = row.created_at;
    if(!created_at || created_at === '0000-00-00 00:00:00'){
        return '-';
    }
    let dateString = date_time(created_at);
    let exp = dateString.split(' ');
    dateString = exp[0] + ' <small>' + exp[1] + '</small>';

    return dateString;
}

function row_updated(row)
{
    let updated_at = row.created_at;
    if(row.updated_at)
    {
        updated_at = row.updated_at;
    }
    if(!updated_at || updated_at === '0000-00-00 00:00:00'){
        return '-';
    }
    let dateString = date_time(updated_at);
    let exp = dateString.split(' ');
    dateString = exp[0] + ' <small>' + exp[1] + '</small>';

    return dateString;
}

function row_date(row_date)
{
    if(!row_date || row_date === '0000-00-00 00:00:00'){
        return '';
    }
    let dateString = date_time(row_date);
    let exp = dateString.split(' ');
    dateString = exp[0] + ' <small>' + exp[1] + '</small>';

    return dateString;
}

function row_lastlogin(row)
{
    let result = '-';
    if(row.lastlogin_at)
    {
        if(!row.lastlogin_at || row.lastlogin_at === '0000-00-00 00:00:00'){
            return '-';
        }
        let dateString = date_time(row.lastlogin_at);
        let exp = dateString.split(' ');
        result = exp[0] + ' <small>' + exp[1] + '</small>';
    }

    return result;
}

function row_paydate(row)
{
    if(row.payment_datetime)
    {
        if(!row.payment_datetime || row.payment_datetime === '0000-00-00 00:00:00'){
            return '-';
        }
        let dateString = date_time(row.payment_datetime);
        let exp = dateString.split(' ');
        dateString = exp[0] + ' <small>' + exp[1] + '</small>';

        return dateString;
    }
    return '-';
}

function date_time(inputDate) {
    let d = new Date(inputDate);
    let hours = d.getHours();
    let minutes = d.getMinutes();
    let dateString = d.getDate()  + "/" + (d.getMonth()+1) + "/" + d.getFullYear() + " " +
        (hours < 10 ? '0'+hours:hours) + ":" + (minutes < 10 ? '0'+minutes:minutes);
    return dateString;
}

function date_dmy(inputDate) {
    let dateString = '';
    if(inputDate)
    {
        let d = new Date(inputDate);
        let date = d.getDate();
        let month = d.getMonth()+1;
        let year = d.getFullYear();
        dateString = (date < 10 ? '0'+date:date) + "/" + (month < 10 ? '0'+month:month) + "/" + year;
    }
    return dateString;
}

function row_status_read(status)
{
    let msg = '<span class="badge badge-danger font-italic">ยังไม่อ่าน</span>';
    if(status === 1 || status === '1'){
        msg = '<span class="badge badge-success">อ่านแล้ว</span>';
    }
    else if(status === 2 || status === '2'){
        msg = '<span class="badge badge-primary">ตอบกลับแล้ว</span>';
    }
    return '<span class="text-status">'+msg+'</span>';
}

// Listing for select box
function selectList(path, ele, key, filters = null, selected = null, field = null, field2 = null, label = ' -- Select -- ')
{
    let data = {};
    if(filters)
    {
        data.filters = filters;
    }

    let req = request_get(path, data);
    req.done(function (response, statusText, xhr)
    {
        if(response && !response.success)
        {
            error(response.message);
        }
        else{
            if(response.data.rows.length > 0)
            {
                $(ele).html('');
                $(ele).append('<option value="">'+label+'</option>');
                for(let row of response.data.rows)
                {
                    let title = '';

                    if(row.remark){
                        title = title + ' ('+row.remark+')';
                    }
                    if(row.title)
                    {
                        title = row.title;
                    }
                    if(row.title_th)
                    {
                        title = row.title_th;
                    }
                    if(row.name)
                    {
                        title = row.name;
                    }

                    if(row[field])
                    {
                        title = row[field];
                    }
                    if(row[field] && row[field2])
                    {
                        title = row[field] + ' (' + row[field2] + ')';
                    }


                    $(ele).append('<option value="'+row[key]+'">'+output_text(title)+'</option>');
                }

                if(selected)
                {
                    $(ele).val(selected);
                }
            }
            else{
                $(ele).html('');
                //warning('ไม่พบรายการ');
            }
        }
    });
}


// Listing for select box
function selectListToText(path, ele, key, filters = null)
{
    let data = {};
    if(filters)
    {
        data.filters = filters;
    }

    let req = request_get(path, data);
    req.done(function (response, statusText, xhr)
    {
        if(response && !response.success)
        {
            error(response.message);
        }
        else{
            if(response.data.rows.length > 0)
            {
                $(ele).html('');
                let row = response.data.rows;
                if(row[0] &&row[0][key])
                {
                    $(ele).val(row[0][key]);
                }
            }
            else{
                $(ele).html('');
                warning('ไม่พบรายการ');
            }
        }
    });
}


// Listing for check box
function checkboxList(path, ele, key, filters = null, field = null, name = null, checked_ids = null, disabled_all = null, field2 = null)
{
    let data = {};
    if(filters)
    {
        data.filters = filters;
    }

    let req = request_get(path, data);
    req.done(function (response, statusText, xhr)
    {
        if(response && !response.success)
        {
            error(response.message);
        }
        else{
            if(response.data.rows.length > 0)
            {
                if(disabled_all)
                {
                    disabled_all = ' disabled';
                }

                $(ele).html('');
                for(let row of response.data.rows)
                {
                    let id = row[key];
                    let title = row[field];
                    if(field2){
                        title = title + ' ' + row[field2];
                    }

                    let is_checked = ''; 
                    if(checked_ids && checked_ids.includes(parseInt(id)))
                    {
                        is_checked = ' checked';
                    }

                    $(ele).append('<div class="custom-control custom-checkbox"><input '+disabled_all+' type="checkbox" class="custom-control-input checkbox-lifestyle text-success" id="customCheck' + name + id + '" name="' + name + '[]" value="' + id + '"'+is_checked+'><label class="custom-control-label" for="customCheck' + name + id + '">' + output_text(title) + '</label></div>');
                }
            }
            else{
                $(ele).html('');
                warning('ไม่พบรายการ');
            }
        }
    });
}


//Listing action
$(function () {

    //Show toolbar row
    $('.table-listing').find('.title').hover(function(){
        $('.btn-toolbar-row').addClass('d-none').removeClass('d-block');
        $(this).find('.btn-toolbar-row').addClass('d-block');
    }, function(){
        $(this).find('.btn-toolbar-row').addClass('d-none');
    });
    $('.table-listing').hover(function(){
        $('.btn-toolbar-row').addClass('d-none').removeClass('d-block');
    });

    // Change max rows
    $(document).on('change', '.max-row', function()
    {
        request_listing(filters);
    });

    // Checked all row
    $(document).on('click', '#checkAllRow', function()
    {
        if($(this).prop('checked') === true)
        {
            $('.checkbox-row').prop('checked', true);
        }
        else{
            $('.checkbox-row').prop('checked', false);
        }
    });

});