<!DOCTYPE html>
<html lang="th">
<head>
   <meta charset="utf-8">
   <!--meta http-equiv="X-UA-Compatible" content="IE=edge, chrome=1" /-->
   <!--meta name="viewport" content="width=device-width, initial-scale=1.0"-->
   <meta name="viewport" content="width=device-width, initial-scale = 1.0,
maximum-scale=1.0, user-scalable=no" />
   <meta name="apple-mobile-web-app-capable" content="yes"/>

   <title>Product | Siam Anchor Fastener Industry</title>
   <meta name="description" content="<?php echo output_str($meta_description);?>">
   <meta name="keywords" content="<?php echo $meta_keywords;?>">
   <meta property="og:article:published_time" content="<?php echo $meta_published_time;?>" />
   <meta property="og:title" content="<?php echo output_str($meta_title);?>" />
   <meta property="og:site_name" content="<?php echo base_url();?>" />
   <meta property="og:description" content="<?php echo output_str($meta_description);?>" />
   <meta property="og:type" content="article" />
   <meta property="og:image" content="<?php echo $meta_image_url;?>" />
   <meta property="og:image:width" content="<?php echo $meta_image_width;?>" />
   <meta property="og:image:height" content="<?php echo $meta_image_height;?>" />
   <meta property="og:url" content="<?php echo $current_url;?>" />
   <link rel="image_src" href="<?php echo $meta_image_url;?>" />

   <?php include('application/views/front/th/inc/head.php');?>
</head>
<body>
  <!-- Google Tag Manager (noscript) -->
<noscript><iframe src=https://www.googletagmanager.com/ns.html?id=GTM-PRZF34K
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
    <div class="preload">
        <span class="loader"></span>
    </div>
    <div class="page">
       <?php include('application/views/front/th/inc/header.php');?>

        <nav class="navbar-breadcrumb">
            <div class="container">
                <ol class="breadcrumb">
                    <li><span>Products&nbsp;/</span></li>
                    <li><a href="<?php echo product_category_url($product_category_row);?>"><?php echo output_text($product_category_row->title);?></a></li>
                    <li><span>&nbsp;<?php echo output_text($product_row->title);?></span></li>
                  </ol>
            </div>
        </nav>

       <div class="section section-body">
            <div class="container">
                <div class="product-details">
                    <div class="row">
                        <div class="col-xl-6 col-lg-5">
                            <div class="hgroup d-block d-lg-none">
                                <h1><span><span><?php echo output_text($product_row->intro);?></span></h1>
                                <h5><?php echo output_text($product_row->title);?></h5>
                            </div>


                            <div class="product-gallery">
                                <div class="swiper-desktop-group">
                                    <div class="swiper-container gallery-top desktop">
                                        <div class="swiper-wrapper">
                                           <?php if(!empty($product_gallery_listing)) { foreach($product_gallery_listing as $rs) { ?>
                                            <div class="swiper-slide">
                                                <a class="photo" href="<?php echo product_gallery_url($rs);?>" style="background-image: url(<?php echo product_gallery_url($rs);?>);" data-fancybox>
                                                    <img class="w-100" src="<?php echo base_url();?>theme/img/thumb/frame-100x100.png" alt="">
                                                </a>
                                            </div>
                                           <?php } } ?>
                                        </div>  <!--swiper-wrapper-->
                                    </div> <!--swiper-wrapper-->

                                    <div class="swiper-container gallery-thumbs desktop">
                                        <div class="swiper-wrapper">
                                           <?php if(!empty($product_gallery_listing)) { foreach($product_gallery_listing as $rs) { ?>
                                            <div class="swiper-slide">
                                                <div class="photo" style="background-image: url(<?php echo product_gallery_url($rs);?>);">
                                                    <img src="<?php echo base_url();?>theme/img/thumb/frame-100x100.png" alt="">
                                                </div>
                                            </div>
                                           <?php } } ?>
                                        </div><!--swiper-wrapper-->
                                    </div>
                                </div><!--swiper-desktop-group-->


                                <div class="swiper-mobile-group">
                                    <div class="swiper-container gallery-top mobile">
                                        <div class="swiper-wrapper">
                                           <?php if(!empty($product_gallery_listing)) { foreach($product_gallery_listing as $rs) { ?>
                                            <div class="swiper-slide">
                                                <a class="photo" href="<?php echo product_gallery_url($rs);?>" style="background-image: url(<?php echo product_gallery_url($rs);?>);" data-fancybox>
                                                    <img class="w-100" src="<?php echo base_url();?>theme/img/thumb/frame-100x100.png" alt="">
                                                </a>
                                            </div>
                                           <?php } } ?>
                                        </div>  <!--swiper-wrapper-->
                                    </div> <!--swiper-wrapper-->

                                    <div class="swiper-container gallery-thumbs mobile">
                                        <div class="swiper-wrapper">
                                           <?php if(!empty($product_gallery_listing)) { foreach($product_gallery_listing as $rs) { ?>
                                            <div class="swiper-slide">
                                                <div class="photo" style="background-image: url(<?php echo product_gallery_url($rs);?>);">
                                                    <img src="<?php echo base_url();?>theme/img/thumb/frame-100x100.png" alt="">
                                                </div>
                                            </div>
                                           <?php } } ?>
                                        </div><!--swiper-wrapper-->
                                    </div>
                                </div><!--swiper-mobile-group-->



                            </div><!--product-gallery-->
                        </div><!--col-xl-6-->

                        <div class="col-xl-6 col-lg-7">
                           <a name="model-m"></a>
                            <div class="product-infos">
                                <div class="hgroup d-none d-lg-block">
                                    <h1><span><span><?php echo output_text($product_row->intro);?></span></h1>
                                    <h5><?php echo output_text($product_row->title);?></h5>
                                </div>

                               <?php if(!empty($product_item_listing)) { ?>
                                <div class="spect-infos">
                                    <h5>กรุณา "เลือกสินค้า" เพื่อดูสเปค</h5>

                                    <select class="form-select spec" id="show-item-code">
                                       <option value="">-- เลือก --</option>
                                       <?php $od_arr = []; $n=0; foreach($product_item_listing as $rs) {
                                          if(!empty($rs->od)) {
                                             $od_arr[] = $rs->od;
                                          }
                                       ?>
                                        <option value="<?php echo $rs->od.'|'.$rs->length;?>"<?php if($n==0 || (!empty($_GET['od']) && $_GET['od']==$rs->od) && (!empty($_GET['length']) && $_GET['length']==$rs->length)){echo ' selected';}?>><?php echo output_text($rs->code);?> <?php echo !empty($rs->od) ?  '('.output_text($rs->od).')' :'';?></option>
                                       <?php $n++; } ?>
                                    </select>

                                   <div class="tab-content tab-spec">
                                      <div id="tab-st316">
                                         <table class="table table-spec">
                                            <tbody id="show-tab-item"></tbody>
                                         </table>
                                      </div><!--tab-pane-->
                                   </div>
                                </div><!--spect-infos-->
                               <?php } ?>

                                <div class="textgroup">
                                    <div class="section-icons">
                                        <span class="icons wow fadeInDown"></span>
                                        <span class="icons wow fadeInDown"></span>
                                        <span class="icons wow fadeInUp" data-wow-offset="0"></span>
                                        <span class="icons wow fadeInUp" data-wow-offset="0"></span>
                                    </div>
                                    <div class="inner">
                                       <?php echo output_text_detail($product_row->detail);?>
                                    </div>
                                </div>
                            </div><!--col-lg-6-->
                        </div><!--col-lg-6-->

                       <?php if(!empty($product_item_listing)) {

                          $count_code = [];
                          $count_od = [];
                          $count_length = [];
                          $count_hole = [];
                          $count_depth = [];
                          $count_strength = [];
                          $count_shear = [];
                          $count_column1 = [];
                          $count_column2 = [];
                          $count_column3 = [];
                          $count_column4 = [];
                          $count_column5 = [];
                          $count_column6 = [];
                          $count_column7 = [];
                          $count_column8 = [];
                          $count_column9 = [];
                          $count_column10 = [];

                          $param_od = !empty($_GET['od']) ? $_GET['od'] : null;
                          $param_length = !empty($_GET['length']) ? $_GET['length'] : null;

                          if(!empty($param_od)) {
                             foreach($product_item_listing as $rs) {
                                if($rs->od == $param_od) {
                                   if (!empty($rs->code)) {
                                      $count_code[$param_od][] = $rs->code;
                                   }
                                   if (!empty($rs->od)) {
                                      $count_od[$param_od][] = $rs->od;
                                   }
                                   if (!empty($rs->length)) {
                                      $count_length[$param_od][] = $rs->length;
                                   }
                                   if (!empty($rs->hole)) {
                                      $count_hole[$param_od][] = $rs->hole;
                                   }
                                   if (!empty($rs->depth)) {
                                      $count_depth[$param_od][] = $rs->depth;
                                   }
                                   if (!empty($rs->strength)) {
                                      $count_strength[$param_od][] = $rs->strength;
                                   }
                                   if (!empty($rs->shear)) {
                                      $count_shear[$param_od][] = $rs->shear;
                                   }
                                   if (!empty($rs->column1)) {
                                      $count_column1[$param_od][] = $rs->column1;
                                   }
                                   if (!empty($rs->column2)) {
                                      $count_column2[$param_od][] = $rs->column2;
                                   }
                                   if (!empty($rs->column3)) {
                                      $count_column3[$param_od][] = $rs->column3;
                                   }
                                   if (!empty($rs->column4)) {
                                      $count_column4[$param_od][] = $rs->column4;
                                   }
                                   if (!empty($rs->column5)) {
                                      $count_column5[$param_od][] = $rs->column5;
                                   }
                                   if (!empty($rs->column6)) {
                                      $count_column6[$param_od][] = $rs->column6;
                                   }
                                   if (!empty($rs->column7)) {
                                      $count_column7[$param_od][] = $rs->column7;
                                   }
                                   if (!empty($rs->column8)) {
                                      $count_column8[$param_od][] = $rs->column8;
                                   }
                                   if (!empty($rs->column9)) {
                                      $count_column9[$param_od][] = $rs->column9;
                                   }
                                   if (!empty($rs->column10)) {
                                      $count_column10[$param_od][] = $rs->column10;
                                   }
                                }
                             }
                          }
                          else if(!empty($param_od) && !empty($param_length)) {
                             foreach($product_item_listing as $rs) {
                                if($rs->length == $param_length) {
                                   if (!empty($rs->code)) {
                                      $count_code[$param_od][$param_length][] = $rs->code;
                                   }
                                   if (!empty($rs->od)) {
                                      $count_od[$param_od][$param_length][] = $rs->od;
                                   }
                                   if (!empty($rs->length)) {
                                      $count_length[$param_od][$param_length][] = $rs->length;
                                   }
                                   if (!empty($rs->hole)) {
                                      $count_hole[$param_od][$param_length][] = $rs->hole;
                                   }
                                   if (!empty($rs->depth)) {
                                      $count_depth[$param_od][$param_length][] = $rs->depth;
                                   }
                                   if (!empty($rs->strength)) {
                                      $count_strength[$param_od][$param_length][] = $rs->strength;
                                   }
                                   if (!empty($rs->shear)) {
                                      $count_shear[$param_od][$param_length][] = $rs->shear;
                                   }
                                   if (!empty($rs->column1)) {
                                      $count_column1[$param_od][$param_length][] = $rs->column1;
                                   }
                                   if (!empty($rs->column2)) {
                                      $count_column2[$param_od][$param_length][] = $rs->column2;
                                   }
                                   if (!empty($rs->column3)) {
                                      $count_column3[$param_od][$param_length][] = $rs->column3;
                                   }
                                   if (!empty($rs->column4)) {
                                      $count_column4[$param_od][$param_length][] = $rs->column4;
                                   }
                                   if (!empty($rs->column5)) {
                                      $count_column5[$param_od][$param_length][] = $rs->column5;
                                   }
                                   if (!empty($rs->column6)) {
                                      $count_column6[$param_od][$param_length][] = $rs->column6;
                                   }
                                   if (!empty($rs->column7)) {
                                      $count_column7[$param_od][$param_length][] = $rs->column7;
                                   }
                                   if (!empty($rs->column8)) {
                                      $count_column8[$param_od][$param_length][] = $rs->column8;
                                   }
                                   if (!empty($rs->column9)) {
                                      $count_column9[$param_od][$param_length][] = $rs->column9;
                                   }
                                   if (!empty($rs->column10)) {
                                      $count_column10[$param_od][$param_length][] = $rs->column10;
                                   }
                                }
                             }
                          }
                          else {
                             foreach($product_item_listing as $rs) {
                                if (!empty($rs->code)) {
                                   $count_code[] = $rs->code;
                                }
                                if (!empty($rs->od)) {
                                   $count_od[] = $rs->od;
                                }
                                if (!empty($rs->length)) {
                                   $count_length[] = $rs->length;
                                }
                                if (!empty($rs->hole)) {
                                   $count_hole[] = $rs->hole;
                                }
                                if (!empty($rs->depth)) {
                                   $count_depth[] = $rs->depth;
                                }
                                if (!empty($rs->strength)) {
                                   $count_strength[] = $rs->strength;
                                }
                                if (!empty($rs->shear)) {
                                   $count_shear[] = $rs->shear;
                                }
                                if (!empty($rs->column1)) {
                                   $count_column1[] = $rs->column1;
                                }
                                if (!empty($rs->column2)) {
                                   $count_column2[] = $rs->column2;
                                }
                                if (!empty($rs->column3)) {
                                   $count_column3[] = $rs->column3;
                                }
                                if (!empty($rs->column4)) {
                                   $count_column4[] = $rs->column4;
                                }
                                if (!empty($rs->column5)) {
                                   $count_column5[] = $rs->column5;
                                }
                                if (!empty($rs->column6)) {
                                   $count_column6[] = $rs->column6;
                                }
                                if (!empty($rs->column7)) {
                                   $count_column7[] = $rs->column7;
                                }
                                if (!empty($rs->column8)) {
                                   $count_column8[] = $rs->column8;
                                }
                                if (!empty($rs->column9)) {
                                   $count_column9[] = $rs->column9;
                                }
                                if (!empty($rs->column10)) {
                                   $count_column10[] = $rs->column10;
                                }
                             }
                          }
                       ?>
                        <div class="col-12">
                           <a name="model"></a>
                            <div class="product-spec">
                                <div class="d-flex gap-3 mb-3">
                                   <?php if(!empty($count_od)) { ?>
                                    <div>
                                        <select class="form-select w-200 th" id="show-item-od">
                                            <option value=""<?php if(empty($_GET['od'])){echo ' selected';}?>>ขนาดเกลียว</option>
                                           <?php if(!empty($od_arr)) { foreach(array_unique($od_arr) as $od) { ?>
                                              <option value="<?php echo output_text($od);?>"<?php if($_GET['od'] == $od){echo ' selected';}?>><?php echo output_text($od);?></option>
                                           <?php } } ?>
                                        </select>
                                    </div>
                                   <?php } ?>
                                   <?php if(!empty($count_length)) { ?>
                                    <div>
                                        <select class="form-select w-200 th" id="show-item-length" disabled>
                                            <option value="">ความยาว (mm.)</option>
                                        </select>
                                    </div>
                                   <?php } ?>
                                </div>

                                <div class="table-responsive">
                                    <table class="table table-spec table-striped">
                                        <tr>
                                          <?php if(!empty($count_code)) {echo '<th class="h-code">รหัสสินค้า</th>';} ?>
                                          <?php if(!empty($count_od)) {echo '<th class="h-od">ขนาดเกลียว</th>';} ?>
                                          <?php if(!empty($count_length)) {echo '<th class="h-length">ความยาว (mm.)</th>';} ?>
                                          <?php if(!empty($count_hole)) {echo '<th class="h-hole">ขนาดรูคอนกรีต (mm.)</th>';} ?>
                                          <?php if(!empty($count_depth)) {echo '<th class="h-depth">ความลึกรูคอนกรีต (mm.)</th>';} ?>
                                          <?php if(!empty($count_strength)) {echo '<th class="h-strength">แรงดึง (kN)</th>';} ?>
                                          <?php if(!empty($count_shear)) {echo '<th class="h-shear">แรงเฉือน (kN)</th>';} ?>
                                           <?php
                                           if(!empty($count_column1) && !empty($product_item_column->column1)) {
                                              echo '<th>' . output_text($product_item_column->column1) . '</th>';
                                           }
                                           if(!empty($count_column2) && !empty($product_item_column->column2)) {
                                              echo '<th>' . output_text($product_item_column->column2) . '</th>';
                                           }
                                           if(!empty($count_column3) && !empty($product_item_column->column3)) {
                                              echo '<th>' . output_text($product_item_column->column3) . '</th>';
                                           }
                                           if(!empty($count_column4) && !empty($product_item_column->column4)) {
                                              echo '<th>' . output_text($product_item_column->column4) . '</th>';
                                           }
                                           if(!empty($count_column5) && !empty($product_item_column->column5)) {
                                              echo '<th>' . output_text($product_item_column->column5) . '</th>';
                                           }
                                           if(!empty($count_column6) && !empty($product_item_column->column6)) {
                                              echo '<th>' . output_text($product_item_column->column6) . '</th>';
                                           }
                                           if(!empty($count_column7) && !empty($product_item_column->column7)) {
                                              echo '<th>' . output_text($product_item_column->column7) . '</th>';
                                           }
                                           if(!empty($count_column8) && !empty($product_item_column->column8)) {
                                              echo '<th>' . output_text($product_item_column->column8) . '</th>';
                                           }
                                           if(!empty($count_column9) && !empty($product_item_column->column9)) {
                                              echo '<th>' . output_text($product_item_column->column9) . '</th>';
                                           }
                                           if(!empty($count_column10) && !empty($product_item_column->column10)) {
                                              echo '<th>' . output_text($product_item_column->column10) . '</th>';
                                           }
                                           ?>
                                        </tr>
                                       <tbody id="show-item">
                                       <?php foreach($product_item_listing as $rs) { ?>
                                        <tr>
                                           <?php if(!empty($count_code)) {echo '<td>'.output_text($rs->code).'</td>';} ?>
                                           <?php if(!empty($count_od)) {echo '<td>'.output_text($rs->od).'</td>';} ?>
                                           <?php if(!empty($count_length)) {echo '<td>'.output_text($rs->length).'</td>';} ?>
                                           <?php if(!empty($count_hole)) {echo '<td>'.output_text($rs->hole).'</td>';} ?>
                                           <?php if(!empty($count_depth)) {echo '<td>'.output_text($rs->depth).'</td>';} ?>
                                           <?php if(!empty($count_strength)) {echo '<td>'.output_text($rs->strength).'</td>';} ?>
                                           <?php if(!empty($count_shear)) {echo '<td>'.output_text($rs->shear).'</td>';} ?>
                                           <?php
                                           if(!empty($count_column1)) {
                                              echo '<td>' . output_text($rs->column1) . '</td>';
                                           }
                                           if(!empty($count_column2)) {
                                              echo '<td>' . output_text($rs->column2) . '</td>';
                                           }
                                           if(!empty($count_column3)) {
                                              echo '<td>' . output_text($rs->column3) . '</td>';
                                           }
                                           if(!empty($count_column4)) {
                                              echo '<td>' . output_text($rs->column4) . '</td>';
                                           }
                                           if(!empty($count_column5)) {
                                              echo '<td>' . output_text($rs->column5) . '</td>';
                                           }
                                           if(!empty($count_column6)) {
                                              echo '<td>' . output_text($rs->column6) . '</td>';
                                           }
                                           if(!empty($count_column7)) {
                                              echo '<td>' . output_text($rs->column7) . '</td>';
                                           }
                                           if(!empty($count_column8)) {
                                              echo '<td>' . output_text($rs->column8) . '</td>';
                                           }
                                           if(!empty($count_column9)) {
                                              echo '<td>' . output_text($rs->column9) . '</td>';
                                           }
                                           if(!empty($count_column10)) {
                                              echo '<td>' . output_text($rs->column10) . '</td>';
                                           }
                                           ?>
                                        </tr>
                                       <?php } ?>
                                       </tbody>
                                    </table>
                                </div>

                            </div><!--product-spec-->
                        </div><!--col-12-->
                       <?php } ?>

                       <?php if(!empty($product_row->special_ext) || !empty($product_row->pdf_ext) || !empty($product_row->youtube_url)) { ?>
                        <div class="col-12">
                            <div class="product-installation">
                            <?php if($product_row->special_ext==""||$product_row->youtube_url=="") { ?>
                                <h5>Installation guide</h5>
                            <?php } ?>

                               <?php if(!empty($product_row->special_ext)) { ?>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <a href="<?php echo product_special_url($product_row);?>" data-fancybox>
                                            <img class="w-100" src="<?php echo product_special_url($product_row);?>" alt="<?php echo output_text($product_row->title);?>">
                                        </a>
                                    </div>
                                </div><!--row-->
                               <?php } ?>

                               <?php if(!empty($product_row->youtube_url)) { ?>
                               <div class="row pt-xl-4 pt-4">
                                  <div class="col-12">
                                     <div class="ratio ratio-16x9">
                                        <iframe src="<?php echo $product_row->youtube_url;?>"></iframe>
                                     </div>
                                  </div>
                               </div>
                               <?php } ?>

                               <?php if(!empty($product_row->pdf_ext)) { ?>
                                <div class="d-flex pt-xl-5 pt-4">
                                    <a href="<?php echo product_pdf_url($product_row)?>" class="btn btn-outline btn-md download" target="_blank">
                                        <span class="icons">
                                            <img class="svg-js" src="<?php echo base_url();?>theme/img/icons/icon-download.svg" alt="">
                                        </span>
                                        Download full spec sheet
                                    </a>
                                </div>
                               <?php } ?>

                            </div><!--product-installation-->
                        </div><!--col-12-->
                       <?php } ?>

                       <?php if(!empty($product_item_listing)) { ?>
                        <div class="col-12">
                            <div class="product-quotation">
                                <h5 class="text-center">ขอใบเสนอราคา</h5>

                                <h6>เลือกสินค้า :</h6>
                                <ul class="nav product-code">
                                   <?php foreach($product_item_listing as $rs) { ?>
                                    <li><a data-bs-toggle="tab" href="#" data-product-id="<?php echo output_text($rs->product_id);?>" data-id="<?php echo output_text($rs->product_item_id);?>" class="item-select"><?php echo output_text($rs->code);?></a></li>
                                   <?php } ?>
                                </ul>

                                <div class="quantity">
                                    <h6>จำนวน (ตัว) :</h6>
                                    <input type="hidden" class="form-control th" id="product-id">
                                    <input type="hidden" class="form-control th" id="item-id">
                                    <input type="text" class="form-control th" id="cart-item" placeholder="ใส่จำนวน">
                                </div>

                                <div class="d-flex">
                                    <button class="btn btn-sm mx-auto" type="button" id="add-to-cart">+เพิ่มในใบขอราคา</button>
                                </div>
                            </div><!--product-quotation-->
                        </div>
                        <?php } ?>
                    </div><!--row-->


                </div><!--product-details-->
            </div><!--container-->
        </div><!--section-->

       <?php include('application/views/front/th/inc/footer.php');?>
    </div><!--page-->

    <div class="modal modal-alert fade" id="addProductModal">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="icons main">
                        <img class="quotation" src="<?php echo base_url();?>theme/img/icons/icon-quotation.svg" alt="">
                    </div>
                    <h5 class="mb-2">
                        คุณได้เพิ่มสินค้า<br>
                        ในแบบใบขอราคาแล้ว
                    </h5>
                </div><!--modal-body-->

                <div class="modal-button pt-0">
                    <button class="btn btn-outline" type="button" data-bs-dismiss="modal">
                        เลือกสินค้าอื่น
                    </button>

                    <a class="btn btn-outline" href="<?php echo base_url('request-quotation');?>">
                        รีวิวใบขอราคา
                    </a>
                </div>
            </div><!--modal-content-->
        </div><!--modal-dialog-->
    </div><!-- Modal -->

    <?php include('application/views/front/th/inc/body.php');?>

    <script>
        // var $myModal = new bootstrap.Modal('#addProductModal');
        // $myModal.show();

        $('.tab-spec .tab-pane').hide();
        $('.tab-spec .tab-pane:first-child').show();
        $('select.spec').change(function () {
            let dropdown = $('select.spec').val();
            dropdown = dropdown.replaceAll(' ', '-');
            dropdown = dropdown.replaceAll('/', '-');
            dropdown = dropdown.replaceAll('|', '-');
            $('.tab-spec .tab-pane').hide();
            $('#' + "tab-" + dropdown).show();
        });


        $(window).on("load", function(){
            var galleryThumbsDesktop = new Swiper('.gallery-thumbs.desktop', {
                spaceBetween:6,
                slidesPerView: 4,
                direction: 'vertical',
                loop: false,
                effect: 'slide',
                watchSlidesVisibility: true,
                observeParents: true,
                watchOverflow: true,
                /*simulateTouch:false,*/
            });

            var galleryDesktop = new Swiper('.gallery-top.desktop', {
                slidesPerView:1,
                spaceBetween:10,
                speed: 500,
                loop: false,
                observer: true,
                effect: 'slide',
                observeParents: true,
                watchOverflow: true,
                thumbs: {
                    swiper: galleryThumbsDesktop,
                }
            });

            var galleryThumbsMobile = new Swiper('.gallery-thumbs.mobile', {
                spaceBetween:8,
                slidesPerView: 4,
                loop: false,
                effect: 'slide',
                watchSlidesVisibility: true,
                observeParents: true,
                watchOverflow: true,
                /*simulateTouch:false,*/
            });

            var galleryMobile = new Swiper('.gallery-top.mobile', {
                slidesPerView:1,
                spaceBetween:10,
                speed: 500,
                loop: false,
                observer: true,
                effect: 'slide',
                observeParents: true,
                watchOverflow: true,
                thumbs: {
                    swiper: galleryThumbsMobile,
                }
            });
        });

        //get item
       function get_length_item() {
           let PATH = 'restful/front/product_item/get_length';
           let od = $('#show-item-od').val();
           let length = '<?php echo $_GET['length']?>';
           let req = request_get(PATH, {product_id: <?php echo $product_row->product_id;?>, od: od});
           req.done(function (response, statusText, xhr)
           {
               if(response && !response.success)
               {
                   toast_error(response.message);
               }
               else{
                   let html = '<option value="">ความยาว (mm.)</option>';
                   if(response.data) {
                       for(let rs of response.data) {
                           html += '<option value="' + rs + '"';
                           if(length === rs){
                               html += ' selected';
                           }
                           html += '>' + rs + '</option>';
                       }
                   }
                   $('#show-item-length').html(html);
                   get_item();
               }
           });
       }
        function get_item() {
           let ths = $('#show-item');
            ths.html('');
            show_spinner(ths, true);
            let PATH = 'restful/front/product_item/get_item';
            let req = request_get(PATH, {product_id: <?php echo $product_row->product_id;?>, od: $('#show-item-od').val(), length: $('#show-item-length').val()});
            req.done(function (response, statusText, xhr)
            {
                hide_spinner(ths, true);
                if(response && !response.success)
                {
                    toast_error(response.message);
                }
                else{
                    let html = '';
                    if(response.data) {
                        for (let rs of response.data) {
                            html += '<tr>';
                            if(response.data.filter(e => e.code).length > 0) {
                                html += '<td>' + rs.code + '</td>';
                            }
                            if(response.data.filter(e => e.od).length > 0) {
                                html += '<td>' + rs.od + '</td>';
                            }
                            if(response.data.filter(e => e.length).length > 0) {
                                html += '<td>' + rs.length + '</td>';
                            }
                            if(response.data.filter(e => e.hole).length > 0) {
                                html += '<td>' + rs.hole + '</td>';
                            }
                            if(response.data.filter(e => e.strength).length > 0) {
                                html += '<td>' + rs.strength + '</td>';
                            }
                            if(response.data.filter(e => e.shear).length > 0) {
                                html += '<td>' + rs.shear + '</td>';
                            }
                            if(response.data.filter(e => e.depth).length > 0) {
                                html += '<td>' + rs.depth + '</td>';
                            }
                            if(response.data.filter(e => e.column1).length > 0) {
                                html += '<td>' + rs.column1 + '</td>';
                            }
                            if(response.data.filter(e => e.column2).length > 0) {
                                html += '<td>' + rs.column2 + '</td>';
                            }
                            if(response.data.filter(e => e.column3).length > 0) {
                                html += '<td>' + rs.column3 + '</td>';
                            }
                            if(response.data.filter(e => e.column4).length > 0) {
                                html += '<td>' + rs.column4 + '</td>';
                            }
                            if(response.data.filter(e => e.column5).length > 0) {
                                html += '<td>' + rs.column5 + '</td>';
                            }
                            if(response.data.filter(e => e.column6).length > 0) {
                                html += '<td>' + rs.column6 + '</td>';
                            }
                            if(response.data.filter(e => e.column7).length > 0) {
                                html += '<td>' + rs.column7 + '</td>';
                            }
                            if(response.data.filter(e => e.column8).length > 0) {
                                html += '<td>' + rs.column8 + '</td>';
                            }
                            if(response.data.filter(e => e.column9).length > 0) {
                                html += '<td>' + rs.column9 + '</td>';
                            }
                            if(response.data.filter(e => e.column10).length > 0) {
                                html += '<td>' + rs.column10 + '</td>';
                            }
                            html += '</tr>';
                        }
                    }
                    ths.html(html);
                }
            });
        }
       $('#show-item-od').on('change', function () {
           if($(this).val()) {
               //$('#show-item-length').prop('disabled', false);
               window.location = '<?php echo current_url()?>?od=' + $(this).val() + '&length=' + $('#show-item-length').val() + '#model';
           }
           else {
               window.location = '<?php echo current_url()?>#model';
           }
       });
        $('#show-item-length').on('change', function () {
            if($(this).val()) {
                window.location = '<?php echo current_url()?>?od=' + $('#show-item-od').val() + '&length=' + $(this).val() + '#model';
            }
        });
        <?php if(!empty($_GET['od'])) { ?>
        $('#show-item-length').prop('disabled', false);
        get_length_item();
        <?php } ?>
        <?php if(!empty($_GET['length'])) { ?>
        get_item();
        <?php } ?>

        function get_item_mobile() {
            let ths = $('#show-tab-item');
            ths.html('');
            show_spinner(ths, true);
            let code = $('#show-item-code').val();
            let od = null;
            let length = null;
            if(code) {
                let sp = code.split('|');
                od = sp[0];
                length = sp[1];
            }
            let PATH = 'restful/front/product_item/get_item_mobile';
            let req = request_get(PATH, {product_id: <?php echo $product_row->product_id;?>, od: od, length:length});
            req.done(function (response, statusText, xhr)
            {
                hide_spinner(ths, true);
                if(response && !response.success)
                {
                    toast_error(response.message);
                }
                else{
                    let html = '';
                    if(response.data) {
                        if(response.data.code) {
                            html += '<tr>\n' +
                                '                                                    <td>รหัสสินค้า</td>\n' +
                                '                                                    <td>' + response.data.code + '</td>\n' +
                                '                                                    <td></td>\n' +
                                '                                                </tr>';
                        }
                        if(response.data.od) {
                            html += '                                                <tr>\n' +
                                '                                                    <td>ขนาดเกลียว</td>\n' +
                                '                                                    <td>' + response.data.od + '</td>\n' +
                                '                                                    <td></td>\n' +
                                '                                                </tr>';
                        }
                        if(response.data.length) {
                            html += '                                                <tr>\n' +
                                '                                                    <td>ความยาว</td>\n' +
                                '                                                    <td>' + response.data.length + '</td>\n' +
                                '                                                    <td>mm.</td>\n' +
                                '                                                </tr>';
                        }
                        if(response.data.hole) {
                            html += '                                                <tr>\n' +
                                '                                                    <td>ขนาดรูคอนกรีต</td>\n' +
                                '                                                    <td>' + response.data.hole + '</td>\n' +
                                '                                                    <td>mm.</td>\n' +
                                '                                                </tr>';
                        }
                        if(response.data.depth) {
                            html += '                                               <tr>\n' +
                                '                                                    <td>ความลึกรูคอนกรีต</td>\n' +
                                '                                                    <td>' + response.data.depth + '</td>\n' +
                                '                                                    <td>mm</td>\n' +
                                '                                                </tr>';
                        }
                        if(response.data.strength) {
                            html += '                                                <tr>\n' +
                                '                                                    <td>แรงดึง</td>\n' +
                                '                                                    <td>' + response.data.strength + '</td>\n' +
                                '                                                    <td>kN.</td>\n' +
                                '                                                </tr>';
                        }
                        if(response.data.shear) {
                            html += '                                                <tr>\n' +
                                '                                                    <td>แรงเฉือน</td>\n' +
                                '                                                    <td>' + response.data.shear + '</td>\n' +
                                '                                                    <td>kN.</td>\n' +
                                '                                                </tr>';
                        }

                        if(response.data.column1 && response.data.column1_name) {
                            html += '                                                <tr>\n' +
                                '                                                    <td>' + response.data.column1_name + '</td>\n' +
                                '                                                    <td>' + response.data.column1 + '</td>\n' +
                                '                                                    <td></td>\n' +
                                '                                                </tr>';
                        }
                        if(response.data.column2 && response.data.column2_name) {
                            html += '                                                <tr>\n' +
                                '                                                    <td>' + response.data.column2_name + '</td>\n' +
                                '                                                    <td>' + response.data.column2 + '</td>\n' +
                                '                                                    <td></td>\n' +
                                '                                                </tr>';
                        }
                        if(response.data.column3 && response.data.column3_name) {
                            html += '                                                <tr>\n' +
                                '                                                    <td>' + response.data.column3_name + '</td>\n' +
                                '                                                    <td>' + response.data.column3 + '</td>\n' +
                                '                                                    <td></td>\n' +
                                '                                                </tr>';
                        }
                        if(response.data.column4 && response.data.column4_name) {
                            html += '                                                <tr>\n' +
                                '                                                    <td>' + response.data.column4_name + '</td>\n' +
                                '                                                    <td>' + response.data.column4 + '</td>\n' +
                                '                                                    <td></td>\n' +
                                '                                                </tr>';
                        }
                        if(response.data.column5 && response.data.column5_name) {
                            html += '                                                <tr>\n' +
                                '                                                    <td>' + response.data.column5_name + '</td>\n' +
                                '                                                    <td>' + response.data.column5 + '</td>\n' +
                                '                                                    <td></td>\n' +
                                '                                                </tr>';
                        }
                        if(response.data.column6 && response.data.column6_name) {
                            html += '                                                <tr>\n' +
                                '                                                    <td>' + response.data.column6_name + '</td>\n' +
                                '                                                    <td>' + response.data.column6 + '</td>\n' +
                                '                                                    <td></td>\n' +
                                '                                                </tr>';
                        }
                        if(response.data.column7 && response.data.column7_name) {
                            html += '                                                <tr>\n' +
                                '                                                    <td>' + response.data.column7_name + '</td>\n' +
                                '                                                    <td>' + response.data.column7 + '</td>\n' +
                                '                                                    <td></td>\n' +
                                '                                                </tr>';
                        }
                        if(response.data.column8 && response.data.column8_name) {
                            html += '                                                <tr>\n' +
                                '                                                    <td>' + response.data.column8_name + '</td>\n' +
                                '                                                    <td>' + response.data.column8 + '</td>\n' +
                                '                                                    <td></td>\n' +
                                '                                                </tr>';
                        }
                        if(response.data.column9 && response.data.column9_name) {
                            html += '                                                <tr>\n' +
                                '                                                    <td>' + response.data.column9_name + '</td>\n' +
                                '                                                    <td>' + response.data.column9 + '</td>\n' +
                                '                                                    <td></td>\n' +
                                '                                                </tr>';
                        }
                        if(response.data.column10 && response.data.column10_name) {
                            html += '                                                <tr>\n' +
                                '                                                    <td>' + response.data.column10_name + '</td>\n' +
                                '                                                    <td>' + response.data.column10 + '</td>\n' +
                                '                                                    <td></td>\n' +
                                '                                                </tr>';
                        }
                    }
                    ths.html(html);
                }
            });
        }
        get_item_mobile();
        $('#show-item-code').on('change', function () {
            if($(this).val()) {
                let val = $(this).val();
                console.log(val);
                let sp = val.split('|');
                window.location = '<?php echo current_url()?>?od=' + sp[0] + '&length=' + sp[1] + '#model-m';
            }
            //get_item_mobile();
        });

    </script>
</body>
</html>
