<!DOCTYPE html>
<html lang="th">
<head>
   <meta charset="utf-8">
   <!--meta http-equiv="X-UA-Compatible" content="IE=edge, chrome=1" /-->
   <!--meta name="viewport" content="width=device-width, initial-scale=1.0"-->
   <meta name="viewport" content="width=device-width, initial-scale = 1.0,
maximum-scale=1.0, user-scalable=no" />
   <meta name="apple-mobile-web-app-capable" content="yes"/>

   <title>Product | Siam Anchor Fastener Industry</title>
   <meta name="description" content="<?php echo output_str($meta_description);?>">
   <meta name="keywords" content="<?php echo $meta_keywords;?>">
   <meta property="og:article:published_time" content="<?php echo $meta_published_time;?>" />
   <meta property="og:title" content="<?php echo output_str($meta_title);?>" />
   <meta property="og:site_name" content="<?php echo base_url();?>" />
   <meta property="og:description" content="<?php echo output_str($meta_description);?>" />
   <meta property="og:type" content="article" />
   <meta property="og:image" content="<?php echo $meta_image_url;?>" />
   <meta property="og:image:width" content="<?php echo $meta_image_width;?>" />
   <meta property="og:image:height" content="<?php echo $meta_image_height;?>" />
   <meta property="og:url" content="<?php echo $current_url;?>" />
   <link rel="image_src" href="<?php echo $meta_image_url;?>" />

   <?php include('application/views/front/th/inc/head.php');?>
</head>
<body>
  <!-- Google Tag Manager (noscript) -->
<noscript><iframe src=https://www.googletagmanager.com/ns.html?id=GTM-PRZF34K
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
    <div class="preload">
        <span class="loader"></span>
    </div>
    <div class="page">
       <?php include('application/views/front/th/inc/header.php');?>

       <nav class="navbar-breadcrumb">
          <div class="container">
             <ol class="breadcrumb">
                <li><a href="#">Article</a></li>
             </ol>
          </div>
       </nav>

       <div class="section section-body">
          <div class="container">
             <div class="boxed boxed-1000">
                <div class="section-title articles pt-0">
                   <div class="textrow">
                      <h2 class="title-xl wow fadeInUp ps-1">ARTICLE</h2>
                   </div>

                   <div class="textrow">
                      <h4 class="wow fadeIn ps-1">
                         <span class="icons icon-tag"></span>หัวข้อที่เลือก
                      </h4>
                   </div>

                   <ul class="nav nav-filter">
                      <li><button class="btn btn-filter-all <?php if(empty($_GET['c'])){echo 'active';}?>" type="button">แสดงทั้งหมด</button></li>
                      <?php if(!empty($blog_category_listing)) { foreach($blog_category_listing as $rs) { ?>
                      <li><button class="btn btn-filter-category btn-category-<?php echo $rs->blog_category_id;?>" data-id="<?php echo $rs->blog_category_id;?>" type="button"><?php echo output_text($rs->title);?></button></li>
                      <?php } } ?>
                   </ul>
                </div>

                <?php if(!empty($blog_listing)) { ?>
                <div class="news-lists">
                   <div class="row" id="show-article">

                   </div><!--row-->

                   <div class="buttons viweall wow fadeIn mt-md-4 mt-3">
                      <button class="btn w-205" type="button" id="btn-loadmore">โหลดเพิ่ม</button>
                   </div>

                   <div class="p-sm-4"></div>
                </div>
                <?php } else{echo 'ไม่พบข้อมูล';}?>
             </div><!--boxed-->

          </div><!--container-->
       </div><!--section-->

       <?php include('application/views/front/th/inc/footer.php');?>
    </div><!--page-->

    <?php include('application/views/front/th/inc/body.php');?>
    <script>

       <?php if(!empty($_GET['c'])) { ?>
       $('.btn-category-<?php echo $_GET['c'];?>').addClass('active');
       <?php } ?>

        var page = 1;
        $('.btn-filter-all').on('click', function () {
            $(this).addClass('active');
            $('.btn-filter-category').removeClass('active');
            $('#show-article').html('');
            page = 1;
            load_more();
        });

        $('.btn-filter-category').on('click', function () {

            if($(this).hasClass('active')) {
                $(this).removeClass('active');
            }
            else {
                $(this).addClass('active');
                $('.btn-filter-all').removeClass('active');
            }

            $('#show-article').html('');
            page = 1;
            load_more();
        });

        $(document).on('click', '.btn-filter-category2', function () {

            $('.btn-filter-category').removeClass('active');

            let id = $(this).data('id');

            if($('.btn-category-' + id).hasClass('active')) {
                $('.btn-category-' + id).removeClass('active');
            }
            else {
                $('.btn-category-' + id).addClass('active');
                $('.btn-filter-all').removeClass('active');
            }

            $('#show-article').html('');
            page = 1;
            load_more();
        });

        $('#btn-loadmore').on('click', function () {
            page++;

            load_more();

            if(page === <?php echo $blog_total_page;?>) {
                $('#btn-loadmore').addClass('d-none');
            }
        });

        load_more();
        function load_more() {
            $('#btn-loadmore').removeClass('d-none');

            let PATH = 'restful/front/article/listing';

            let blog_category_ids = [];
            $('.btn-filter-category.active').each(function () {
                blog_category_ids.push($(this).data('id'));
            });
            
            let req = request_get(PATH, {page: page, blog_category_ids: blog_category_ids, lang: 'th'});
            req.done(function (response, statusText, xhr)
            {
                if(response && !response.success)
                {
                    toast_error(response.message);
                }
                else{
                    let html = '';
                    if(response.data && response.data.blog_listing) {
                        for(let rs of response.data.blog_listing) {
                            let blog_tags = rs.blog_tags;
                            html += '<div class="col-sm-4"> <div class="card-news wow fadeIn"> <a href="<?php echo $base_url.'article/detail/';?>' + rs.rewrite_url + '" class="card-link"></a> <div class="card-photo"> <div class="photo" style="background-image: url(' + rs.thumb_url + ');"> <img src="<?php echo base_url(); ?>/theme/img/thumb/frame-100x90.png" alt="' + rs.title_th + '"> </div> </div> <div class="card-body"> <h3>' + rs.title_th + '</h3> </div>  ' +(blog_tags ? '<div class="card-footer"><p><span class="icons icon-tag"></span> ' + (blog_tags ? blog_tags.join(', ') : '') + '</p></div>' : '')+ ' </div> </div>';
                        }
                    }
                    $('#show-article').append(html);

                    if(response.data.blog_total_page === page) {
                        $('#btn-loadmore').addClass('d-none');
                    }
                    else {
                        $('#btn-loadmore').removeClass('d-none');
                    }
                }
            });
        }
    </script>
</body>
</html>
