<!DOCTYPE html>
<html lang="th">
<head>
   <meta charset="utf-8">
   <!--meta http-equiv="X-UA-Compatible" content="IE=edge, chrome=1" /-->
   <!--meta name="viewport" content="width=device-width, initial-scale=1.0"-->
   <meta name="viewport" content="width=device-width, initial-scale = 1.0,
maximum-scale=1.0, user-scalable=no" />
   <meta name="apple-mobile-web-app-capable" content="yes"/>

   <title><?php echo output_str($meta_title);?> | Siam Anchor Fastener Industry</title>
   <meta name="description" content="<?php echo strip_tags($meta_description);?>">
   <meta name="keywords" content="<?php echo strip_tags($meta_keywords);?>">
   <meta property="og:article:published_time" content="<?php echo $meta_published_time;?>" />
   <meta property="og:title" content="<?php echo output_str($meta_title);?>" />
   <meta property="og:site_name" content="<?php echo base_url();?>" />
   <meta property="og:description" content="<?php echo output_str($meta_description);?>" />
   <meta property="og:type" content="article" />
   <meta property="og:image" content="<?php echo $meta_image_url;?>" />
   <meta property="og:image:width" content="<?php echo $meta_image_width;?>" />
   <meta property="og:image:height" content="<?php echo $meta_image_height;?>" />
   <meta property="og:url" content="<?php echo $current_url;?>" />
   <link rel="image_src" href="<?php echo $meta_image_url;?>" />

   <?php include('application/views/front/th/inc/head.php');?>
</head>
<body>
  <!-- Google Tag Manager (noscript) -->
<noscript><iframe src=https://www.googletagmanager.com/ns.html?id=GTM-PRZF34K
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
    <div class="preload">
        <span class="loader"></span>
    </div>
    <div class="page">
       <?php include('application/views/front/th/inc/header.php');?>

       <nav class="navbar-breadcrumb">
          <div class="container">
             <ol class="breadcrumb">
                <li><a href="<?php echo $base_url;?>article">Article</a></li>
                <li><span><?php echo output_text($blog_row->title_th);?></span></li>
             </ol>
          </div>
       </nav>

       <div class="section section-body pb-0">
          <div class="container">
             <?php if(!empty($blog_row)) { ?>
             <div class="boxed boxed-1000">
                <div class="article-banner">
                   <a href="<?php echo blog_cover_url($blog_row);?>" data-fancybox="">
                      <img class="w-100" src="<?php echo blog_cover_url($blog_row);?>" alt="">
                   </a>
                </div>

                <div class="article-details">
                   <div class="article-inner">
                      <h1><?php echo output_text($blog_row->title_th);?></h1>
                   </div>

                   <div class="article-inner article-share">
                      <?php if(!empty($blog_row->blog_tags)){ ?>
                      <div class="tag-group">
                         <span class="icons icon-tag"></span>
                         <div class="tags"><?php echo implode(', ', $blog_row->blog_tags); ?> </div>
                      </div>
                      <?php } ?>

                      <div class="share-group">
                         <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo urlencode(current_url());?>" target="_blank">
                            <img class="svg-js" src="<?php echo base_url(); ?>/theme/img/icons/icon-facebook-2.svg" alt="">
                         </a>
                         <a href="https://twitter.com/intent/tweet?text=<?php echo urlencode("$meta_title ".current_url());?>" target="_blank">
                            <img class="svg-js" src="<?php echo base_url(); ?>/theme/img/icons/icon-twitter.svg" alt="">
                         </a>
                         <a href="javascript:" onclick="copyToClipBoard()">
                            <img class="svg-js link" src="<?php echo base_url(); ?>/theme/img/icons/icon-hyperlink.svg" alt="">
                         </a>
                         <input type="text" class="d-none" id="copy-url" value="<?php echo current_url();?>">
                      </div>
                   </div><!--article-inner-->

                   <div class="article-inner texteditor">
                      <?php echo !empty($blog_row->detail_th) ? htmlspecialchars_decode(output_html($blog_row->detail_th)) : 'ขออภัย, เนื้อหานี้ไ่ม่มีข้อมูลสำหรับภาษาไทย';?>
                   </div>

                   <?php if(!empty($blog_product)) { ?>
                   <div class="article-inner products">
                      <h3 class="py-2">สินค้าที่เกี่ยวข้อง</h3>
                      <div class="product-lists">
                         <div class="row gx-lg-5">
                            <?php foreach($blog_product as $rs) { ?>
                            <div class="col-lg-4 col-md-6">
                               <div class="card-product wow fadeIn">
                                  <a href="<?php echo product_url($rs);?>" class="card-link"></a>
                                  <h3><?php echo output_text($rs->intro);?></h3>
                                  <p class="d-none d-md-block"><?php echo output_text($rs->title);?></p>
                                  <div class="card-photo">
                                     <img src="<?php echo product_thumb_url($rs);?>" alt="<?php echo output_text($rs->title);?>">
                                  </div>
                                  <p class="d-block d-md-none"><?php echo output_text($rs->title);?></p>
                               </div><!--card-product-->
                            </div><!--col-lg-4-->
                            <?php } ?>

                         </div><!--row-->

                      </div><!--product-lists-->
                   </div>
                   <?php } ?>

                   <?php if(!empty($blog_row->detail_th)) { ?>
                   <div class="article-inner texteditor my-md-4 my-2">
                      <?php echo htmlspecialchars_decode(output_html($blog_row->detail2_th));?>
                   </div>
                   <?php } ?>
                </div><!--article-details-->
             </div><!--article-details-->
             <?php } else{echo '<p class="text-center">ไม่พบข้อมูล</p>';}?>
          </div><!--container-->
       </div><!--section-->

       <?php if(!empty($blog_relate)) { ?>
       <div class="section section-article related">
          <div class="container">
             <div class="section-title article">
                <div class="textrow">
                   <h4 class="text-center wow fadeInUp">
                      บทความที่เกี่ยวข้อง
                   </h4>
                </div>
             </div><!--section-title-->

             <div class="news-lists">
                <div class="row">
                   <?php foreach($blog_relate as $rs) { ?>
                      <div class="col-sm-4">
                         <div class="card-news wow fadeIn">
                            <a href="<?php echo $base_url.'article/detail/'.$rs->rewrite_url;?>" class="card-link"></a>
                            <div class="card-photo">
                               <div class="photo" style="background-image: url(<?php echo blog_thumb_url($rs);?>);">
                                  <img src="<?php echo base_url(); ?>/theme/img/thumb/frame-100x90.png" alt="<?php echo output_text($rs->title_th);?>">
                               </div>
                            </div>

                            <div class="card-body">
                               <h3><?php echo output_text($rs->title_th);?></h3>
                            </div>
                            <div class="card-footer">
                               <p><span class="icons icon-tag"></span> <?php if(!empty($rs->blog_tags)){echo implode(', ', $rs->blog_tags);}?></p>
                            </div>
                         </div><!--card-news-->
                      </div><!--col-md-4-->
                   <?php } ?>
                </div><!--row-->

                <div class="p-3"></div>
             </div>
          </div><!--container-->
       </div><!--section-article-->
       <?php } ?>

       <?php include('application/views/front/th/inc/footer.php');?>
    </div><!--page-->

    <?php include('application/views/front/th/inc/body.php');?>
    <script>
    </script>
</body>
</html>
