<!DOCTYPE html>
<html lang="th">
<head>
   <meta charset="utf-8">
   <!--meta http-equiv="X-UA-Compatible" content="IE=edge, chrome=1" /-->
   <!--meta name="viewport" content="width=device-width, initial-scale=1.0"-->
   <meta name="viewport" content="width=device-width, initial-scale = 1.0,
maximum-scale=1.0, user-scalable=no" />
   <meta name="apple-mobile-web-app-capable" content="yes"/>

   <title>Request Quotation | Siam Anchor Fastener Industry</title>
   <meta name="description" content="<?php echo output_str($meta_description);?>">
   <meta name="keywords" content="<?php echo $meta_keywords;?>">
   <meta property="og:article:published_time" content="<?php echo $meta_published_time;?>" />
   <meta property="og:title" content="<?php echo output_str($meta_title);?>" />
   <meta property="og:site_name" content="<?php echo base_url();?>" />
   <meta property="og:description" content="<?php echo output_str($meta_description);?>" />
   <meta property="og:type" content="article" />
   <meta property="og:image" content="<?php echo $meta_image_url;?>" />
   <meta property="og:image:width" content="<?php echo $meta_image_width;?>" />
   <meta property="og:image:height" content="<?php echo $meta_image_height;?>" />
   <meta property="og:url" content="<?php echo $current_url;?>" />
   <link rel="image_src" href="<?php echo $meta_image_url;?>" />

   <?php include('application/views/front/en/inc/head.php');?>
</head>
<body>
  <!-- Google Tag Manager (noscript) -->
<noscript><iframe src=https://www.googletagmanager.com/ns.html?id=GTM-PRZF34K
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
    <div class="preload">
        <span class="loader"></span>
    </div>
    <div class="page">
       <?php include('application/views/front/en/inc/header.php');?>

       <div class="section section-body">
            <div class="container">
                <div class="section-title pt-0">
                    <div class="textrow">
                        <h2 class="title-xl wow fadeInUp">REQUEST QUOTATION</h2>
                    </div>
                </div>

                <div class="box-980 w-lg-100">
                   <form id="form-cart">
                    <div class="row mt-2">
                       <?php $n=0; if(!empty($cart_item)) { foreach($cart_item as $rs) { ?>
                          <div class="col-lg-4 cart-<?php echo output_text($rs->product_item_id);?>">
                             <div class="card-quotation <?php if($n==0){echo 'first';}?> wow fadeIn">
                                <button class="btn card-delete" type="button" data-code="<?php echo $rs->product_item->code;?>" data-id="<?php echo output_text($rs->product_item_id);?>">
                                   <span class="icons icon-delete"></span>
                                </button>
                                <div class="card-photo">
                                   <img src="<?php echo product_thumb_url($rs->product);?>" alt="<?php echo output_text($rs->product->title_en);?>">
                                </div>
                                <div class="card-body">
                                   <h4><?php echo output_text($rs->product->title_en);?></h4>
                                   <ul class="info-lists">
                                      <li><p>* SKU :  <?php echo output_text($rs->product_item->code);?></p></li>
                                      <li class="d-flex">
                                         <p class="me-2">* Quantity (pcs) :</p>
                                         <input type="text" class="form-control" name="qty[<?php echo output_text($rs->product_item_id);?>]" value="<?php echo output_text($rs->qty);?>">
                                      </li>
                                   </ul>
                                </div><!--card-body-->
                             </div><!--card-quotation-->
                          </div><!--col-lg-4-->
                       <?php $n++; } ?>
                          <div class="col-12 d-flex button-viewmore">
                             <a class="btn btn-outline btn-md mx-auto" href="<?php echo base_url('en/home');?>">Add more items</a>
                          </div>
                       <?php }else{ ?>
                          <div class="request-quotation wow fadeIn">
                             <a href="<?php echo base_url('en/home#product');?>" class="btn btn-plus"><span class="icons"></span></a>
                             <h5 class="black">Add products and quantity for quotation request</h5>
                          </div><!--request-quotation-->
                       <?php } ?>
                    </div><!--row-->
                   </form>

                   <?php if(!empty($cart_item)) { ?>
                      <form class="form form-contact" id="form-order">
                         <input type="hidden" class="form-control" name="lang" id="lang" value="en">
                         <table class="table-form">
                            <tr>
                               <th></th>
                               <td><h5>Please fill your contact information</h5></td>
                            </tr>
                            <tr>
                               <th>* Full name :</th>
                               <td><input type="text" class="form-control" name="fullname" id="fullname"></td>
                            </tr>
                            <tr>
                               <th>* TEL No :</th>
                               <td><input type="text" class="form-control" name="phone" id="phone"></td>
                            </tr>
                            <tr>
                               <th>* Email :</th>
                               <td><input type="text" class="form-control" name="email" id="email"></td>
                            </tr>
                            <tr>
                               <th>* Company Name :</th>
                               <td><input type="text" class="form-control" name="company" id="company"></td>
                            </tr>
                            <tr>
                               <th>* Company Address :</th>
                               <td>
                                  <textarea class="form-control h-150" name="address" id="address"></textarea>
                               </td>
                            </tr>
                            <tr>
                               <th></th>
                               <td>
                                  <div class="d-flex align-items-center font-th">
                                     * I’m a:
                                     <div class="form-check">
                                        <input class="form-check-input rounded" type="radio" value="1" name="buyfor" id="check1">
                                        <label class="form-check-label" for="check1">
                                           End-user
                                        </label>
                                     </div>

                                     <div class="form-check">
                                        <input class="form-check-input rounded" type="radio" value="2" name="buyfor" id="check2">
                                        <label class="form-check-label" for="check2">
                                           Retailer/Distributor
                                        </label>
                                     </div>
                                  </div>
                               </td>
                            </tr>
                            <tr>
                               <th></th>
                               <td>
                                  <button class="btn w-200 mt-sm-4 mt-2" type="button" id="btn-order">Submit <span class="spinner-border spinner-border-sm d-none"></span></button>
                               </td>
                            </tr>
                         </table>
                      </form>
                   <?php } ?>
                </div><!--box-980-->

            </div><!--container-->
        </div><!--section-->

       <?php include('application/views/front/en/inc/footer.php');?>
    </div><!--page-->

    <div class="modal modal-alert fade" id="deleteModal">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="icons main">
                        <img class="svg-js delete" src="<?php echo base_url();?>theme/img/icons/icon-delete-white.svg" alt="">
                    </div>
                    <h5>Are you sure you want to delete this item?</h5>
                    <h3 id="show-item-code"></h3>
                   <input type="hidden" id="show-item-id">

                </div><!--modal-body-->

                <div class="modal-button pt-0">
                    <button class="btn btn-outline" type="button" id="btn-confirm-delete-cart">
                        Confirm
                    </button>

                    <button class="btn btn-outline" type="button" data-bs-dismiss="modal">
                        Cancel
                    </button>
                </div>
            </div><!--modal-content-->
        </div><!--modal-dialog-->
    </div><!-- Modal -->

    <?php include('application/views/front/en/inc/body.php');?>
    <script>
        // var $myModal = new bootstrap.Modal('#deleteModal');
        // $myModal.show();
    </script>
</body>
</html>
