<!DOCTYPE html>
<html lang="th">
<head>
   <meta charset="utf-8">
   <!--meta http-equiv="X-UA-Compatible" content="IE=edge, chrome=1" /-->
   <!--meta name="viewport" content="width=device-width, initial-scale=1.0"-->
   <meta name="viewport" content="width=device-width, initial-scale = 1.0,
maximum-scale=1.0, user-scalable=no" />
   <meta name="apple-mobile-web-app-capable" content="yes"/>

   <title>Product | Siam Anchor Fastener Industry</title>
   <meta name="description" content="<?php echo output_str($meta_description);?>">
   <meta name="keywords" content="<?php echo $meta_keywords;?>">
   <meta property="og:article:published_time" content="<?php echo $meta_published_time;?>" />
   <meta property="og:title" content="<?php echo output_str($meta_title);?>" />
   <meta property="og:site_name" content="<?php echo base_url();?>" />
   <meta property="og:description" content="<?php echo output_str($meta_description);?>" />
   <meta property="og:type" content="article" />
   <meta property="og:image" content="<?php echo $meta_image_url;?>" />
   <meta property="og:image:width" content="<?php echo $meta_image_width;?>" />
   <meta property="og:image:height" content="<?php echo $meta_image_height;?>" />
   <meta property="og:url" content="<?php echo $current_url;?>" />
   <link rel="image_src" href="<?php echo $meta_image_url;?>" />

   <?php include('application/views/front/en/inc/head.php');?>
</head>
<body>
  <!-- Google Tag Manager (noscript) -->
<noscript><iframe src=https://www.googletagmanager.com/ns.html?id=GTM-PRZF34K
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
    <div class="preload">
        <span class="loader"></span>
    </div>
    <div class="page">
       <?php include('application/views/front/en/inc/header.php');?>

       <nav class="navbar-breadcrumb">
            <div class="container">
                <ol class="breadcrumb">
                    <li><span>Products&nbsp;&nbsp;/</span></li>
                    <li><span><?php echo output_text($product_category_row->title_en);?></span></li>
                  </ol>
            </div>
        </nav>

       <div class="section section-body">
            <div class="container">
                <div class="section-title pt-0">
                    <div class="textrow">
                       <h2 class="title-xl wow fadeInUp"><?php echo output_text($product_category_row->title_en);?></h2>
                    </div>
                </div>

                <div class="product-lists">
                        <?php
                        if(!empty($product_listing)) {
                           $n=0;
                           foreach($product_listing as $rs) {
                              if($n%6==0) {echo '<div class="row gx-lg-5">';}
                         ?>
                          <div class="col-lg-4 col-md-6">
                             <div class="card-product wow fadeIn">
                                <a href="<?php echo product_url($rs, 'en');?>" class="card-link"></a>
                                <h3><?php echo output_text($rs->intro_en);?></h3>
                                <div class="card-photo">
                                   <img src="<?php echo product_thumb_url($rs);?>" alt="<?php echo output_text($rs->title_en);?>">
                                </div>
                                <p><?php echo output_text($rs->title_en);?></p>
                             </div><!--card-product-->
                          </div><!--col-lg-4-->
                        <?php
                           $n++;
                              if($n%6==0) {echo '</div>';}
                           }
                        } else {
                          echo '<p class="text-center">Not found product</p>';
                        }
                       ?>

                    </div><!--row-->
                </div><!--product-lists-->
            </div>
        </div><!--section-->

       <?php include('application/views/front/en/inc/footer.php');?>
    </div><!--page-->

    <?php include('application/views/front/en/inc/body.php');?>
    <script>
        // var $myModal = new bootstrap.Modal('#informModal');
        // $myModal.show();
    </script>
</body>
</html>
