<!-- Listing -->
<?php include 'application/views/bos/listing-tools.php';?>

<div class="card-body">
   <div class="table-responsive-sm table-listing popup-gallery">
      <form id="formListing">
         <table class="table table-striped table-hover table-bordered">
         <thead>
         <tr>
            <th class="text-center w80">#</th>
            <th>ข้อมูลผู้ขอ</th>
            <th class="text-center">Product Catalog</th>
            <th class="text-center">ลิ้งค์ดาวน์โหลด</th>
            <th class="text-center d-none d-sm-table-cell w100">วันที่ขอข้อมูล</th>
            <th class="text-center w100">เครื่องมือ</th>
         </tr>
         <tr class="row-filter">
            <?php if(!empty($this->is_highlight)){ ?>
               <td class="inline-tools">
                  <button class="btn btn-light btn-sm shadow toolbar-save-order d-none" type="button" title="บันทึก"><i class="las la-save align-middle"></i></button>
               </td>
            <?php }else{ ?>
               <td></td>
            <?php } ?>
            <td><input type="text" id="filter_title" placeholder="พิมพ์คำค้นหา" class="form-control"></td>
            <td class="d-none d-sm-table-cell">
               <select class="form-control" id="filter_product_catalog_id"></select>
            </td>
            <td></td>
            <td class="d-none d-sm-table-cell"></td>
            <td class="inline-tools">
               <button class="btn btn-light btn-sm shadow toolbar-filter-search" type="button" title="ค้นหา"><i class="las la-search las la-pen align-middle"></i></button>
               <button class="btn btn-light btn-sm shadow toolbar-filter-reset" type="button" title="รีเซ็ต"><i class="las la-times las la-pen align-middle"></i></button>
            </td>
         </tr>
         </thead>
         <tbody id="load_rows">
         <!-- Display rows from js -->
         </tbody>
      </table>
      </form>
   </div>
</div>

<?php include('application/views/bos/pager.php');?>

<script type="text/javascript">
   let keyId = 'product_catalog_log_id';

   //Setup modal form
   var modalSize = ''; // modal-sm, none, modal-lg, modal-xl

   //Display row
   request_listing(null);

   function display_rows(data, start, limit)
   {
      let html = '';
      let row = data.rows;
      for(let i=start;i<(data.rows.length<limit ? data.rows.length:limit);i++)
      {

          html += '<tr class="row_no" rowId="'+row[i].product_catalog_log_id+'">';
          html += '<th>'+row[i].product_catalog_log_id+'</th>';
          html += '<td><span class="title">ชื่อ : '+output_text(row[i].fullname)+'</a></span><p class="pb-0">เบอร์โทร : '+row[i].phone+'<br />อีเมล : '+row[i].email+'<br />บริษัท : '+row[i].company+(parseInt(row[i].direct_contact) === 1 ? '<br /><i class="la la-check-circle text-success"><ii> ต้องการให้ติดต่อกลับ' : '')+'</p></td>';
          html += '<td class="text-center">'+output_text(row[i].product_catalog_title)+'</td>';
          html += '<td class="text-center"><a href="'+output_text(row[i].link_download)+'" target="_blank">Download</a></td>';
          html += '<td class="text-center d-none d-sm-table-cell small text-muted">'+row_updated(row[i])+'</td>';
          html += '<td class="inline-tools"><?php echo $button_inline;?></td>';
          html += '</tr>';
      }
      $("#load_rows").html(html);
   }

   //Toolbar : Filters
   $(document).on('click', '.toolbar-filter-search', function(){
       filters = {
           title: $('#filter_title').val(),
           product_catalog_id: $('#filter_product_catalog_id').val(),
       };

       request_listing(filters);
   });
   $(document).on('click', '.toolbar-filter-reset', function(){
       $('#filter_title').val('');
       $('#filter_product_catalog_id').val('');

       request_listing({title: '', product_catalog_id: ''});
   });

   selectList('bos/product_catalog/listing_order', '#filter_product_catalog_id', 'product_catalog_id', null, null, 'title');
   $('#filter_product_catalog_id').select2({theme: 'bootstrap4', width: 'style'});
</script>
