<!-- Listing -->
<?php include 'application/views/bos/listing-tools.php';?>

<div class="card-body">
   <div class="table-responsive-sm table-listing popup-gallery">
      <form id="formListing">
         <table class="table table-striped table-hover table-bordered">
            <thead>
            <tr>
               <th class="text-center w80">ลำดับ</th>
               <th>Name</th>
               <th class="text-center d-none d-sm-table-cell w50">Listing</th>
               <th class="text-center d-none d-sm-table-cell w50">Add</th>
               <th class="text-center d-none d-sm-table-cell w50">Edit</th>
               <th class="text-center d-none d-sm-table-cell w50">Delete</th>
               <th class="text-center d-none d-sm-table-cell w50">View</th>
               <th class="text-center d-none d-sm-table-cell w150">Group</th>
               <th class="text-center d-none d-sm-table-cell w70">สถานะ</th>
               <th class="text-center d-none d-sm-table-cell w80">อัพเดตเมื่อ</th>
               <th class="text-center w100">เครื่องมือ</th>
            </tr>
            <tr class="row-filter">
               <?php if(!empty($this->is_highlight)){ ?>
                  <td class="inline-tools">
                     <button class="btn btn-light btn-sm shadow toolbar-save-order" type="button" title="บันทึก"><i class="las la-save align-middle"></i></button>
                  </td>
               <?php }else{ ?>
                  <td></td>
               <?php } ?>
               <td><input type="text" id="filter_name" placeholder="พิมพ์คำค้นหา" class="form-control"></td>
               <td class="d-none d-sm-table-cell"></td>
               <td class="d-none d-sm-table-cell"></td>
               <td class="d-none d-sm-table-cell"></td>
               <td class="d-none d-sm-table-cell"></td>
               <td class="d-none d-sm-table-cell"></td>
               <td class="text-center d-none d-sm-table-cell"><select class="form-control" id="filter_menu_group"></select></td>
               <td class="w60 d-none d-sm-table-cell">
                  <select class="form-control" id="filter_status">
                     <option value=""></option>
                     <option value="1">ใช้งาน</option>
                     <option value="-1">ระงับ</option>
                  </select>
               </td>
               <td class=" d-none d-sm-table-cell"></td>
               <td class="inline-tools">
                  <button class="btn btn-light btn-sm shadow toolbar-filter-search" type="button" title="ค้นหา"><i class="las la-search las la-pen align-middle"></i></button>
                  <button class="btn btn-light btn-sm shadow toolbar-filter-reset" type="button" title="รีเซ็ต"><i class="las la-times las la-pen align-middle"></i></button>
               </td>
            </tr>
            </thead>
            <tbody id="load_rows">
            <!-- Display rows from js -->
            </tbody>
         </table>
      </form>
   </div>
</div>

<?php include('application/views/bos/pager.php');?>

<script type="text/javascript">
    //Path control
    let keyId = 'menu_id';

    //Setup modal form
    var modalSize = ''; // modal-sm, none, modal-lg, modal-xl

    //Display row
    request_listing(null);

    function display_rows(data, start, limit)
    {
        let html = '';
        let row = data.rows;
        for(let i=start;i<(data.rows.length<limit ? data.rows.length:limit);i++)
        {
            let parent = '';
            if(typeof row[i].parent !== 'undefined')
            {
                parent = row[i].parent;
            }

            html += '<tr class="row_no" rowId="'+row[i].menu_id+'">';
            html += '<th><input type="text" class="form-control form-control-sm text-center" name="orderids['+row[i].menu_id+']" value="'+output_text(row[i].orderid)+'"></th>';
            html += '<td><span class="title">'+row[i].label+'</span>'+(row[i].name ? ' <span class="d-block small text-muted">('+row[i].name+')</span>':'')+(parent ? '<span class="d-block pl-2 mt-2 small text-muted"> &rarr; '+parent+'</span>':'')+'</td>';
            html += '<td class="text-center d-none d-sm-table-cell">'+row_checked(row[i].action_listing)+'</td>';
            html += '<td class="text-center d-none d-sm-table-cell">'+row_checked(row[i].action_add)+'</td>';
            html += '<td class="text-center d-none d-sm-table-cell">'+row_checked(row[i].action_edit)+'</td>';
            html += '<td class="text-center d-none d-sm-table-cell">'+row_checked(row[i].action_delete)+'</td>';
            html += '<td class="text-center d-none d-sm-table-cell">'+row_checked(row[i].action_view)+'</td>';
            html += '<td class="text-center d-none d-sm-table-cell"><span class="badge badge-light-primary">'+output_text(row[i].menu_group)+'</span></td>';
            html += '<td class="text-center d-none d-sm-table-cell">'+row_status(row[i].status)+'</td>';
            html += '<td class="text-center d-none d-sm-table-cell small text-muted">'+row_updated(row[i])+'</td>';
            html += '<td class="inline-tools"><?php echo $button_inline;?></td>';
            html += '</tr>';
        }
        $("#load_rows").html(html);
    }

    //Toolbar : Filters
    $(document).on('click', '.toolbar-filter-search', function(){
        filters = {
            name: $('#filter_name').val(),
            status: $('#filter_status').val(),
            menu_group_id: $('#filter_menu_group').val()
        };

        request_listing(filters);
    });
    $(document).on('click', '.toolbar-filter-reset', function(){
        $('#filter_name').val('');
        $('#filter_status').val('');
        $('#filter_menu_group').val('');

        request_listing({name: '', menu_group_id: ''});
    });

    //Selectbox
    selectList('bos/menu_group/listing', '#filter_menu_group', 'menu_group_id');

    //Form validate
    let validate = {
        title: {
            input: 'text',
        },
        label: {
            input: 'text',
        },
        menu_group_id: {
            input: 'select',
        },
        flag: {
            input: 'text',
            eng: true,
            existing: {
                require: true,
                exclude: '#exclude'
            }
        }
    };

</script>