<!-- Listing -->
<?php include 'application/views/bos/listing-tools.php';?>
<span>
  <strong>การทำงานของลำดับการแสดงผล</strong>
  <br>1) บทความจะแสดงผลโดยเอาบทความล่าสุด (นับจากวันที่สร้างบทความ) มาขึ้นก่อนแบบอัตโนมัติ
  <br>2) หากต้องการเรียงบทความเองให้เปลี่ยนเลข "ลำดับการแสดงผล" ตามความต้องการเช่น 1, 2, 3, … บทความเหล่านั้นจะแสดงผลขึ้นมาตามเลข "ลำดับการแสดงผล" ที่ใส่ไว้
  <br>3) หาก "ไม่ต้องการ" ให้บทความเรียงลำดับ "แบบกำหนดเอง" แล้ว ให้ปรับช่องอันดับเป็น9999
  บทความจะถูกเรียงตามวันที่สร้างบทความเหมือนเดิม<br>
</span>
<div class="card-body">
   <div class="table-responsive-sm table-listing popup-gallery">
      <form id="formListing">
         <table class="table table-striped table-hover table-bordered">
         <thead>
         <tr>
            <th class="text-center w80">ลำดับการ<br>แสดงผล</th>
            <th class="w100 text-center">ภาพ</th>
            <th>ชื่อเรื่อง</th>
            <th class="text-center d-none d-sm-table-cell w100">Preview</th>
            <th class="text-center d-none d-sm-table-cell w100">แสดงหน้าแรก</th>
            <th class="text-center d-none d-sm-table-cell w80">สถานะ</th>
            <th class="text-center d-none d-sm-table-cell w80">อัพเดตเมื่อ</th>
            <th class="text-center w100">เครื่องมือ</th>
         </tr>
         <tr class="row-filter">
            <?php if(!empty($this->is_highlight)){ ?>
               <td class="inline-tools">
                  <button class="btn btn-light btn-sm toolbar-save-order d-none" type="button" title="บันทึก"><i class="las la-save align-middle"></i></button>
               </td>
            <?php }else{ ?>
               <td></td>
            <?php } ?>
            <td></td>
            <td><input type="text" id="filter_title_th" placeholder="พิมพ์คำค้นหา" class="form-control"></td>
            <td class="d-none d-sm-table-cell"></td>
            <td class="d-none d-sm-table-cell"></td>
            <td class="d-none d-sm-table-cell">
               <select class="form-control" id="filter_status">
                  <option value=""></option>
                  <option value="1">ใช้งาน</option>
                  <option value="-1">ระงับ</option>
               </select>
            </td>
            <td class="d-none d-sm-table-cell"></td>
            <td class="inline-tools">
               <button class="btn btn-light btn-sm shadow toolbar-filter-search" type="button" title="ค้นหา"><i class="las la-search las la-pen align-middle"></i></button>
               <button class="btn btn-light btn-sm shadow toolbar-filter-reset" type="button" title="รีเซ็ต"><i class="las la-times las la-pen align-middle"></i></button>
            </td>
         </tr>
         </thead>
         <tbody id="load_rows">
         <!-- Display rows from js -->
         </tbody>
      </table>
      </form>
   </div>
</div>

<?php include('application/views/bos/pager.php');?>

<script type="text/javascript">
   let keyId = 'blog_id';

   //Setup modal form
   var modalSize = 'modal-xl'; // modal-sm, none, modal-lg, modal-xl

   //Display row
   request_listing_order(null);

   function display_rows(data, start, limit)
   {
      let html = '';
      let row = data.rows;
      for(let i=start;i<(data.rows.length<limit ? data.rows.length:limit);i++)
      {

          html += '<tr class="row_no" rowId="'+row[i].blog_id+'">';
          html += '<th><input type="text" min="0" class="form-control form-control-sm text-center form-reorder" name="orderids['+row[i].blog_id+']" data-id="'+row[i].blog_id+'" value="'+output_text(row[i].orderid)+'"></th>';
          html += '<th class="text-center"><a href="'+row[i].thumb_url+'" class="popup-item"><img src="'+row[i].thumb_url+'" width="100%"></a></th>';
          html += '<td><span class="title"><a href="<?php echo base_url();?>article/detail/'+row[i].rewrite_url+'?preview=1" target="_blank">'+output_text(row[i].title_th)+'</a></span></td>';
          html += '<td class="text-center d-none d-sm-table-cell"><a href="<?php echo base_url();?>article/detail/'+row[i].rewrite_url+'?preview=1" class="btn btn-sm btn-light" target="_blank">Preview</a></td>';
          html += '<td class="text-center d-none d-sm-table-cell">'+row_checked(row[i].show_home)+'</td>';
          html += '<td class="text-center d-none d-sm-table-cell">'+row_status(row[i].status)+'</td>';
          html += '<td class="text-center d-none d-sm-table-cell small text-muted">'+row_updated(row[i])+'</td>';
          html += '<td class="inline-tools"><?php echo $button_inline;?></td>';
          html += '</tr>';
      }
      $("#load_rows").html(html);
   }

   //Toolbar : Filters
   $(document).on('click', '.toolbar-filter-search', function(){
       filters = {
           title_th: $('#filter_title_th').val(),
           title_en: $('#filter_title_en').val(),
           status: $('#filter_status').val()
       };

       request_listing(filters);
   });
   $(document).on('click', '.toolbar-filter-reset', function(){
       $('#filter_title_th').val('');
       $('#filter_title_en').val('');
       $('#filter_status').val('');

       request_listing({title_th: '', title_en: '', status: ''});
   });

   //Form validate
   let validate = {
       title_th: {
           input: 'text',
       },
       rewrite_url: {
           input: 'text',
           existing: {
               require: true,
               exclude: '#exclude'
           }
       },
   };
</script>
