<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Upload_model extends CI_Model
{
   public function __construct()
   {
      parent::__construct();
      $this->load->library('image_lib');
   }

   private function _do_resize($source_image, $new_image, $width, $height = NULL, $master_dim='width', $quality=UPLOAD_QUALITY)
   {
      if(file_exists($source_image))
      {
         list($source_width) = getimagesize($source_image);
         if($source_width > $width)
         {
            $config['source_image']    = $source_image;
            $config['new_image']       = $new_image;
            $config['width']           = $width;
            if(!empty($height) && $height > 0)
            {
            $config['height']          = $height;
            }
            $config['quality']         = $quality;
            $config['image_library']   = 'gd2';
            $config['master_dim']      = $master_dim;
            $this->image_lib->initialize($config);
            $this->image_lib->resize();
            $this->image_lib->clear();
         }
      }
   }

   private function _upload($file_name, $tmp_name, $keyId, $config)
   {
      $exp = explode('.', $file_name);
      $ext = strtolower($exp[count($exp)-1]);

      $source = $keyId.".".$ext;

      foreach($config as $item)
      {
         $folder = $item[0] ?? NULL;
         $width = $item[1] ?? NULL;
         $height = $item[2] ?? NULL;
         $master_dim = $item[3] ?? NULL;
         $quality = !empty($item[4]) ? $item[4]:UPLOAD_QUALITY;

         $dest = $folder.$source;

         if(!file_exists($folder))
         {
            mkdir($folder, 0755, true);
         }

         if(file_exists($folder))
         { 
            if(copy($tmp_name, $dest))
            {
               if($width > 0)
               {
                  $this->_do_resize($dest, $dest, $width, $height, $master_dim, $quality);
               }
            }
         }
      }

      return $ext;
   }

   public function upload_cover($keyId, $config)
   {
      $tmp_name = $_FILES['cover']['tmp_name'];
      $file_name = $_FILES['cover']['name'];
      return $this->_upload($file_name, $tmp_name, $keyId, $config);
   }

   public function upload_thumb($keyId, $config)
   {
      $tmp_name = $_FILES['thumb']['tmp_name'];
      $file_name = $_FILES['thumb']['name'];
      return $this->_upload($file_name, $tmp_name, $keyId, $config);
   }

   public function upload_special($keyId, $config)
   {
      $tmp_name = $_FILES['special']['tmp_name'];
      $file_name = $_FILES['special']['name'];
      return $this->_upload($file_name, $tmp_name, $keyId, $config);
   }

   public function upload_pdf($keyId, $config)
   {
      $tmp_name = $_FILES['pdf']['tmp_name'];
      $file_name = $_FILES['pdf']['name'];
      return $this->_upload($file_name, $tmp_name, $keyId, $config);
   }

   public function upload_image($file_name, $tmp_name, $keyId, $config)
   {
      return $this->_upload($file_name, $tmp_name, $keyId, $config);
   }

   public function upload_file($keyId, $file_name, $config)
   {
      $tmp_name = $_FILES[$file_name]['tmp_name'];
      $file_name = $_FILES[$file_name]['name'];
      return $this->_upload($file_name, $tmp_name, $keyId, $config);
   }

   public function upload_gallery($keyId, $config, $model, $parent_key, $data)
   {
      $orderid = $this->input->post('gallery_orderid');
      $title = $this->input->post('gallery_title');
      $alt = $this->input->post('gallery_alt'); 
      $this->load->model($model, 'gmodel');
      for($i=0;$i<count($_FILES['gallery']['name']);$i++)
      {
         $tmp_name = $_FILES['gallery']['tmp_name'][$i];
         $file_name = $_FILES['gallery']['name'][$i];
         if(!empty($file_name))
         {
            $exp = explode('.', $file_name);
            $ext = strtolower($exp[count($exp)-1]);
            if(!empty($ext))
            {
               if(!in_array($ext, UPLOAD_EXTENSION))exit('Not allow file extension ('.$ext.')');

               $row = new stdClass();
               $row->$parent_key = $keyId;
               $row->orderid = !empty($orderid[$i]) ? input_to_sql($orderid[$i]) : 0;
               $row->cover_ext = $ext;
               $row->cover_title = !empty($title[$i]) ? input_to_sql($title[$i]) : NULL;
               $row->cover_alt = !empty($alt[$i]) ? input_to_sql($alt[$i]) : NULL; 
               $row->highlight = GLOBAL_STATUS_ENABLED;
               $row->status = GLOBAL_STATUS_ENABLED;
               $row->created_by = $data->created_by;
               $galleryId = $this->gmodel->create($row);

               $this->_upload($file_name, $tmp_name, $galleryId, $config);
            }
         }
      }
   }

   public function upload_files($keyId, $config, $model, $parent_key, $data)
   {
      $orderid = $this->input->post('file_orderid');
      $title = $this->input->post('file_title');
      $alt = $this->input->post('file_alt');

      $this->load->model($model, 'fmodel');
      for($i=0;$i<count($_FILES['file']['name']);$i++)
      {
         $tmp_name = $_FILES['file']['tmp_name'][$i];
         $file_name = $_FILES['file']['name'][$i];
         if(!empty($file_name))
         {
            $exp = explode('.', $file_name);
            $ext = strtolower($exp[count($exp)-1]);
            if(!empty($ext))
            {
               if(!in_array($ext, UPLOAD_FILE_EXTENSION))exit('Not allow file extension ('.$ext.')');

               $row = new stdClass();
               $row->$parent_key = $keyId;
               $row->orderid = !empty($orderid[$i]) ? input_to_sql($orderid[$i]) : 0;
               $row->file_ext = $ext;
               $row->file_title = !empty($title[$i]) ? input_to_sql($title[$i]) : NULL;
               $row->file_alt = !empty($alt[$i]) ? input_to_sql($alt[$i]) : NULL;
               $row->highlight = GLOBAL_STATUS_ENABLED;
               $row->status = GLOBAL_STATUS_ENABLED;
               $row->created_by = $data->created_by;
               $fileId = $this->fmodel->create($row);

               $this->_upload($file_name, $tmp_name, $fileId, $config);
            }
         }
      }
   }
}