<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Blog_tag_model extends Frontend_Model
{
   public function __construct()
   {
      parent::__construct();

      $this->table_name = 'cms_blog_tag';
      $this->primary_key = 'blog_tag_id';
      $this->set_ref = TRUE;
   }

   protected function listing_filters($filters = NULL)
   {
      if(!empty($filters))
      {
         if(!empty($filters['blog_id']))
         {
            $this->db->where('n.blog_id', input_to_sql($filters['blog_id']));
         }
      }
   }

   /**
    * Listing all record
    *
    * @return mixed
    */
   public function listing($filters = NULL, $per_page = NULL, $offset = NULL)
   {
      if(!empty($filters['blog_id']))
      {
         $this->db->like('n.blog_id', input_to_sql($filters['blog_id']));
      }

      if(!empty($filters['blog_category_ids']))
      {
         $this->db->where_in('n.blog_category_id', $filters['blog_category_ids']);
      }

      $this->db->distinct();
      $this->db->select('n.*, c.title as blog_category, c.title_en as blog_category_en');
      $this->db->order_by('c.orderid', 'ASC');
      $this->db->order_by('n.orderid', 'ASC');
      $this->db->order_by('n.'.$this->primary_key, 'DESC');
      $this->db->join('cms_blog_category c', 'c.blog_category_id=n.blog_category_id', 'LEFT');
      if(!empty($per_page) ) {
         $this->db->limit($per_page, !empty($offset) ? $offset : 0);
      }
      $result = $this->db->get($this->table_name.' n')->result();
      //echo $this->db->last_query();exit;

      return $result;
   }
}