<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Blog_product_model extends Frontend_Model
{
   public function __construct()
   {
      parent::__construct();

      $this->table_name = 'cms_blog_product';
      $this->primary_key = 'blog_product_id';
      $this->set_ref = TRUE;
   }

   /**
    * Listing all record
    *
    * @return mixed
    */
   public function listing($filters = NULL, $per_page = NULL, $offset = NULL)
   {
      if(!empty($filters['blog_id']))
      {
         $this->db->where('n.blog_id', input_to_sql($filters['blog_id']));
      }

      $this->db->distinct();
      $this->db->select('p.*');
      $this->db->order_by('n.orderid', 'ASC');
      $this->db->order_by('n.'.$this->primary_key, 'DESC');
      $this->db->join('cms_product p', 'p.product_id=n.product_id', 'LEFT');
      if(!empty($per_page) ) {
         $this->db->limit($per_page, !empty($offset) ? $offset : 0);
      }
      $result = $this->db->get($this->table_name.' n')->result();
      //echo $this->db->last_query();exit;

      return $result;
   }
}