<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Blog_model extends Frontend_Model
{
   public function __construct()
   {
      parent::__construct();

      $this->table_name = 'cms_blog';
      $this->primary_key = 'blog_id';
      $this->set_ref = TRUE;
   }

   /**
    * Read a record by rewrite_url
    *
    * @param $id
    * @return mixed
    */
   public function read_url($rewrite_url, $filters = NULL)
   {
      $this->db->select('n.*');
      $this->db->where('n.rewrite_url', input_to_sql(urldecode($rewrite_url)));
      if(empty($this->input->get('preview'))) {
         $this->db->where('n.status', GLOBAL_STATUS_ENABLED);
      }

      $this->read_filters($filters);

      $row = $this->db->get($this->table_name.' n')->row();
      return $row;
   }

   /**
    * Listing all record
    *
    * @return mixed
    */
   public function listing_order($filters = NULL, $per_page = NULL, $offset = NULL)
   {
      $this->listing_filters($filters);

      $this->db->distinct();
      $this->db->select('n.*');
      $this->db->join('cms_blog_tag t', 't.blog_id=n.blog_id', 'LEFT');
      if(!empty($filters['blog_category_ids'])) {
         $this->db->where_in('t.blog_category_id', $filters['blog_category_ids']);
      }
      if($filters['lang'] == 'en') {
         $this->db->where('n.title_en IS NOT NULL');
      }
      $this->db->where('n.status', GLOBAL_STATUS_ENABLED);
      $this->db->order_by('n.highlight', 'DESC');
      $this->db->order_by('n.orderid', 'ASC');
      $this->db->order_by('n.'.$this->primary_key, 'DESC');
      if(!empty($per_page) ) {
         $this->db->limit($per_page, !empty($offset) ? $offset : 0);
      }
      $result = $this->db->get($this->table_name.' n')->result();
      //echo $this->db->last_query();
      return $result;
   }

   public function listing_home($limit = 3, $filters = [])
   {
      $this->db->distinct();
      $this->db->select('n.*');
      $this->db->where('n.show_home', GLOBAL_STATUS_ENABLED);
      $this->db->where('n.status', GLOBAL_STATUS_ENABLED);
      if($filters['lang'] == 'en') {
         $this->db->where('n.title_en IS NOT NULL');
      }
      $this->db->order_by('n.highlight', 'DESC');
      $this->db->order_by('n.orderid', 'ASC');
      $this->db->limit($limit, 0);
      $result = $this->db->get($this->table_name.' n')->result();
      //echo $this->db->last_query();
      return $result;
   }

   /**
    * Listing all record
    *
    * @return mixed
    */
   public function listing_relate($ids)
   {
      $this->db->distinct();
      $this->db->select('n.*');
      $this->db->where('n.status', GLOBAL_STATUS_ENABLED);
      $this->db->where('n.status', GLOBAL_STATUS_ENABLED);
      $this->db->order_by('n.highlight', 'DESC');
      $this->db->order_by('n.orderid', 'ASC');
      $this->db->order_by('n.'.$this->primary_key, 'DESC');
      if(!empty($per_page) ) {
         $this->db->limit($per_page, !empty($offset) ? $offset : 0);
      }
      $result = $this->db->get($this->table_name.' n')->result();
      //echo $this->db->last_query();
      return $result;
   }
}