<?php defined('BASEPATH') OR exit('No direct script access allowed');

class User_role_model extends MY_Model
{
   public function __construct()
   {
      parent::__construct();

      $this->table_name = 'cms_user_role';
      $this->primary_key = 'role_id';
      $this->set_ref = TRUE;
   }

   public function listing($filters = NULL, $per_page = NULL, $offset = NULL)
   {
      $this->listing_filters($filters);

      if(!empty($filters['login_user_role_id']) && $filters['login_user_role_id'] != 1)
      {
         $this->db->where('n.role_id !=', 1);
      }

      $this->db->distinct();
      $this->db->select('n.*, u.firstname as admin, COUNT(a.user_id) as count_item');
      $this->db->group_by('n.role_id');
      $this->db->order_by('n.'.$this->primary_key, 'DESC');
      $this->db->join('cms_users a', 'a.role_id=n.role_id', 'LEFT');
      $this->db->join('cms_users u', 'u.user_id=n.created_by', 'LEFT');
      $result = $this->db->get($this->table_name.' n')->result();

      return  $result;
   }
}