<?php defined('BASEPATH') OR exit('No direct script access allowed');

class User_permission_model extends MY_Model
{
   public function __construct()
   {
      parent::__construct();

      $this->table_name = 'cms_user_permission';
      $this->primary_key = 'permission_id';
   }

   public function list_by_role($role_id)
   {
      $this->db->distinct();
      $this->db->where('role_id', $role_id);
      $this->db->order_by('menu_group_id', 'ASC');
      $this->db->order_by('menu_id', 'ASC');
      $result = $this->db->get($this->table_name)->result();

      return $result;
   }

   public function list_by_menu()
   {
      $this->db->distinct();
      $this->db->select('n.menu_id, n.menu_group_id, n.role_id');
      $this->db->where('g.status', GLOBAL_STATUS_ENABLED);
      $this->db->order_by('g.orderid', 'ASC');
      $this->db->order_by('m.orderid', 'ASC');
      $this->db->join('cms_menu_group g', 'g.menu_group_id=n.menu_group_id');
      $this->db->join('cms_menu m', 'm.menu_id=n.menu_id');
      $result = $this->db->get($this->table_name.' n')->result();

      return $result;
   }

   public function set_permission($post)
   {
      if(isset($post) && !empty($post))
      {
         foreach($post as $key => $data)
         {
            if($key === 'perms')
            {
               if(!empty($data))
               {
                  $role_id = $this->input->post('role_id');
                  $this->delete_by_role($role_id);

                  foreach($data as $menu_group_id => $menus)
                  {
                     $row = new stdClass();
                     $row->menu_group_id = $menu_group_id;
                     $row->role_id = $role_id;

                     foreach($menus as $menu_id => $fields)
                     {
                        $row->menu_id = $menu_id;
                        //foreach($fields as $field => $data)
                        //{
                        $row->action_listing = !empty($fields['action_listing']) ? 1:0;
                        $row->action_view = !empty($fields['action_view']) ? 1:0;
                        $row->action_add = !empty($fields['action_add']) ? 1:0;
                        $row->action_edit = !empty($fields['action_edit']) ? 1:0;
                        $row->action_delete = !empty($fields['action_delete']) ? 1:0;
                        $row->action_publish = !empty($fields['action_publish']) ? 1:0;
                        $row->action_highlight = !empty($fields['action_highlight']) ? 1:0;
                        //}
                        $this->db->insert($this->table_name, $row);
                     }
                     unset($row);
                  }
               }
            }
         }
      }
   }

   private function delete_by_role($id)
   {
      if(isset($id) && !empty($id))
      {
         $this->db->where('role_id', $id);
         $this->db->delete($this->table_name);
      }
   }
}