<?php defined('BASEPATH') OR exit('No direct script access allowed');

class User_logs_model extends MY_Model
{

   public function __construct()
   {
      parent::__construct();

      $this->table_name = 'cms_user_logs';
      $this->primary_key = 'log_id';
   }

   public function listing($filters = NULL, $per_page = NULL, $offset = NULL)
   {
      $this->db->select('*');
      $this->db->order_by('log_id', 'DESC');

      if(!empty($filters))
      {
         if(!empty($filters['email']))
         {
            $this->db->like('email', input_to_sql($filters['email']));
         }
         if(!empty($filters['user_id']))
         {
            $this->db->where('user_id', input_to_sql($filters['user_id']));
         }
         if(!empty($filters['created_ip']))
         {
            $this->db->like('created_ip', input_to_sql($filters['created_ip']));
         }
      }
      if(!empty($per_page) ) {
         $this->db->limit($per_page, !empty($offset) ? $offset : 0);
      }

      $result = $this->db->get($this->table_name)->result();
      return $result;
   }

   public function create_Log(&$data)
   {
      //component, action, status
      $this->db->set('user_id', $this->user_id);
      $this->db->set('email', $this->user_email);
      $this->db->set('created_at', datetime_now());
      $this->db->set('created_ip', $this->input->ip_address());

      $this->db->insert($this->table_name, $data);
      $last_id = $this->db->insert_id();

      return $last_id;
   }

   protected function delete_filters($filters = NULL)
   {
      if(!empty($filters))
      {
         if($filters['delete_more_id'])
         {
            $this->db->or_where($this->primary_key.' <=', $filters['delete_more_id']);
         }
      }
   }
}