<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Product_model extends MY_Model
{
   public function __construct()
   {
      parent::__construct();

      $this->table_name = 'cms_product';
      $this->primary_key = 'product_id';
      $this->set_ref = TRUE;
   }

   /**
    * Listing all record
    *
    * @return mixed
    */
   public function listing($filters = NULL, $per_page = NULL, $offset = NULL)
   {
      if(!empty($filters['title']))
      {
         $this->db->like('n.title', input_to_sql($filters['title']));
      }
      if(!empty($filters['title_en']))
      {
         $this->db->like('n.title_en', input_to_sql($filters['title_en']));
      }
      if(!empty($filters['product_category_id']))
      {
         $this->db->where('n.product_category_id', input_to_sql($filters['product_category_id']));
      }
      if(!empty($filters['status']))
      {
         $this->db->where('n.status', $filters['status'] == 1 ? 1:0);
      }

      $this->db->distinct();
      $this->db->select('n.*, u.firstname as admin, c.title as product_category, c.rewrite_url as category_rewrite_url');
      //$this->db->order_by('c.orderid', 'ASC');
      $this->db->order_by('n.orderid', 'ASC');
      $this->db->order_by('n.'.$this->primary_key, 'DESC');
      $this->db->join('cms_users u', 'u.user_id=n.created_by', 'LEFT');
      $this->db->join('cms_product_category c', 'c.product_category_id=n.product_category_id', 'LEFT');
      if(!empty($per_page) ) {
         $this->db->limit($per_page, !empty($offset) ? $offset : 0);
      }
      $result = $this->db->get($this->table_name.' n')->result();

      return $result;
   }
}