<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Product_item_column_model extends MY_Model
{
   public function __construct()
   {
      parent::__construct();

      $this->table_name = 'cms_product_item_column';
      $this->primary_key = 'product_item_column_id';
      $this->set_ref = TRUE;
   }

   protected function listing_filters($filters = NULL)
   {
      if(!empty($filters))
      {
         if(!empty($filters['product_id']))
         {
            $this->db->where('n.product_id', input_to_sql($filters['product_id']));
         }
      }
   }

   public function read_by_parent($product_id)
   {
      $this->db->select('n.*');
      $this->db->where('n.product_id', input_to_sql($product_id));
      $row = $this->db->get($this->table_name.' n')->row();
      return $row;
   }

}