<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Product_gallery_model extends MY_Model
{
   public function __construct()
   {
      parent::__construct();

      $this->table_name = 'cms_product_gallery';
      $this->primary_key = 'gallery_id';
      $this->set_ref = TRUE;
   }


   /**
    * Re-order rows
    */
   public function reorder_change($new_value, $current_id, $data)
   {
      $product_id = $this->input->post('product_id');

      if($new_value == 1) {
         $new_data = new stdClass();
         $new_data->orderid = 1;
         $this->create_ref($data->created_by,$this->set_ref);
         $this->db->where($this->primary_key, $current_id);
         $this->db->update($this->table_name, $new_data);

         $this->db->where_not_in($this->primary_key, [$current_id]);
         $this->db->where('product_id', $product_id);
         $this->db->order_by("orderid", "ASC");
         $result = $this->db->get($this->table_name)->result();
         if(!empty($result))
         {
            $n=2;
            foreach($result as $rs)
            {
               $key = $this->primary_key;
               $id = $rs->$key;
               $new_data = new stdClass();
               $new_data->orderid = $n;
               $this->create_ref($data->created_by,$this->set_ref);
               $this->db->where($this->primary_key, $id);
               $this->db->update($this->table_name, $new_data); 
               $n++;
            }
         }
      }
      else {

         $this->db->select_max("orderid");
         $row = $this->db->get($this->table_name)->row();
         $max_orderid = $row->orderid;

         $this->db->select("orderid");
         $this->db->where($this->primary_key, $current_id);
         $row = $this->db->get($this->table_name)->row();
         $org_orderid = $row->orderid;

         if($new_value >= $max_orderid) {
            $new_data = new stdClass();
            $new_data->orderid = $max_orderid;
            $this->create_ref($data->created_by,$this->set_ref);
            $this->db->where($this->primary_key, $current_id);
            $this->db->update($this->table_name, $new_data);

            $this->db->where_not_in($this->primary_key, [$current_id]);
            $this->db->where('product_id', $product_id);
            $this->db->order_by("orderid", "ASC");
            $result = $this->db->get($this->table_name)->result();
            if(!empty($result))
            {
               $n=count($result);
               foreach($result as $rs)
               {
                  $key = $this->primary_key;
                  $id = $rs->$key;
                  $new_data = new stdClass();
                  $new_data->orderid = $n;
                  $this->create_ref($data->created_by,$this->set_ref);
                  $this->db->where($this->primary_key, $id);
                  $this->db->update($this->table_name, $new_data);
                  $n--;
               }
            }
         }
         else if($new_value > $org_orderid) {
            $this->db->where("orderid <=", $new_value);
            $this->db->where("orderid >=", $org_orderid);
            $this->db->where('product_id', $product_id);
            $this->db->order_by("orderid", "ASC");
            $result = $this->db->get($this->table_name)->result();
            if(!empty($result))
            {
               foreach($result as $rs)
               {
                  $key = $this->primary_key;
                  $id = $rs->$key;
                  $new_data = new stdClass();
                  $new_data->orderid = $rs->orderid - 1;
                  $this->create_ref($data->created_by,$this->set_ref);
                  $this->db->where($this->primary_key, $id);
                  $this->db->update($this->table_name, $new_data);
               }
            }

            $new_data = new stdClass();
            $new_data->orderid = $new_value;
            $this->create_ref($data->created_by,$this->set_ref);
            $this->db->where($this->primary_key, $current_id);
            $this->db->update($this->table_name, $new_data);
         }
         else if($new_value < $org_orderid) {
            $this->db->where("orderid >=", $new_value);
            $this->db->where("orderid <", $org_orderid);
            $this->db->where('product_id', $product_id);
            $this->db->order_by("orderid", "ASC");
            $result = $this->db->get($this->table_name)->result();
            if(!empty($result))
            {
               foreach($result as $rs)
               {
                  $key = $this->primary_key;
                  $id = $rs->$key;
                  $new_data = new stdClass();
                  $new_data->orderid = $rs->orderid + 1;
                  $this->create_ref($data->created_by,$this->set_ref);
                  $this->db->where($this->primary_key, $id);
                  $this->db->update($this->table_name, $new_data);
               }
            }

            $new_data = new stdClass();
            $new_data->orderid = $new_value;
            $this->create_ref($data->created_by,$this->set_ref);
            $this->db->where($this->primary_key, $current_id);
            $this->db->update($this->table_name, $new_data);
         }
      }
   }
}