<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Product_catalog_log_model extends MY_Model
{
   public function __construct()
   {
      parent::__construct();

      $this->table_name = 'cms_product_catalog_log';
      $this->primary_key = 'product_catalog_log_id';
      $this->set_ref = TRUE;
   }
   protected function listing_filters($filters = NULL)
   {
      if(!empty($filters))
      {
         if(!empty($filters['title']))
         {
            $title = input_to_sql($filters['title']);
            $this->db->where("(n.fullname LIKE '%$title%' || n.phone LIKE '%$title%' || n.email LIKE '%$title%' || n.company LIKE '%$title%')");
         }
         if(!empty($filters['product_catalog_id']))
         {
            $this->db->where('n.product_catalog_id', input_to_sql($filters['product_catalog_id']));
         }
      }
   }

   /**
    * Listing all record
    *
    * @return mixed
    */
   public function listing($filters = NULL, $per_page = NULL, $offset = NULL)
   {
      $this->listing_filters($filters);

      $this->db->distinct();
      $this->db->select('n.*, c.title as product_catalog_title');
      $this->db->order_by('n.'.$this->primary_key, 'DESC');
      $this->db->join('cms_product_catalog c', 'c.product_catalog_id=n.product_catalog_id', 'LEFT');
      if(!empty($per_page) ) {
         $this->db->limit($per_page, !empty($offset) ? $offset : 0);
      }
      $result = $this->db->get($this->table_name.' n')->result();
      return $result;
   }
}