<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Menu_group_model extends MY_Model
{
   public function __construct()
   {
      parent::__construct();

      $this->table_name = 'cms_menu_group';
      $this->primary_key = 'menu_group_id';
      $this->set_ref = TRUE;
   }

   /**
    *
    * Listing for permission
    *
    * @return mixed
    */
   public function listing($filters = NULL, $per_page = NULL, $offset = NULL)
   {
      $this->db->distinct();
      $this->db->where('status', GLOBAL_STATUS_ENABLED);
      $this->db->order_by('orderid', 'ASC');
      $this->db->order_by('menu_group_id', 'DESC');
      $result = $this->db->get($this->table_name)->result();

      return $result;
   }

   public function lists($filters = NULL)
   {
      $this->db->select('p.menu_group_id, p.title as name, p.flag, p.highlight, p.status, p.orderid, p.updated_at, p.created_by, u.firstname as admin, p.icon, COUNT(a.menu_id) as count_item');
      $this->db->group_by('p.menu_group_id');
      $this->db->order_by('p.orderid', 'ASC');
      $this->db->order_by('p.title', 'ASC');

      if(!empty($filters))
      {
         if(!empty($filters['name']))
         {
            $this->db->like('p.title', input_to_sql($filters['name']));
         }
         if(!empty($filters['status']))
         {
            $this->db->where('p.status', $filters['status'] == 1 ? 1:0);
         }
      }

      $this->db->join('cms_menu a', 'a.menu_group_id=p.menu_group_id', 'LEFT');
      $this->db->join('cms_users u', 'u.user_id=p.created_by', 'LEFT');
      $result = $this->db->get($this->table_name.' p')->result();
      return $result;
   }

   /**
    *
    * View
    *
    * @return mixed
    */
   public function read($id, $filters = NULL)
   {
      $this->db->select('p.*, u.firstname as admin');
      $this->db->where('p.'.$this->primary_key, (int)$id);
      $this->db->join('cms_users u', 'u.user_id=p.created_by', 'LEFT');
      $result = $this->db->get($this->table_name.' p')->row();
      return $result;
   }
}