<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Line_notify
{
   private $api_url = 'https://notify-api.line.me/api/notify';
   private $token = NULL;
   private $order_template = 'แจ้งเตือนการสั่งสินค้า
---------------------
เลขที่สั่งซื้อ: #order_no
ชื่อลูกค้า: #customer
เบอร์โทร: #phone
ยอดสั่งซื้อ : #amount
---------------------
รายละเอียด: https://www.flowcart.co/print_order/#order_no';

   function __construct()
   {
      $this->CI =& get_instance();

      //$this->CI->load->model('shared/orders_shared_model');

      if(empty(SETTING_API_LINE_NOTIFY_TOKEN))
      {
         return false;
      }

      $this->token = SETTING_API_LINE_NOTIFY_TOKEN;
   }

   public function create_msg($order_id)
   {
      //$row = $this->CI->orders_shared_model->read($order_id);
      if(!empty($row))
      {
         $tpl = $this->order_template;
         $tpl = str_replace('#order_no', $row->order_no, $tpl);
         $tpl = str_replace('#customer', $row->customer_name, $tpl);
         $tpl = str_replace('#phone', $row->customer_phone, $tpl);
         $tpl = str_replace('#amount', $row->total_amount, $tpl);
         if($row->project_type == ORDER_TYPE_QUOTATION_ORDER)
         {
            $tpl = str_replace('/po', '/qt', $tpl);
         }
         $this->send($tpl);
      }
   }

   public function send($message)
   {
      ini_set('display_errors', 1);
      ini_set('display_startup_errors', 1);
      error_reporting(E_ALL);
      date_default_timezone_set("Asia/Bangkok");

      $ch = curl_init();
      curl_setopt( $ch, CURLOPT_URL, $this->api_url);
      curl_setopt( $ch, CURLOPT_SSL_VERIFYHOST, 0);
      curl_setopt( $ch, CURLOPT_SSL_VERIFYPEER, 0);
      curl_setopt( $ch, CURLOPT_POST, 1);
      curl_setopt( $ch, CURLOPT_POSTFIELDS, "message=".$message);
      $headers = array( 'Content-type: application/x-www-form-urlencoded', 'Authorization: Bearer '.$this->token.'', );
      curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
      curl_setopt( $ch, CURLOPT_RETURNTRANSFER, 1);
      $result = curl_exec( $ch );

      //Result error
      if(curl_error($ch))
      {
         //echo 'error:' . curl_error($ch);
         return curl_error($ch);
      }
      else {
         $result_ = json_decode($result, true);
         return $result_['message'];
         //echo "status : ".$result_['status']."<br>";
         //echo "message : ". $result_['message'];
      }
      curl_close($ch);
   }

}