<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require APPPATH.'/third_party/PHPMailer/class.phpmailer.php';

class Email_sender
{
   private $CI = NULL;
   private $smtp_hostname = NULL;
   private $smtp_username = NULL;
   private $smtp_password = NULL;
   private $smtp_port = NULL;
   private $smtp_secure = NULL;
   private $smtp_sender_name = NULL;
   private $smtp_sender_email = NULL;
   private $smtp_reply_email = NULL;
   private $smtp_reply_name = NULL;

   function __construct()
   {
      $this->CI =& get_instance();

      $this->smtp_hostname = SETTING_SMTP_HOSTNAME;
      $this->smtp_username = SETTING_SMTP_USERNAME;
      $this->smtp_password = SETTING_SMTP_PASSWORD;
      $this->smtp_port = SETTING_SMTP_PORT;
      $this->smtp_secure = SETTING_SMTP_SECURE;
      $this->smtp_sender_name = SETTING_SMTP_SENDER_NAME;
      $this->smtp_sender_email = SETTING_SMTP_SENDER_EMAIL;
      $this->smtp_reply_email = SETTING_SMTP_REPLY_EMAIL;
      $this->smtp_reply_name = SETTING_SMTP_REPLY_NAME;
   }

   public function send($to_addresses = [], $subject, $message, $cc_to = '', $attachment_path = '' )
   {
      if(!empty($this->smtp_hostname) && !empty($this->smtp_port) && !empty($to_addresses) && !empty($subject) && !empty($message))
      {
         $mail = new PHPMailer();

         $mail->Host = $this->smtp_hostname;
         $mail->Port = $this->smtp_port;
         if(!empty($this->smtp_username) && !empty($this->smtp_password))
         {
            $mail->Username = $this->smtp_username;
            $mail->Password = $this->smtp_password;
         }
         $mail->CharSet = "utf-8";
         $mail->SMTPKeepAlive = true;
         $mail->Mailer = "smtp";
         $mail->IsSMTP();
         $mail->IsHTML(true);
         $mail->SMTPAuth = !empty($this->smtp_username) && !empty($this->smtp_password);

         //$mail->AddAddress = "11@xx.com"; // Single Address
         //$mail->SMTPDebug = 2; // Show debug

         if(!empty($this->smtp_secure))
         {
            $mail->SMTPSecure = $this->smtp_secure;
         }

         if(!empty($this->smtp_sender_email))
         {
            $mail->From = $this->smtp_sender_email; 
            $mail->FromName = $this->smtp_sender_name;
            //$mail->SetFrom($this->smtp_sender_email, !empty($this->smtp_sender_name) ? $this->smtp_sender_name:'Sender');
         }

         if(!empty($this->smtp_reply_email))
         {
            $mail->AddReplyTo($this->smtp_reply_email, !empty($this->smtp_reply_email) ? $this->smtp_reply_email:'Reply');
         }

         foreach($to_addresses as $address)
         {
            if($address) {
               $mail->AddAddress($address);
            }
         }

         if(!empty($cc_to))
         {
            $mail->AddCC($cc_to);
         }

         if(!empty($attachment_path))
         {
            $attachment_filename = basename($attachment_path);
            $mail->AddAttachment($attachment_path, $attachment_filename);
         }

         $mail->Subject = $subject;
         $mail->Body = $message; 
         $result = $mail->send();
         //echo $mail->ErrorInfo;
         //print_array($result);
         //$result = 1;

         //TODO Save Email Log

         if($result == 1)
         {
            return TRUE;
         }
         else {
            return $result;
         }
      }
      else {
         exit('SMTP Setting not found.');
      }
   }
}