<?php

define('MONTH_EN', array("Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"));

define('MONTH_TH', array("ม.ค.","ก.พ.","มี.ค.","เม.ย.","พ.ค.","มิ.ย.","ก.ค.","ส.ค.","ก.ย.","ต.ค.","พ.ย.","ธ.ค."));

define('MONTH_EN_FULL', array("January","February","March","April","May","June","July","August","September","October","November","December"));

define('MONTH_TH_FULL', array("มกราคม","กุมภาพันธ์","มีนาคม","เมษายน","พฤษภาคม","มิถุนายน","กรกฎาคม","สิงหาคม","กันยายน","ตุลาคม","พฤศจิกายน","ธันวาคม"));

function get_month_thai_full($ymd)
{
   $m = date('m', strtotime($ymd));
   return MONTH_TH_FULL[$m];
}

function get_day_month_year($ymd)
{
   $d = (int)date('d', strtotime($ymd));
   $m = date('m', strtotime($ymd));
   $m = MONTH_TH[(int)$m-1];
   $y = date('y', strtotime($ymd));
   return "$d $m $y";
}

function month_year_thai($month, $year)
{
   $month = MONTH_TH_FULL[(int)$month - 1];
   $year = (int)$year + 543;
   return "$month $year";
}

function postdate($ymd = NULL)
{
   if(!empty($ymd)) {
      $d = (int)date('d', strtotime($ymd));
      $m = date('m', strtotime($ymd));
      $m = MONTH_EN[(int)$m-1];
      $y = date('Y', strtotime($ymd));
      return "$m, $d $y";
   }
}