<?php defined('BASEPATH') OR exit('No direct script access allowed');

/******************************************
 *
 ***** Base Model *****
 *
 *******************************************/
class MY_Model extends CI_Model
{
   protected $table_name = FALSE;
   protected $primary_key = 'id';
   protected $set_ref = FALSE;
   protected $user_id = FALSE;
   protected $user_email = FALSE;

   protected $is_ref = TRUE;

   public function __construct()
   {
      parent::__construct();
      $this->load->database();
   }

   /**
    * Listing all record
    *
    * @return mixed
    */
   public function listing($filters = NULL, $per_page = NULL, $offset = NULL)
   {
      $this->listing_filters($filters);

      $this->db->distinct();
      $this->db->select('n.*, u.firstname as admin');
      $this->db->order_by('n.'.$this->primary_key, 'DESC');
      $this->db->join('cms_users u', 'u.user_id=n.created_by', 'LEFT');
      if(!empty($per_page) ) {
         $this->db->limit($per_page, !empty($offset) ? $offset : 0);
      }
      $result = $this->db->get($this->table_name.' n')->result();
      return $result;
   }

   protected function listing_filters($filters = NULL)
   {
      if(!empty($filters))
      {
         if(!empty($filters['title']))
         {
            $this->db->like('n.title', input_to_sql($filters['title']));
         }
         if(!empty($filters['title_th']))
         {
            $this->db->like('n.title_th', input_to_sql($filters['title_th']));
         }
         if(!empty($filters['title_en']))
         {
            $this->db->like('n.title_en', input_to_sql($filters['title_en']));
         }
         if(!empty($filters['product_id']))
         {
            $this->db->where('n.product_id', input_to_sql($filters['product_id']));
         }
         if(!empty($filters['product_category_id']))
         {
            $this->db->where('n.product_category_id', input_to_sql($filters['product_category_id']));
         }
         if(!empty($filters['product_usage_id']))
         {
            $this->db->where('n.product_usage_id', input_to_sql($filters['product_usage_id']));
         }
         if(!empty($filters['product_type_id']))
         {
            $this->db->where('n.product_type_id', input_to_sql($filters['product_type_id']));
         } 
         if(!empty($filters['status']))
         {
            $this->db->where('n.status', $filters['status'] == 1 ? 1:0);
         }
         if(!empty($filters['highlight']))
         {
            $this->db->where('n.highlight', $filters['highlight'] == 1 ? 1:0);
         }
         if(!empty($filters['ids']))
         {
            $this->db->where_in('n.'.$this->primary_key, $filters['ids']);
         }
         if(!empty($filters['rewrite_url']))
         {
            $this->db->where('n.rewrite_url', input_to_sql($filters['rewrite_url']));
         }
      }
   }

   /**
    * Listing order by id
    *
    * @return mixed
    */
   public function listing_id($filters = NULL, $per_page = NULL, $offset = NULL)
   {
      $this->db->order_by('n.'.$this->primary_key, 'ASC');
      return $this->listing($filters, $per_page, $offset);
   }

   /**
    * Listing order by order_id
    *
    * @return mixed
    */
   public function listing_order($filters = NULL, $per_page = NULL, $offset = NULL)
   {
      $this->db->order_by('n.highlight', 'DESC');
      $this->db->order_by('n.orderid', 'ASC');
      return $this->listing($filters, $per_page, $offset);
   }

   /**
    * Listing key
    *
    * @return mixed
    */
   public function listing_key($parent_field, $parent_id, $item_id)
   {
      $this->db->select($item_id);
      $this->db->where($parent_field, $parent_id);
      $result = $this->db->get($this->table_name)->result();
      $ids = [];
      if(!empty($result)) {
         foreach ($result as $row)
         {
            $ids[] = $row->$item_id;
         }
      }
      return $ids;
   }

   /**
    * Listing key
    *
    * @return mixed
    */
   public function listing_detail($parent_field, $parent_id, $item_id)
   {
      $this->db->select([$item_id, 'detail']);
      $this->db->where($parent_field, $parent_id);
      $result = $this->db->get($this->table_name)->result();
      $ids = [];
      if(!empty($result)) {
         foreach ($result as $row)
         {
            $ids[$row->$item_id] = $row->detail;
         }
      }
      return $ids;
   }

   /**
    * Read a record by id
    *
    * @param $id
    * @return mixed
    */
   public function read($id, $filters = NULL)
   {
      $this->db->select('n.*, u.firstname as admin');
      $this->db->where('n.'.$this->primary_key, input_to_sql($id));

      $this->read_filters($filters);

      $this->db->join('cms_users u', 'u.user_id=n.created_by', 'LEFT');
      $row = $this->db->get($this->table_name.' n')->row();
      return $row;
   }

   /**
    * Read lastest record
    *
    * @param $id
    * @return mixed
    */
   public function read_lastest($filters = NULL)
   {
      $this->db->select('n.*, u.firstname as admin');
      $this->db->order_by('n.'.$this->primary_key, 'DESC');
      $this->db->limit(1, 0);

      $this->read_filters($filters);

      $this->db->join('cms_users u', 'u.user_id=n.created_by', 'LEFT');
      $row = $this->db->get($this->table_name.' n')->row();
      return $row;
   }

   /**
    * Read a record by rewrite_url
    *
    * @param $id
    * @return mixed
    */
   public function read_url($rewrite_url, $filters = NULL)
   {
      $this->db->select('n.*, u.firstname as admin');
      $this->db->where('n.rewrite_url', input_to_sql($rewrite_url));

      $this->read_filters($filters);

      $this->db->join('cms_users u', 'u.user_id=n.created_by', 'LEFT');
      $row = $this->db->get($this->table_name.' n')->row();
      return $row;
   }

   protected function read_filters($filters = NULL)
   {
      if(!empty($filters))
      {
         if(!empty($filters['status']))
         {
            $this->db->where('n.status', $filters['status'] == 1 ? 1:0);
         }
      }
   }

   /**
    * Read field record
    *
    * @param $id
    * @return mixed
    */
   public function read_field($field, $id)
   {
      $this->db->select('n.*, u.firstname as admin');
      $this->db->order_by('n.'.$this->primary_key, 'DESC');
      $this->db->where('n.'.$field, $id);
      $this->db->limit(1, 0);

      $this->db->join('cms_users u', 'u.user_id=n.created_by', 'LEFT');
      $row = $this->db->get($this->table_name.' n')->row();
      return $row;
   }

   /**
    * Create new record
    *
    * @param $data
    * @param bool $set_ref
    * @return mixed
    */
   public function create(&$data, $set_ref = FALSE)
   {
      if(($set_ref || $this->set_ref) && !empty($data->created_by))
      {
         $this->create_ref($data->created_by);
      }
      unset($data->exclude);
      unset($data->created_by);

      $this->db->insert($this->table_name, $data);
      //echo $this->db->last_query();
      $last_id = $this->db->insert_id();
      return $last_id;
   }

   /**
    * Update a record by id
    *
    * @param $data
    * @param bool $set_ref
    * @return mixed
    */
   public function update(&$data, $set_ref = FALSE)
   {
      $primary_name = $this->primary_key;
      $primary_id = $data->$primary_name;

      if(($set_ref || $this->set_ref) && !empty($data->created_by))
      {
         $this->create_ref($data->created_by, TRUE);
      }
      //unset($data->user_id);
      unset($data->exclude);
      unset($data->created_by);
      unset($data->$primary_name);

      $this->db->where($this->primary_key, $primary_id);
      $this->db->update($this->table_name, $data);
      //echo $this->db->last_query();
      return $primary_id;
   }

   /**
    * Remove a record by id
    */
   public function delete($ids, $filters = NULL)
   {
      if(isset($ids) && !empty($ids) && is_array($ids))
      {
         $this->db->where_in($this->primary_key, $ids);

         $this->delete_filters($filters);

         $this->db->delete($this->table_name);
      }
   }

   protected function delete_filters($filters = NULL)
   {
   }

   /**
    * Base : delete by parent
    */
   public function delete_parent($parent_field, $parent_id)
   {
      $this->db->where($parent_field, $parent_id);
      $this->db->delete($this->table_name);
   }

   /**
    * Status enable/disable
    */
   public function status($ids, $data)
   {
      if(isset($ids) && !empty($ids) && is_array($ids) && !empty($data))
      {
         foreach($ids as $id)
         {
            $new_data = new stdClass();
            $new_data->status = $data->status == 1 ? 1 : 0;

            $this->create_ref($data->created_by, $this->set_ref);

            $this->db->where($this->primary_key, $id);
            $this->db->update($this->table_name, $new_data);
         }
      }
   }

   /**
    * Status Make-highlight/Un-highlight
    */
   public function highlight($ids, $highlight, $data)
   {
      if(isset($ids) && !empty($ids) && is_array($ids) && !empty($data))
      {
         foreach($ids as $id)
         {
            $new_data = new stdClass();
            $new_data->highlight = $highlight == 1 ? 1 : 0;
            if($highlight == 1)
            {
               $new_data->highlight = 1;
            }
            else {
               $new_data->highlight = NULL;
               $new_data->orderid = NULL;
            }

            $this->create_ref($data->created_by,$this->set_ref);

            $this->db->where($this->primary_key, $id);
            $this->db->update($this->table_name, $new_data);
         }
      }
   }

   /**
    * Re-order Highlight
    */
   public function reorder($ids, $data)
   {
      if(isset($ids) && !empty($ids) && is_array($ids))
      {
         $n=1;
         foreach($ids as $id)
         {
            $new_data = new stdClass();
            $new_data->orderid = $n;
            $new_data->highlight = 1;

            $this->create_ref($data->created_by,$this->set_ref);

            $this->db->where($this->primary_key, $id);
            $this->db->update($this->table_name, $new_data);
            $n++;
         }
      }
   }

   /**
    * Re-order Item
    */
   public function reorder_item($ids, $data, $del = [])
   {
      if(!empty($del))
      {
         $this->delete($del);
      }
      if(isset($ids) && !empty($ids) && is_array($ids))
      {
         $n=1;
         foreach($ids as $id)
         {
            $new_data = new stdClass();
            $new_data->orderid = $n;

            $this->create_ref($data->created_by,$this->set_ref);

            $this->db->where($this->primary_key, $id);
            $this->db->update($this->table_name, $new_data);
            $n++;
         }
      }
   }

   /**
    * Re-order rows
    */
   public function reorder_rows($orderids, $data)
   {
      foreach($orderids as $id => $orderid)
      {
         $new_data = new stdClass();
         $new_data->orderid = !empty($orderid) ? $orderid:99999;

         $this->create_ref($data->created_by,$this->set_ref);

         $this->db->where($this->primary_key, $id);
         $this->db->update($this->table_name, $new_data);
      }
   }

   /**
    * Re-order rows
    */
   public function reorder_change($new_value, $current_id, $data)
   {
      if($new_value == 1) {
         $new_data = new stdClass();
         $new_data->orderid = 1;
         $this->create_ref($data->created_by,$this->set_ref);
         $this->db->where($this->primary_key, $current_id);
         $this->db->update($this->table_name, $new_data);

         $this->db->where_not_in($this->primary_key, [$current_id]);
         $this->db->order_by("orderid", "ASC");
         $result = $this->db->get($this->table_name)->result();
         if(!empty($result))
         {
            $n=2;
            foreach($result as $rs)
            {
               $key = $this->primary_key;
               $id = $rs->$key;
               $new_data = new stdClass();
               $new_data->orderid = $n;
               $this->create_ref($data->created_by,$this->set_ref);
               $this->db->where($this->primary_key, $id);
               $this->db->update($this->table_name, $new_data);
               //echo $id."<br />";
               $n++;
            }
         }
      }
      else {

         $this->db->select_max("orderid");
         $row = $this->db->get($this->table_name)->row();
         $max_orderid = $row->orderid;

         $this->db->select("orderid");
         $this->db->where($this->primary_key, $current_id);
         $row = $this->db->get($this->table_name)->row();
         $org_orderid = $row->orderid;

         if($new_value >= $max_orderid) {
            $new_data = new stdClass();
            $new_data->orderid = $max_orderid;
            $this->create_ref($data->created_by,$this->set_ref);
            $this->db->where($this->primary_key, $current_id);
            $this->db->update($this->table_name, $new_data);

            $this->db->where_not_in($this->primary_key, [$current_id]);
            $this->db->order_by("orderid", "ASC");
            $result = $this->db->get($this->table_name)->result();

            if(!empty($result))
            {
               $n=1;
               foreach($result as $rs)
               {
                  $key = $this->primary_key;
                  $id = $rs->$key;
                  $new_data = new stdClass();
                  $new_data->orderid = $n;
                  $this->create_ref($data->created_by,$this->set_ref);
                  $this->db->where($this->primary_key, $id);
                  $this->db->update($this->table_name, $new_data);
                  $n++;
               }

               $input_orderid = $this->input->post('orderid');
               if(!empty($input_orderid))
               {
                  $new_data = new stdClass();
                  $new_data->orderid = count($result)+1;
                  $this->create_ref($data->created_by,$this->set_ref);
                  $this->db->where($this->primary_key, $current_id);
                  $this->db->update($this->table_name, $new_data);
               }
            }
         }
         else if($new_value > $org_orderid) {
            $this->db->where("orderid <=", $new_value);
            $this->db->where("orderid >=", $org_orderid);
            $this->db->order_by("orderid", "ASC");
            $result = $this->db->get($this->table_name)->result();
            if(!empty($result))
            {
               foreach($result as $rs)
               {
                  $key = $this->primary_key;
                  $id = $rs->$key;
                  $new_data = new stdClass();
                  $new_data->orderid = $rs->orderid - 1;
                  $this->create_ref($data->created_by,$this->set_ref);
                  $this->db->where($this->primary_key, $id);
                  $this->db->update($this->table_name, $new_data);
               }
            }

            $new_data = new stdClass();
            $new_data->orderid = $new_value;
            $this->create_ref($data->created_by,$this->set_ref);
            $this->db->where($this->primary_key, $current_id);
            $this->db->update($this->table_name, $new_data);
         }
         else if($new_value < $org_orderid) {
            $this->db->where("orderid >=", $new_value);
            $this->db->where("orderid <", $org_orderid);
            $this->db->order_by("orderid", "ASC");
            $result = $this->db->get($this->table_name)->result();
            if(!empty($result))
            {
               foreach($result as $rs)
               {
                  $key = $this->primary_key;
                  $id = $rs->$key;
                  $new_data = new stdClass();
                  $new_data->orderid = $rs->orderid + 1;
                  $this->create_ref($data->created_by,$this->set_ref);
                  $this->db->where($this->primary_key, $id);
                  $this->db->update($this->table_name, $new_data);
               }
            }

            $new_data = new stdClass();
            $new_data->orderid = $new_value;
            $this->create_ref($data->created_by,$this->set_ref);
            $this->db->where($this->primary_key, $current_id);
            $this->db->update($this->table_name, $new_data);
         }
         else {
            $input_orderid = $this->input->post('orderid');
            if(!empty($input_orderid))
            {
               $this->db->where('orderid >=', $input_orderid);
               $this->db->where_not_in($this->primary_key, [$current_id]);
               $this->db->order_by("orderid", "ASC");
               $result = $this->db->get($this->table_name)->result();
               $x=$input_orderid+1;
               foreach($result as $rs)
               {
                  $key = $this->primary_key;
                  $id = $rs->$key;
                  $new_data = new stdClass();
                  $new_data->orderid = $x;
                  $this->create_ref($data->created_by,$this->set_ref);
                  $this->db->where($this->primary_key, $id);
                  $this->db->update($this->table_name, $new_data);
                  $x++;
               }

               $new_data = new stdClass();
               $new_data->orderid = $input_orderid;
               $this->create_ref($data->created_by,$this->set_ref);
               $this->db->where($this->primary_key, $current_id);
               $this->db->update($this->table_name, $new_data);
            }
         }
      }
   }

   /**
    * @param array $condition
    * @param null $not_condition
    * @return bool
    *
    * EX. $condition = [
    *    'field' => 'email',
    *    'value' => 'a@gmail.com'
    * ]
    */
   public function existing($field, $value, $exclude = '')
   {
      $this->db->select('id');
      $this->db->where($field, $value);

      if(!empty($exclude))
      {
         $this->db->where_not_in($field, $exclude);
      }

      $this->db->from($this->table_name);
      $row_count = $this->db->count_all_results();

      return ($row_count > 0);
   }

   //----------------------------------------------
   // -------------- Query Utilities --------------
   //----------------------------------------------

   /**
    * Show a sql query string
    *
    * @return string
    */
   public function show_last_query()
   {
      return $this->db->last_query();
   }

   /**
    * Show all sql query string
    *
    * @return string
    */
   public function show_all_query()
   {
      return implode('\n\n', $this->db->all_query());
   }

   /**
    * Create reference record
    *
    * @param bool $is_update
    * @param array $ref_fields
    */
   protected function create_ref($created_by, $is_update = FALSE)
   {
      if($this->is_ref)
      {
         if($is_update)
         {
            $ref_fields['updated_at'] = datetime_now();
            if($created_by > 0) {
               $ref_fields['updated_by'] = $created_by;
            }
            $ref_fields['updated_ip'] = $this->input->ip_address();
         }else{
            $ref_fields['created_at'] = datetime_now();
            $ref_fields['updated_at'] = $ref_fields['created_at'];
            if($created_by > 0) {
               $ref_fields['created_by'] = $created_by;
               $ref_fields['updated_by'] = $created_by;
            }
            $ref_fields['created_ip'] = $this->input->ip_address();
            $ref_fields['updated_ip'] = $ref_fields['created_ip'];
         }

         foreach($ref_fields as $field => $value)
         {
            $this->db->set($field, $value);
         }
      }
   }

}

/******************************************
 *
 ***** Frontend Model *****
 *
 *******************************************/
class Frontend_Model extends MY_Model
{
   protected $current_lang = DEFAULT_LANG;

   public function __construct()
   {
      parent::__construct();

      //LANGUAGE
      $this->current_lang();
   }

   private function current_lang()
   {
      $lang = $this->uri->segment(1);
      if(!empty($lang) && in_array($lang, AVAILABLE_LANG))
      {
         $this->current_lang = $lang;
      }
      else {
         $this->current_lang = DEFAULT_LANG;
      }
   }

   /**
    * Listing all record
    *
    * @return mixed
    */
   public function listing($filters = NULL, $per_page = NULL, $offset = NULL)
   {
      $this->listing_filters($filters);

      $this->db->distinct();
      $this->db->select('n.*');
      $this->db->where('n.status', GLOBAL_STATUS_ENABLED);
      $this->db->order_by('n.'.$this->primary_key, 'DESC');
      if(!empty($per_page) ) {
         $this->db->limit($per_page, !empty($offset) ? $offset : 0);
      }
      $result = $this->db->get($this->table_name.' n')->result();
      //echo $this->db->last_query();
      return $result;
   }

   /**
    * Read a record by id
    *
    * @param $id
    * @return mixed
    */
   public function read($id, $filters = NULL)
   {
      $this->db->select('n.*');
      $this->db->where('n.'.$this->primary_key, input_to_sql($id));
      $this->db->where('n.status', GLOBAL_STATUS_ENABLED);

      $this->read_filters($filters);

      $row = $this->db->get($this->table_name.' n')->row();
      return $row;
   }

   /**
    * Read lastest record
    *
    * @param $id
    * @return mixed
    */
   public function read_lastest($filters = NULL)
   {
      $this->db->select('n.*');
      $this->db->where('n.status', GLOBAL_STATUS_ENABLED);
      $this->db->order_by('n.'.$this->primary_key, 'DESC');
      $this->db->limit(1, 0);

      $this->read_filters($filters);

      $row = $this->db->get($this->table_name.' n')->row();
      return $row;
   }

   /**
    * Read a record by rewrite_url
    *
    * @param $id
    * @return mixed
    */
   public function read_url($rewrite_url, $filters = NULL)
   {
      $this->db->select('n.*');
      $this->db->where('n.rewrite_url', input_to_sql(urldecode($rewrite_url)));
      $this->db->where('n.status', GLOBAL_STATUS_ENABLED);

      $this->read_filters($filters);

      $row = $this->db->get($this->table_name.' n')->row();
      return $row;
   }

   /**
    * Read a record by parent
    *
    * @param $id
    * @return mixed
    */
   public function listing_parent($parent_key, $parent_id, $filters = NULL)
   {
      $this->db->select('n.*');
      $this->db->where('n.'.$parent_key, input_to_sql($parent_id));
      $this->db->where('n.status', GLOBAL_STATUS_ENABLED);
      $this->db->order_by('n.orderid', 'ASC');

      $this->listing_filters($filters);

      $result = $this->db->get($this->table_name.' n')->result();
      return $result;
   }
}