<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Product_item extends Frontend_Rest
{
   public $base_model = 'front/product_item_model';
   public $menu_ctl = 'product_item';
   protected $primary_key = 'product_item_id';

   function __construct()
   {
      parent::__construct();
   }

   public function get_od() {
      $this->load->model('front/product_item_model');
      $product_id = $this->input->get('product_id');

      $data = [];
      if(!empty($product_id)) {
         $filter_item['product_id'] = $product_id;
         $listing = $this->product_item_model->listing_order($filter_item);
         if(!empty($listing)) {
            $arr = [];
            foreach ($listing as $rs) {
               if(!empty($rs->od)) {
                  $arr[] = $rs->od;
               }
            }
            foreach ($arr as $a) {
               if(!in_array($a, $data)) {
                  $data[] = $a;
               }
            }
         }
      }

      return $this->success($data);
   }

   public function get_length() {
      $this->load->model('front/product_item_model');
      $product_id = $this->input->get('product_id');
      $od = $this->input->get('od');

      $data = [];
      if(!empty($product_id) && !empty($od)) {
         $filter_item['product_id'] = $product_id;
         $listing = $this->product_item_model->listing_order($filter_item);
         if(!empty($listing)) {
            foreach ($listing as $rs) {
               if($od == $rs->od) {
                  $data[] = $rs->length;
               }
            }
         }
      }

      return $this->success(array_unique($data));
   }

   public function get_item() {
      $this->load->model('front/product_item_model');
      $product_id = $this->input->get('product_id');
      $od = $this->input->get('od');
      $length = $this->input->get('length');

      $data = [];
      if(!empty($product_id) && !empty($od)) {
         $filter_item['product_id'] = $product_id;
         $filter_item['od'] = $od;
         $filter_item['length'] = $length;
         $data = $this->product_item_model->listing_order($filter_item);
      }
      else if(!empty($product_id)) {
         $filter_item['product_id'] = $product_id;
         $data = $this->product_item_model->listing_order($filter_item);
      }

      if(!empty($data)) {
         foreach ($data as $row) {
            $row->code = output_text($row->code);
            $row->od = output_text($row->od);
            $row->length = output_text($row->length);
            $row->hole = output_text($row->hole);
            $row->depth = output_text($row->depth);
            $row->strength = output_text($row->strength);
            $row->shear = output_text($row->shear);
            $row->column1 = output_text($row->column1);
            $row->column2 = output_text($row->column2);
            $row->column3 = output_text($row->column3);
            $row->column4 = output_text($row->column4);
            $row->column5 = output_text($row->column5);
            $row->column6 = output_text($row->column6);
            $row->column7 = output_text($row->column7);
            $row->column8 = output_text($row->column8);
            $row->column9 = output_text($row->column9);
            $row->column10 = output_text($row->column10);
         }
      }

      return $this->success($data);
   }

   public function get_item_mobile() {
      $this->load->model('front/product_item_model');
      $this->load->model('front/product_item_column_model');
      $product_id = $this->input->get('product_id');
      $od = $this->input->get('od');
      $length = $this->input->get('length');

      $row = [];
      if(!empty($product_id) && !empty($od)) {
         $filter_item['product_id'] = $product_id;
         $filter_item['od'] = $od;
         $filter_item['length'] = $length;
         $data = $this->product_item_model->listing_order($filter_item);

         $row = $data[0];

         $row->code = output_text($row->code);
         $row->od = output_text($row->od);
         $row->length = output_text($row->length);
         $row->hole = output_text($row->hole);
         $row->depth = output_text($row->depth);
         $row->strength = output_text($row->strength);
         $row->shear = output_text($row->shear);
         $row->column1 = output_text($row->column1);
         $row->column2 = output_text($row->column2);
         $row->column3 = output_text($row->column3);
         $row->column4 = output_text($row->column4);
         $row->column5 = output_text($row->column5);
         $row->column6 = output_text($row->column6);
         $row->column7 = output_text($row->column7);
         $row->column8 = output_text($row->column8);
         $row->column9 = output_text($row->column9);
         $row->column10 = output_text($row->column10);

         $column_name = $this->product_item_column_model->read_by_product($product_id);
         if(!empty($column_name)) {
            $row->column1_name = output_text($column_name->column1);
            $row->column2_name = output_text($column_name->column2);
            $row->column3_name = output_text($column_name->column3);
            $row->column4_name = output_text($column_name->column4);
            $row->column5_name = output_text($column_name->column5);
            $row->column6_name = output_text($column_name->column6);
            $row->column7_name = output_text($column_name->column7);
            $row->column8_name = output_text($column_name->column8);
            $row->column9_name = output_text($column_name->column9);
            $row->column10_name = output_text($column_name->column10);
         }
      }

      return $this->success($row);
   }
}